/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.guava30.shaded.common.graph;

import org.apache.kylin.guava30.shaded.common.annotations.Beta;
import org.apache.kylin.guava30.shaded.common.base.Optional;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.graph.AbstractGraphBuilder;
import org.apache.kylin.guava30.shaded.common.graph.ElementOrder;
import org.apache.kylin.guava30.shaded.common.graph.Graph;
import org.apache.kylin.guava30.shaded.common.graph.Graphs;
import org.apache.kylin.guava30.shaded.common.graph.ImmutableGraph;
import org.apache.kylin.guava30.shaded.common.graph.MutableGraph;
import org.apache.kylin.guava30.shaded.common.graph.StandardMutableGraph;
import org.apache.kylin.guava30.shaded.errorprone.annotations.DoNotMock;

@DoNotMock
@Beta
public final class GraphBuilder<N>
extends AbstractGraphBuilder<N> {
    private GraphBuilder(boolean directed) {
        super(directed);
    }

    public static GraphBuilder<Object> directed() {
        return new GraphBuilder<Object>(true);
    }

    public static GraphBuilder<Object> undirected() {
        return new GraphBuilder<Object>(false);
    }

    public static <N> GraphBuilder<N> from(Graph<N> graph) {
        return new GraphBuilder<N>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder()).incidentEdgeOrder(graph.incidentEdgeOrder());
    }

    public <N1 extends N> ImmutableGraph.Builder<N1> immutable() {
        GraphBuilder<N1> castBuilder = this.cast();
        return new ImmutableGraph.Builder<N1>(castBuilder);
    }

    public GraphBuilder<N> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    public GraphBuilder<N> expectedNodeCount(int expectedNodeCount) {
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative(expectedNodeCount));
        return this;
    }

    public <N1 extends N> GraphBuilder<N1> nodeOrder(ElementOrder<N1> nodeOrder) {
        GraphBuilder<N1> newBuilder = this.cast();
        newBuilder.nodeOrder = Preconditions.checkNotNull(nodeOrder);
        return newBuilder;
    }

    public <N1 extends N> GraphBuilder<N1> incidentEdgeOrder(ElementOrder<N1> incidentEdgeOrder) {
        Preconditions.checkArgument(incidentEdgeOrder.type() == ElementOrder.Type.UNORDERED || incidentEdgeOrder.type() == ElementOrder.Type.STABLE, "The given elementOrder (%s) is unsupported. incidentEdgeOrder() only supports ElementOrder.unordered() and ElementOrder.stable().", incidentEdgeOrder);
        GraphBuilder<N1> newBuilder = this.cast();
        newBuilder.incidentEdgeOrder = Preconditions.checkNotNull(incidentEdgeOrder);
        return newBuilder;
    }

    public <N1 extends N> MutableGraph<N1> build() {
        return new StandardMutableGraph(this);
    }

    GraphBuilder<N> copy() {
        GraphBuilder<N> newBuilder = new GraphBuilder<N>(this.directed);
        newBuilder.allowsSelfLoops = this.allowsSelfLoops;
        newBuilder.nodeOrder = this.nodeOrder;
        newBuilder.expectedNodeCount = this.expectedNodeCount;
        newBuilder.incidentEdgeOrder = this.incidentEdgeOrder;
        return newBuilder;
    }

    private <N1 extends N> GraphBuilder<N1> cast() {
        return this;
    }
}

