/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.LogReplay;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001B\u001a5\u0001\u0005C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\")A\u000b\u0001C\u0001+\"9\u0011\f\u0001a\u0001\n\u0013Q\u0006b\u00020\u0001\u0001\u0004%Ia\u0018\u0005\u0007K\u0002\u0001\u000b\u0015B.\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\"9\u0001\u000e\u0001a\u0001\n\u0013I\u0007BB6\u0001A\u0003&Q\nC\u0004m\u0001\u0001\u0007I\u0011B7\t\u000fE\u0004\u0001\u0019!C\u0005e\"1A\u000f\u0001Q!\n9Dq!\u001e\u0001C\u0002\u0013%a\u000fC\u0004\u0002\u001c\u0001\u0001\u000b\u0011B<\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0001\u0002\u0003B\n\u0001\u0001\u0006I!!\t\t\u0013\tU\u0001A1A\u0005\n\t]\u0001\u0002\u0003B\u0011\u0001\u0001\u0006IA!\u0007\t\u000f\t\r\u0002\u0001\"\u0011\u0003&!9!1\t\u0001\u0005\n\t\u0015\u0003\u0002\u0003B*\u0001\u0011\u0005aG!\u0016\t\u000f\te\u0003\u0001\"\u0011\u0003\\!A!Q\f\u0001\u0005\u0002Y\u0012yfB\u0004\u0002(QB\t!!\u000b\u0007\rM\"\u0004\u0012AA\u0016\u0011\u0019!\u0016\u0004\"\u0001\u0002.\u00191\u0011qF\rC\u0003cA!\"a\u0010\u001c\u0005+\u0007I\u0011AA!\u0011)\t\u0019f\u0007B\tB\u0003%\u00111\t\u0005\u000b\u0003+Z\"Q3A\u0005\u0002\u0005]\u0003BCA.7\tE\t\u0015!\u0003\u0002Z!1Ak\u0007C\u0001\u0003;B\u0011\"a\u001a\u001c\u0003\u0003%\t!!\u001b\t\u0013\u0005=4$%A\u0005\u0002\u0005E\u0004\"CAD7E\u0005I\u0011AAE\u0011%\tiiGA\u0001\n\u0003\ny\tC\u0005\u0002\u001cn\t\t\u0011\"\u0001\u0002\u001e\"I\u0011QU\u000e\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003c[\u0012\u0011!C!\u0003gC\u0011\"!0\u001c\u0003\u0003%\t!a0\t\u0013\u0005%7$!A\u0005B\u0005-\u0007\"CAg7\u0005\u0005I\u0011IAh\u0011%\t\tnGA\u0001\n\u0003\n\u0019nB\u0005\u0002Xf\t\t\u0011#\u0001\u0002Z\u001aI\u0011qF\r\u0002\u0002#\u0005\u00111\u001c\u0005\u0007)6\"\t!!;\t\u0013\u00055W&!A\u0005F\u0005=\u0007\"CAv[\u0005\u0005I\u0011QAw\u0011%\t\u00190LA\u0001\n\u0003\u000b)\u0010C\u0005\u0003\u00045\n\t\u0011\"\u0003\u0003\u0006\t\t\u0012J\\'f[>\u0014\u0018\u0010T8h%\u0016\u0004H.Y=\u000b\u0005U2\u0014aB1di&|gn\u001d\u0006\u0003oa\nQ\u0001Z3mi\u0006T!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<y\u0005)1\u000f]1sW*\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\"I!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fMB\u0011\u0011JS\u0007\u0002i%\u00111\n\u000e\u0002\n\u0019><'+\u001a9mCf\f\u0011$\\5o\r&dWMU3uK:$\u0018n\u001c8US6,7\u000f^1naB\u00111IT\u0005\u0003\u001f\u0012\u0013A\u0001T8oO\u0006\u0019S.\u001b8TKR$&/\u00198tC\u000e$\u0018n\u001c8SKR,g\u000e^5p]RKW.Z:uC6\u0004\bcA\"S\u001b&\u00111\u000b\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r1v\u000b\u0017\t\u0003\u0013\u0002AQ\u0001T\u0002A\u00025CQ\u0001U\u0002A\u0002E\u000bacY;se\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u00027B\u0011\u0011\nX\u0005\u0003;R\u0012\u0001\u0002\u0015:pi>\u001cw\u000e\\\u0001\u001bGV\u0014(/\u001a8u!J|Go\\2pYZ+'o]5p]~#S-\u001d\u000b\u0003A\u000e\u0004\"aQ1\n\u0005\t$%\u0001B+oSRDq\u0001Z\u0003\u0002\u0002\u0003\u00071,A\u0002yIE\nqcY;se\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0011\u0002\u001d\r,(O]3oiZ+'o]5p]V\tQ*\u0001\ndkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8`I\u0015\fHC\u00011k\u0011\u001d!\u0007\"!AA\u00025\u000bqbY;se\u0016tGOV3sg&|g\u000eI\u0001\u0010GV\u0014(/\u001a8u\u001b\u0016$\u0018\rR1uCV\ta\u000e\u0005\u0002J_&\u0011\u0001\u000f\u000e\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006\u00192-\u001e:sK:$X*\u001a;b\t\u0006$\u0018m\u0018\u0013fcR\u0011\u0001m\u001d\u0005\bI.\t\t\u00111\u0001o\u0003A\u0019WO\u001d:f]RlU\r^1ECR\f\u0007%\u0001\u0007ue\u0006t7/Y2uS>t7/F\u0001x!\u0015AXp`A\u000b\u001b\u0005I(B\u0001>|\u0003\u001diW\u000f^1cY\u0016T!\u0001 #\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u007fs\n9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u0001\u0003\u001fqA!a\u0001\u0002\fA\u0019\u0011Q\u0001#\u000e\u0005\u0005\u001d!bAA\u0005\u0001\u00061AH]8pizJ1!!\u0004E\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA\n\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0002#\u0011\u0007%\u000b9\"C\u0002\u0002\u001aQ\u0012abU3u)J\fgn]1di&|g.A\u0007ue\u0006t7/Y2uS>t7\u000fI\u0001\fC\u000e$\u0018N^3GS2,7/\u0006\u0002\u0002\"A1\u00010`A\u0012\u0005\u001b\u00012!!\n\u001c\u001d\tI\u0005$A\tJ]6+Wn\u001c:z\u0019><'+\u001a9mCf\u0004\"!S\r\u0014\u0005e\u0011ECAA\u0015\u0005U)f.[9vK\u001aKG.Z!di&|g\u000eV;qY\u0016\u001cba\u0007\"\u00024\u0005e\u0002cA\"\u00026%\u0019\u0011q\u0007#\u0003\u000fA\u0013x\u000eZ;diB\u00191)a\u000f\n\u0007\u0005uBI\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004gS2,WKU%\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0004]\u0016$(BAA'\u0003\u0011Q\u0017M^1\n\t\u0005E\u0013q\t\u0002\u0004+JK\u0015\u0001\u00034jY\u0016,&+\u0013\u0011\u0002#\u0011,G.\u001a;j_:4Vm\u0019;peV\u0013\u0016*\u0006\u0002\u0002ZA\u00191IU@\u0002%\u0011,G.\u001a;j_:4Vm\u0019;peV\u0013\u0016\n\t\u000b\u0007\u0003?\n\u0019'!\u001a\u0011\u0007\u0005\u00054$D\u0001\u001a\u0011\u001d\ty\u0004\ta\u0001\u0003\u0007Bq!!\u0016!\u0001\u0004\tI&\u0001\u0003d_BLHCBA0\u0003W\ni\u0007C\u0005\u0002@\u0005\u0002\n\u00111\u0001\u0002D!I\u0011QK\u0011\u0011\u0002\u0003\u0007\u0011\u0011L\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019H\u000b\u0003\u0002D\u0005U4FAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005E)\u0001\u0006b]:|G/\u0019;j_:LA!!\"\u0002|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0012\u0016\u0005\u00033\n)(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0003B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bY%\u0001\u0003mC:<\u0017\u0002BA\t\u0003+\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a(\u0011\u0007\r\u000b\t+C\u0002\u0002$\u0012\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!+\u00020B\u00191)a+\n\u0007\u00055FIA\u0002B]fD\u0001\u0002\u001a\u0014\u0002\u0002\u0003\u0007\u0011qT\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0017\t\u0007\u0003o\u000bI,!+\u000e\u0003mL1!a/|\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005\u0017q\u0019\t\u0004\u0007\u0006\r\u0017bAAc\t\n9!i\\8mK\u0006t\u0007\u0002\u00033)\u0003\u0003\u0005\r!!+\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!%\u0002\r\u0015\fX/\u00197t)\u0011\t\t-!6\t\u0011\u0011\\\u0013\u0011!a\u0001\u0003S\u000bQ#\u00168jcV,g)\u001b7f\u0003\u000e$\u0018n\u001c8UkBdW\rE\u0002\u0002b5\u001aR!LAo\u0003s\u0001\"\"a8\u0002f\u0006\r\u0013\u0011LA0\u001b\t\t\tOC\u0002\u0002d\u0012\u000bqA];oi&lW-\u0003\u0003\u0002h\u0006\u0005(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011\u0011\\\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003?\ny/!=\t\u000f\u0005}\u0002\u00071\u0001\u0002D!9\u0011Q\u000b\u0019A\u0002\u0005e\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\fy\u0010\u0005\u0003D%\u0006e\bcB\"\u0002|\u0006\r\u0013\u0011L\u0005\u0004\u0003{$%A\u0002+va2,'\u0007C\u0005\u0003\u0002E\n\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000f\u0001B!a%\u0003\n%!!1BAK\u0005\u0019y%M[3diB\u0019\u0011Ja\u0004\n\u0007\tEAGA\u0004BI\u00124\u0015\u000e\\3\u0002\u0019\u0005\u001cG/\u001b<f\r&dWm\u001d\u0011\u0002\u0015Q|WNY:u_:,7/\u0006\u0002\u0003\u001aA1\u00010`A\u0012\u00057\u00012!\u0013B\u000f\u0013\r\u0011y\u0002\u000e\u0002\u000b%\u0016lwN^3GS2,\u0017a\u0003;p[\n\u001cHo\u001c8fg\u0002\na!\u00199qK:$G#\u00021\u0003(\t-\u0002B\u0002B\u0015'\u0001\u0007Q*A\u0004wKJ\u001c\u0018n\u001c8\t\rU\u001a\u0002\u0019\u0001B\u0017!\u0019\u0011yC!\u000f\u0003>9!!\u0011\u0007B\u001b\u001d\u0011\t)Aa\r\n\u0003\u0015K1Aa\u000eE\u0003\u001d\u0001\u0018mY6bO\u0016LA!a/\u0003<)\u0019!q\u0007#\u0011\u0007%\u0013y$C\u0002\u0003BQ\u0012a!Q2uS>t\u0017!D4fiR{WNY:u_:,7/\u0006\u0002\u0003HA1!q\u0006B%\u0005\u001bJAAa\u0013\u0003<\tA\u0011\n^3sC\ndW\rE\u0002J\u0005\u001fJ1A!\u00155\u0005)1\u0015\u000e\\3BGRLwN\\\u0001\u0010O\u0016$HK]1og\u0006\u001cG/[8ogV\u0011!q\u000b\t\u0007\u0005_\u0011I%!\u0006\u0002\u0015\rDWmY6q_&tG/\u0006\u0002\u0003.\u0005A\u0011\r\u001c7GS2,7/\u0006\u0002\u0003bA1!q\u0006B2\u0005\u001bIAA!\u001a\u0003<\t\u00191+Z9")
public class InMemoryLogReplay
implements LogReplay {
    private final long minFileRetentionTimestamp;
    private final Option<Object> minSetTransactionRetentionTimestamp;
    private Protocol currentProtocolVersion;
    private long currentVersion;
    private Metadata currentMetaData;
    private final HashMap<String, SetTransaction> transactions;
    private final HashMap<UniqueFileActionTuple, AddFile> activeFiles;
    private final HashMap<UniqueFileActionTuple, RemoveFile> tombstones;

    private Protocol currentProtocolVersion() {
        return this.currentProtocolVersion;
    }

    private void currentProtocolVersion_$eq(Protocol x$1) {
        this.currentProtocolVersion = x$1;
    }

    private long currentVersion() {
        return this.currentVersion;
    }

    private void currentVersion_$eq(long x$1) {
        this.currentVersion = x$1;
    }

    private Metadata currentMetaData() {
        return this.currentMetaData;
    }

    private void currentMetaData_$eq(Metadata x$1) {
        this.currentMetaData = x$1;
    }

    private HashMap<String, SetTransaction> transactions() {
        return this.transactions;
    }

    private HashMap<UniqueFileActionTuple, AddFile> activeFiles() {
        return this.activeFiles;
    }

    private HashMap<UniqueFileActionTuple, RemoveFile> tombstones() {
        return this.tombstones;
    }

    @Override
    public void append(long version, Iterator<Action> actions) {
        Predef$.MODULE$.assert(this.currentVersion() == -1L || version == this.currentVersion() + 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Attempted to replay version ").append(version).append(", but state is at ").append(this.currentVersion()).toString());
        this.currentVersion_$eq(version);
        actions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Action action = x0$1;
            if (action instanceof SetTransaction) {
                SetTransaction setTransaction = (SetTransaction)action;
                this.transactions().update((Object)setTransaction.appId(), (Object)setTransaction);
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof Metadata) {
                Metadata metadata = (Metadata)action;
                this.currentMetaData_$eq(metadata);
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof Protocol) {
                Protocol protocol = (Protocol)action;
                this.currentProtocolVersion_$eq(protocol);
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof AddFile) {
                AddFile addFile = (AddFile)action;
                UniqueFileActionTuple uniquePath = new UniqueFileActionTuple(addFile.pathAsUri(), addFile.getDeletionVectorUniqueId());
                boolean x$1 = false;
                String x$2 = addFile.copy$default$1();
                Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                String x$6 = addFile.copy$default$6();
                Map<String, String> x$7 = addFile.copy$default$7();
                DeletionVectorDescriptor x$8 = addFile.copy$default$8();
                this.activeFiles().update((Object)uniquePath, (Object)addFile.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8));
                boxedUnit = this.tombstones().remove((Object)uniquePath);
            } else if (action instanceof RemoveFile) {
                RemoveFile removeFile = (RemoveFile)action;
                UniqueFileActionTuple uniquePath = new UniqueFileActionTuple(removeFile.pathAsUri(), removeFile.getDeletionVectorUniqueId());
                this.activeFiles().remove((Object)uniquePath);
                boolean x$9 = false;
                String x$10 = removeFile.copy$default$1();
                Option<Object> x$11 = removeFile.copy$default$2();
                Option<Object> x$12 = removeFile.copy$default$4();
                Map<String, String> x$13 = removeFile.copy$default$5();
                Option<Object> x$14 = removeFile.copy$default$6();
                Map<String, String> x$15 = removeFile.copy$default$7();
                DeletionVectorDescriptor x$16 = removeFile.copy$default$8();
                this.tombstones().update((Object)uniquePath, (Object)removeFile.copy(x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16));
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof CommitInfo) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof AddCDCFile) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (action == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)action);
            }
            return boxedUnit;
        });
    }

    private Iterable<FileAction> getTombstones() {
        return (Iterable)this.tombstones().values().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryLogReplay.$anonfun$getTombstones$1(this, x$1)));
    }

    public Iterable<SetTransaction> getTransactions() {
        return this.minSetTransactionRetentionTimestamp.isEmpty() ? this.transactions().values() : (Iterable)this.transactions().values().filter((Function1 & Serializable & scala.Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)InMemoryLogReplay.$anonfun$getTransactions$1(this, txn)));
    }

    @Override
    public Iterator<Action> checkpoint() {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentProtocolVersion())).toIterator().$plus$plus((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentMetaData())).toIterator()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> this.getTransactions()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> ((IterableLike)((TraversableOnce)this.activeFiles().values().$plus$plus(this.getTombstones(), Iterable$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.path(), (Ordering)Ordering.String$.MODULE$)).iterator());
    }

    public Seq<AddFile> allFiles() {
        return this.activeFiles().values().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$getTombstones$1(InMemoryLogReplay $this, RemoveFile x$1) {
        return x$1.delTimestamp() > $this.minFileRetentionTimestamp;
    }

    public static final /* synthetic */ boolean $anonfun$getTransactions$1(InMemoryLogReplay $this, SetTransaction txn) {
        return txn.lastUpdated().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 > BoxesRunTime.unboxToLong((Object)$this.minSetTransactionRetentionTimestamp.get()));
    }

    public InMemoryLogReplay(long minFileRetentionTimestamp, Option<Object> minSetTransactionRetentionTimestamp) {
        this.minFileRetentionTimestamp = minFileRetentionTimestamp;
        this.minSetTransactionRetentionTimestamp = minSetTransactionRetentionTimestamp;
        this.currentProtocolVersion = null;
        this.currentVersion = -1L;
        this.currentMetaData = null;
        this.transactions = new HashMap();
        this.activeFiles = new HashMap();
        this.tombstones = new HashMap();
    }

    public static final class UniqueFileActionTuple
    implements Product,
    scala.Serializable {
        private final URI fileURI;
        private final Option<String> deletionVectorURI;

        public URI fileURI() {
            return this.fileURI;
        }

        public Option<String> deletionVectorURI() {
            return this.deletionVectorURI;
        }

        public UniqueFileActionTuple copy(URI fileURI, Option<String> deletionVectorURI) {
            return new UniqueFileActionTuple(fileURI, deletionVectorURI);
        }

        public URI copy$default$1() {
            return this.fileURI();
        }

        public Option<String> copy$default$2() {
            return this.deletionVectorURI();
        }

        public String productPrefix() {
            return "UniqueFileActionTuple";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.fileURI();
                    break;
                }
                case 1: {
                    option = this.deletionVectorURI();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UniqueFileActionTuple;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UniqueFileActionTuple)) return false;
            boolean bl = true;
            if (!bl) return false;
            UniqueFileActionTuple uniqueFileActionTuple = (UniqueFileActionTuple)x$1;
            URI uRI = this.fileURI();
            URI uRI2 = uniqueFileActionTuple.fileURI();
            if (uRI == null) {
                if (uRI2 != null) {
                    return false;
                }
            } else if (!((Object)uRI).equals(uRI2)) return false;
            Option<String> option = this.deletionVectorURI();
            Option<String> option2 = uniqueFileActionTuple.deletionVectorURI();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public UniqueFileActionTuple(URI fileURI, Option<String> deletionVectorURI) {
            this.fileURI = fileURI;
            this.deletionVectorURI = deletionVectorURI;
            Product.$init$((Product)this);
        }
    }
}

