/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import java.sql.Timestamp;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.sources.DeltaSource;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;

public final class DeltaSource$
implements Serializable {
    public static DeltaSource$ MODULE$;

    static {
        new DeltaSource$();
    }

    public Seq<Expression> $lessinit$greater$default$5() {
        return Nil$.MODULE$;
    }

    public long getStartingVersionFromTimestamp(SparkSession spark, DeltaLog deltaLog, Timestamp timestamp, boolean canExceedLatest) {
        long l;
        String tz = spark.sessionState().conf().sessionLocalTimeZone();
        DeltaHistoryManager.Commit commit = deltaLog.history().getActiveCommitAtTime(timestamp, true, false, true);
        if (commit.timestamp() >= timestamp.getTime()) {
            l = commit.version();
        } else if (commit.version() + 1L <= deltaLog.unsafeVolatileSnapshot().version() || canExceedLatest) {
            l = commit.version() + 1L;
        } else {
            Timestamp commitTs = new Timestamp(commit.timestamp());
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(tz));
            String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
            throw DeltaErrors$.MODULE$.timestampGreaterThanLatestCommit(timestamp, commitTs, tsString);
        }
        return l;
    }

    public boolean getStartingVersionFromTimestamp$default$4() {
        return false;
    }

    public DeltaSource apply(SparkSession spark, DeltaLog deltaLog, DeltaOptions options, Snapshot snapshotAtSourceInit, Seq<Expression> filters) {
        return new DeltaSource(spark, deltaLog, options, snapshotAtSourceInit, filters);
    }

    public Seq<Expression> apply$default$5() {
        return Nil$.MODULE$;
    }

    public Option<Tuple5<SparkSession, DeltaLog, DeltaOptions, Snapshot, Seq<Expression>>> unapply(DeltaSource x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.spark(), (Object)x$0.deltaLog(), (Object)x$0.options(), (Object)x$0.snapshotAtSourceInit(), x$0.filters()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DeltaSource$() {
        MODULE$ = this;
    }
}

