/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaUDF$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.UpdateCommand$;
import org.apache.spark.sql.delta.commands.UpdateMetric;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex$;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001\u0002\u0017.\u0001jB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\tE\u0002\u0011\t\u0012)A\u00059\"A1\r\u0001BK\u0002\u0013\u0005A\r\u0003\u0005f\u0001\tE\t\u0015!\u0003<\u0011!1\u0007A!f\u0001\n\u00039\u0007\u0002\u0003>\u0001\u0005#\u0005\u000b\u0011\u00025\t\u0011m\u0004!Q3A\u0005\u0002qD\u0011\"!\u0001\u0001\u0005#\u0005\u000b\u0011B?\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!I\u0011\u0011\u0003\u0001C\u0002\u0013\u0005\u00131\u0003\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0016!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002BCA#\u0001!\u0015\r\u0011\"\u0003\u0002H!Q\u0011\u0011\f\u0001\t\u0006\u0004%\t%a\u0017\t\u000f\u0005%\u0005\u0001\"\u0012\u0002\f\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAb\u0001\u0011%\u0011Q\u0019\u0005\n\u0005\u0007\u0001\u0011\u0011!C\u0001\u0005\u000bA\u0011Ba\u0004\u0001#\u0003%\tA!\u0005\t\u0013\t\u001d\u0002!%A\u0005\u0002\t%\u0002\"\u0003B\u0017\u0001E\u0005I\u0011\u0001B\u0018\u0011%\u0011\u0019\u0004AI\u0001\n\u0003\u0011)\u0004C\u0005\u0003:\u0001\t\t\u0011\"\u0011\u0003<!I!1\n\u0001\u0002\u0002\u0013\u0005!Q\n\u0005\n\u0005+\u0002\u0011\u0011!C\u0001\u0005/B\u0011B!\u0018\u0001\u0003\u0003%\tEa\u0018\t\u0013\t%\u0004!!A\u0005\u0002\t-\u0004\"\u0003B;\u0001\u0005\u0005I\u0011\tB<\u000f\u001d\u0011Y(\fE\u0001\u0005{2a\u0001L\u0017\t\u0002\t}\u0004bBA\u0002=\u0011\u0005!q\u0011\u0005\n\u0005\u0013s\"\u0019!C\u0001\u0005wA\u0001Ba#\u001fA\u0003%!Q\b\u0005\n\u0005\u001bs\"\u0019!C\u0001\u0005wA\u0001Ba$\u001fA\u0003%!Q\b\u0005\n\u0005#s\"\u0019!C\u0001\u0005'C\u0001B!&\u001fA\u0003%\u0011Q\u000e\u0005\b\u0005/sB\u0011\u0001BM\u0011\u001d\u0011)K\bC\u0001\u0005OCqAa+\u001f\t\u0003\u0011i\u000bC\u0005\u0003Xz\t\t\u0011\"!\u0003Z\"I!1\u001d\u0010\u0002\u0002\u0013\u0005%Q\u001d\u0005\n\u0005gt\u0012\u0011!C\u0005\u0005k\u0014Q\"\u00169eCR,7i\\7nC:$'B\u0001\u00180\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\u00192\u0003\u0015!W\r\u001c;b\u0015\t\u00114'A\u0002tc2T!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'\u0019\u00011(R'R/B\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\bY><\u0017nY1m\u0015\t\u0001\u0015)A\u0003qY\u0006t7O\u0003\u0002Cc\u0005A1-\u0019;bYf\u001cH/\u0003\u0002E{\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t15*D\u0001H\u0015\tA\u0015*A\u0004d_6l\u0017M\u001c3\u000b\u0005)\u000b\u0014!C3yK\u000e,H/[8o\u0013\tauIA\nMK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002O\u001f6\tQ&\u0003\u0002Q[\taA)\u001a7uC\u000e{W.\\1oIB\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\n9\u0001K]8ek\u000e$\bC\u0001*Y\u0013\tI6K\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\buC\"|WMR5mK&sG-\u001a=\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!aX\u0018\u0002\u000b\u0019LG.Z:\n\u0005\u0005t&A\u0004+bQ>,g)\u001b7f\u0013:$W\r_\u0001\u0010i\u0006Dw.\u001a$jY\u0016Le\u000eZ3yA\u00051A/\u0019:hKR,\u0012aO\u0001\bi\u0006\u0014x-\u001a;!\u0003E)\b\u000fZ1uK\u0016C\bO]3tg&|gn]\u000b\u0002QB\u0019\u0011.\u001d;\u000f\u0005)|gBA6o\u001b\u0005a'BA7:\u0003\u0019a$o\\8u}%\tA+\u0003\u0002q'\u00069\u0001/Y2lC\u001e,\u0017B\u0001:t\u0005\r\u0019V-\u001d\u0006\u0003aN\u0003\"!\u001e=\u000e\u0003YT!a^!\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003sZ\u0014!\"\u0012=qe\u0016\u001c8/[8o\u0003I)\b\u000fZ1uK\u0016C\bO]3tg&|gn\u001d\u0011\u0002\u0013\r|g\u000eZ5uS>tW#A?\u0011\u0007IsH/\u0003\u0002\u0000'\n1q\n\u001d;j_:\f!bY8oI&$\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}QQ\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0011\u00059\u0003\u0001\"\u0002.\n\u0001\u0004a\u0006\"B2\n\u0001\u0004Y\u0004\"\u00024\n\u0001\u0004A\u0007\"B>\n\u0001\u0004i\u0018AB8viB,H/\u0006\u0002\u0002\u0016A!\u0011.]A\f!\r)\u0018\u0011D\u0005\u0004\u000371(!C!uiJL'-\u001e;f\u0003\u001dyW\u000f\u001e9vi\u0002\nQ\"\u001b8oKJ\u001c\u0005.\u001b7ee\u0016tWCAA\u0012!\u0011I\u0017/!\n1\t\u0005\u001d\u00121\u0007\t\u0007\u0003S\tY#a\f\u000e\u0003}J1!!\f@\u0005%\tV/\u001a:z!2\fg\u000e\u0005\u0003\u00022\u0005MB\u0002\u0001\u0003\f\u0003ka\u0011\u0011!A\u0001\u0006\u0003\t9DA\u0002`IE\nB!!\u000f\u0002@A\u0019!+a\u000f\n\u0007\u0005u2KA\u0004O_RD\u0017N\\4\u0011\u0007I\u000b\t%C\u0002\u0002DM\u00131!\u00118z\u0003\t\u00198-\u0006\u0002\u0002JA!\u00111JA'\u001b\u0005\u0019\u0014bAA(g\ta1\u000b]1sW\u000e{g\u000e^3yi\"\u001aQ\"a\u0015\u0011\u0007I\u000b)&C\u0002\u0002XM\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u000f5,GO]5dgV\u0011\u0011Q\f\t\t\u0003?\nI'!\u001c\u0002~5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0005j[6,H/\u00192mK*\u0019\u0011qM*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0005\u0005$aA'baB!\u0011qNA<\u001d\u0011\t\t(a\u001d\u0011\u0005-\u001c\u0016bAA;'\u00061\u0001K]3eK\u001aLA!!\u001f\u0002|\t11\u000b\u001e:j]\u001eT1!!\u001eT!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB\u0013\u00061Q.\u001a;sS\u000eLA!a\"\u0002\u0002\nI1+\u0015'NKR\u0014\u0018nY\u0001\u0004eVtG\u0003BAG\u0003/\u0003B![9\u0002\u0010B!\u0011\u0011SAJ\u001b\u0005\t\u0014bAAKc\t\u0019!k\\<\t\u000f\u0005eu\u00021\u0001\u0002\u001c\u0006a1\u000f]1sWN+7o]5p]B!\u0011\u0011SAO\u0013\r\ty*\r\u0002\r'B\f'o[*fgNLwN\\\u0001\u000ea\u0016\u0014hm\u001c:n+B$\u0017\r^3\u0015\u0011\u0005\u0015\u00161VAW\u0003s\u00032AUAT\u0013\r\tIk\u0015\u0002\u0005+:LG\u000fC\u0004\u0002\u001aB\u0001\r!a'\t\u000f\u0005=\u0006\u00031\u0001\u00022\u0006AA-\u001a7uC2{w\r\u0005\u0003\u00024\u0006UV\"A\u0018\n\u0007\u0005]vF\u0001\u0005EK2$\u0018\rT8h\u0011\u001d\tY\f\u0005a\u0001\u0003{\u000b1\u0001\u001e=o!\u0011\t\u0019,a0\n\u0007\u0005\u0005wFA\u000bPaRLW.[:uS\u000e$&/\u00198tC\u000e$\u0018n\u001c8\u0002\u0019I,wO]5uK\u001aKG.Z:\u0015\u001d\u0005\u001d\u0017Q[Al\u00033\fi/a=\u0003\u0002A!\u0011.]Ae!\u0011\tY-!5\u000e\u0005\u00055'bAAh_\u00059\u0011m\u0019;j_:\u001c\u0018\u0002BAj\u0003\u001b\u0014!BR5mK\u0006\u001bG/[8o\u0011\u0019!\u0014\u00031\u0001\u0002\u001c\"9\u00111X\tA\u0002\u0005u\u0006bBAn#\u0001\u0007\u0011Q\\\u0001\te>|G\u000fU1uQB!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018A\u00014t\u0015\r\t9/N\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005-\u0018\u0011\u001d\u0002\u0005!\u0006$\b\u000eC\u0004\u0002pF\u0001\r!!=\u0002\u001d%t\u0007/\u001e;MK\u00064g)\u001b7fgB!\u0011.]A7\u0011\u001d\t)0\u0005a\u0001\u0003o\f\u0001C\\1nKR{\u0017\t\u001a3GS2,W*\u00199\u0011\u0011\u0005=\u0014\u0011`A7\u0003wLA!a\u001b\u0002|A!\u00111ZA\u007f\u0013\u0011\ty0!4\u0003\u000f\u0005#GMR5mK\")10\u0005a\u0001i\u0006!1m\u001c9z))\t9Aa\u0002\u0003\n\t-!Q\u0002\u0005\b5J\u0001\n\u00111\u0001]\u0011\u001d\u0019'\u0003%AA\u0002mBqA\u001a\n\u0011\u0002\u0003\u0007\u0001\u000eC\u0004|%A\u0005\t\u0019A?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0003\u0016\u00049\nU1F\u0001B\f!\u0011\u0011IBa\t\u000e\u0005\tm!\u0002\u0002B\u000f\u0005?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u00052+\u0001\u0006b]:|G/\u0019;j_:LAA!\n\u0003\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0006\u0016\u0004w\tU\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005cQ3\u0001\u001bB\u000b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa\u000e+\u0007u\u0014)\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005{\u0001BAa\u0010\u0003J5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%\u0001\u0003mC:<'B\u0001B$\u0003\u0011Q\u0017M^1\n\t\u0005e$\u0011I\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u001f\u00022A\u0015B)\u0013\r\u0011\u0019f\u0015\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u007f\u0011I\u0006C\u0005\u0003\\e\t\t\u00111\u0001\u0003P\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0019\u0011\r\t\r$QMA \u001b\t\t)'\u0003\u0003\u0003h\u0005\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u001c\u0003tA\u0019!Ka\u001c\n\u0007\tE4KA\u0004C_>dW-\u00198\t\u0013\tm3$!AA\u0002\u0005}\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003n\te\u0004\"\u0003B.9\u0005\u0005\t\u0019AA \u00035)\u0006\u000fZ1uK\u000e{W.\\1oIB\u0011aJH\n\u0005=\t\u0005u\u000bE\u0002S\u0005\u0007K1A!\"T\u0005\u0019\te.\u001f*fMR\u0011!QP\u0001\u0011\r&cUi\u0018(B\u001b\u0016{6i\u0014'V\u001b:\u000b\u0011CR%M\u000b~s\u0015)T#`\u0007>cU+\u0014(!\u0003U\u0019uJ\u0014#J)&{ejX\"P\u0019Vkej\u0018(B\u001b\u0016\u000bacQ(O\t&#\u0016j\u0014(`\u0007>cU+\u0014(`\u001d\u0006kU\tI\u0001\u001a\r&sE)\u0013(H?R{Uk\u0011%F\t~3\u0015\nT#T?6\u001bv)\u0006\u0002\u0002n\u0005Qb)\u0013(E\u0013:;u\fV(V\u0007\"+Ei\u0018$J\u0019\u0016\u001bv,T*HA\u0005\t\"/Z<sSRLgn\u001a$jY\u0016\u001cXj]4\u0015\t\u00055$1\u0014\u0005\b\u0005;3\u0003\u0019\u0001BP\u0003EqW/\u001c$jY\u0016\u001cHk\u001c*foJLG/\u001a\t\u0004%\n\u0005\u0016b\u0001BR'\n!Aj\u001c8h\u0003=\u0019\bn\\;mI>+H\u000f];u\u0007\u0012\u001cG\u0003\u0002B7\u0005SCq!a/(\u0001\u0004\ti,\u0001\nxSRDW\u000b\u001d3bi\u0016$7i\u001c7v[:\u001cH\u0003\u0004BX\u0005\u0017\u0014iMa4\u0003R\nU\u0007\u0003\u0002BY\u0005\u000btAAa-\u0003D:!!Q\u0017Ba\u001d\u0011\u00119La0\u000f\t\te&Q\u0018\b\u0004W\nm\u0016\"\u0001\u001d\n\u0005Y:\u0014B\u0001\u001b6\u0013\t\u00114'\u0003\u0002qc%!!q\u0019Be\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002qc!)1\r\u000ba\u0001w!)a\r\u000ba\u0001Q\")1\u0010\u000ba\u0001i\"9!1\u001b\u0015A\u0002\t=\u0016\u0001\u00073g/&$\b.\u0012<bYV\fG/\u001a3D_:$\u0017\u000e^5p]\"9!Q\u0015\u0015A\u0002\t5\u0014!B1qa2LHCCA\u0004\u00057\u0014iNa8\u0003b\")!,\u000ba\u00019\")1-\u000ba\u0001w!)a-\u000ba\u0001Q\")10\u000ba\u0001{\u00069QO\\1qa2LH\u0003\u0002Bt\u0005_\u0004BA\u0015@\u0003jB9!Ka;]w!l\u0018b\u0001Bw'\n1A+\u001e9mKRB\u0011B!=+\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B|!\u0011\u0011yD!?\n\t\tm(\u0011\t\u0002\u0007\u001f\nTWm\u0019;")
public class UpdateCommand
extends LogicalPlan
implements LeafRunnableCommand,
DeltaCommand,
scala.Serializable {
    private transient SparkContext sc;
    private Map<String, SQLMetric> metrics;
    private final TahoeFileIndex tahoeFileIndex;
    private final LogicalPlan target;
    private final Seq<Expression> updateExpressions;
    private final Option<Expression> condition;
    private final Seq<Attribute> output;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TahoeFileIndex, LogicalPlan, Seq<Expression>, Option<Expression>>> unapply(UpdateCommand updateCommand) {
        return UpdateCommand$.MODULE$.unapply(updateCommand);
    }

    public static Dataset<Row> withUpdatedColumns(LogicalPlan logicalPlan, Seq<Expression> seq, Expression expression, Dataset<Row> dataset, boolean bl) {
        return UpdateCommand$.MODULE$.withUpdatedColumns(logicalPlan, seq, expression, dataset, bl);
    }

    public static boolean shouldOutputCdc(OptimisticTransaction optimisticTransaction) {
        return UpdateCommand$.MODULE$.shouldOutputCdc(optimisticTransaction);
    }

    public static String rewritingFilesMsg(long l) {
        return UpdateCommand$.MODULE$.rewritingFilesMsg(l);
    }

    public static String FINDING_TOUCHED_FILES_MSG() {
        return UpdateCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG();
    }

    public static String CONDITION_COLUMN_NAME() {
        return UpdateCommand$.MODULE$.CONDITION_COLUMN_NAME();
    }

    public static String FILE_NAME_COLUMN() {
        return UpdateCommand$.MODULE$.FILE_NAME_COLUMN();
    }

    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$((DeltaCommand)this, (SparkSession)spark, (String)predicate);
    }

    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$((DeltaCommand)this, (SparkSession)spark, partitionColumns, predicates);
    }

    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$((DeltaCommand)this, (Path)basePath, candidateFiles);
    }

    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$((DeltaCommand)this, (DeltaLog)deltaLog, nameToAddFileMap, filesToRewrite, (long)operationTimestamp);
    }

    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$((DeltaCommand)this, (SparkSession)spark, (OptimisticTransaction)txn, (String)actionType, (Path)rootPath, inputLeafFiles, nameToAddFileMap);
    }

    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$((DeltaCommand)this, (Path)basePath, (String)filePath, nameToAddFileMap);
    }

    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)identifier);
    }

    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)tableIdent);
    }

    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$((DeltaCommand)this, (TableIdentifier)tableIdent);
    }

    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$((DeltaCommand)this, (SparkSession)spark, path, tableIdentifier, (String)operationName, hadoopConf);
    }

    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$((DeltaCommand)this);
    }

    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$((DeltaCommand)this, (SparkSession)spark, metrics);
    }

    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$((DeltaCommand)this, (OptimisticTransaction)txn, (SparkSession)sparkSession, options);
    }

    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$((DeltaCommand)this);
    }

    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$((DeltaCommand)this, (SparkSession)sparkSession, (DeltaLog)deltaLog, options);
    }

    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$((DeltaCommand)this);
    }

    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, (Object)data, path);
    }

    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$((DeltaLogging)this);
    }

    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$((DeltaLogging)this);
    }

    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$((DeltaLogging)this, (String)tablePath, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$((DeltaLogging)this);
    }

    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$((DeltaLogging)this, (String)group, (String)name, thunk);
    }

    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$((DeltaLogging)this, (DeltaLog)deltaLog, (String)tahoeId);
    }

    public void logConsole(String line) {
        DatabricksLogging.logConsole$((DatabricksLogging)this, (String)line);
    }

    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$((DatabricksLogging)this);
    }

    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$((DatabricksLogging)this);
    }

    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$((DatabricksLogging)this);
    }

    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$((DatabricksLogging)this);
    }

    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$((DatabricksLogging)this, (OpType)opType, (String)opTarget, extraTags, (boolean)isSynchronous, (boolean)alwaysRecordStats, (boolean)allowAuthTags, (boolean)killJvmIfStuck, (MetricDefinition)outputMetric, (boolean)silent, thunk);
    }

    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$((DatabricksLogging)this);
    }

    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$((DatabricksLogging)this);
    }

    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$((DatabricksLogging)this);
    }

    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$((DatabricksLogging)this);
    }

    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$((DatabricksLogging)this);
    }

    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$((DatabricksLogging)this);
    }

    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$((DeltaProgressReporter)this, (String)statusCode, (String)defaultMessage, data, body);
    }

    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$((DeltaProgressReporter)this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TahoeFileIndex tahoeFileIndex() {
        return this.tahoeFileIndex;
    }

    public LogicalPlan target() {
        return this.target;
    }

    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    public Option<Expression> condition() {
        return this.condition;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public Seq<QueryPlan<?>> innerChildren() {
        return (Seq)new .colon.colon((Object)this.target(), (List)Nil$.MODULE$);
    }

    private SparkContext sc$lzycompute() {
        UpdateCommand updateCommand = this;
        synchronized (updateCommand) {
            if (!this.bitmap$trans$0) {
                this.sc = SparkContext$.MODULE$.getOrCreate();
                this.bitmap$trans$0 = true;
            }
        }
        return this.sc;
    }

    private SparkContext sc() {
        return !this.bitmap$trans$0 ? this.sc$lzycompute() : this.sc;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        UpdateCommand updateCommand = this;
        synchronized (updateCommand) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of files added.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedBytes"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of bytes added")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of files removed.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedBytes"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of bytes removed")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numUpdatedRows"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of rows updated.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCopiedRows"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of rows copied.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executionTimeMs"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sc(), "time taken to execute the entire operation")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scanTimeMs"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sc(), "time taken to scan the files for matches")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rewriteTimeMs"), (Object)SQLMetrics$.MODULE$.createTimingMetric(this.sc(), "time taken to rewrite the matched files")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedChangeFiles"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of change data capture files generated")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changeFileBytes"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "total size of change data capture files generated")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTouchedRows"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of rows touched (copied + updated)"))}));
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        Object object = new Object();
        try {
            this.recordDeltaOperation(this.tahoeFileIndex().deltaLog(), "delta.dml.update", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DeltaLog deltaLog = this.tahoeFileIndex().deltaLog();
                deltaLog.withNewTransaction((Function1 & Serializable & scala.Serializable)txn -> {
                    UpdateCommand.$anonfun$run$2(this, sparkSession, object, deltaLog, txn);
                    return BoxedUnit.UNIT;
                });
                sparkSession.sharedState().cacheManager().recacheByPlan(sparkSession, this.target());
            });
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((SQLMetric)this.metrics().apply((Object)"numUpdatedRows")).value())})), (List)Nil$.MODULE$);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    private void performUpdate(SparkSession sparkSession, DeltaLog deltaLog, OptimisticTransaction txn) {
        Nil$ nil$;
        Nil$ nil$2;
        long numTouchedFiles = 0L;
        long numRewrittenFiles = 0L;
        long numAddedBytes = 0L;
        long numRemovedBytes = 0L;
        long numAddedChangeFiles = 0L;
        long changeFileBytes = 0L;
        long scanTimeMs = 0L;
        long rewriteTimeMs = 0L;
        long startTime = System.nanoTime();
        long numFilesTotal = txn.snapshot().numOfFiles();
        Expression updateCondition = (Expression)this.condition().getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.TrueLiteral());
        Tuple2 tuple2 = DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates(updateCondition, txn.metadata().partitionColumns(), sparkSession);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq metadataPredicates = (Seq)tuple2._1();
        Seq dataPredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)dataPredicates);
        Tuple2 tuple23 = tuple22;
        Seq metadataPredicates2 = (Seq)tuple23._1();
        Seq dataPredicates2 = (Seq)tuple23._2();
        Seq candidateFiles = txn.filterFiles((Seq)metadataPredicates2.$plus$plus((GenTraversableOnce)dataPredicates2, Seq$.MODULE$.canBuildFrom()), txn.filterFiles$default$2());
        Map<String, AddFile> nameToAddFile = this.generateCandidateFileMap(deltaLog.dataPath(), (Seq<AddFile>)candidateFiles);
        scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
        if (candidateFiles.isEmpty()) {
            nil$2 = Nil$.MODULE$;
        } else if (dataPredicates2.isEmpty()) {
            nil$2 = candidateFiles;
        } else {
            TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(sparkSession, "update", candidateFiles, deltaLog, this.tahoeFileIndex().path(), txn.snapshot(), TahoeBatchFileIndex$.MODULE$.$lessinit$greater$default$7());
            LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), (FileIndex)fileIndex);
            Dataset data = Dataset$.MODULE$.ofRows(sparkSession, newTarget);
            SQLMetric updatedRowCount = (SQLMetric)this.metrics().apply((Object)"numUpdatedRows");
            UserDefinedFunction updatedRowUdf = DeltaUDF$.MODULE$.boolean((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                updatedRowCount.$plus$eq(1L);
                return true;
            }).asNondeterministic();
            String[] pathsToRewrite = (String[])this.withStatusCode("DELTA", UpdateCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG(), this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> (String[])data.filter(new Column(updateCondition)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.input_file_name().as("input_files")})).filter(updatedRowUdf.apply((Seq)Nil$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.split(functions$.MODULE$.col("input_files"), ","))})).distinct().as(package$.MODULE$.stringEncoder()).collect());
            scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
            nil$2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathsToRewrite)).map((Function1 & Serializable & scala.Serializable)x$2 -> this.getTouchedFile(deltaLog.dataPath(), (String)x$2, nameToAddFile), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AddFile.class))))).toSeq();
        }
        Nil$ filesToRewrite = nil$2;
        numTouchedFiles = filesToRewrite.length();
        Nil$ newActions = filesToRewrite.isEmpty() ? Nil$.MODULE$ : (Seq)this.withStatusCode("DELTA", UpdateCommand$.MODULE$.rewritingFilesMsg(filesToRewrite.size()), this.withStatusCode$default$3(), () -> UpdateCommand.$anonfun$performUpdate$5(this, sparkSession, txn, (Seq)filesToRewrite, nameToAddFile, updateCondition));
        rewriteTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L - scanTimeMs;
        Tuple2 tuple24 = newActions.partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UpdateCommand.$anonfun$performUpdate$7(x$4)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq changeActions = (Seq)tuple24._1();
        Seq addActions = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)changeActions, (Object)addActions);
        Tuple2 tuple26 = tuple25;
        Seq changeActions2 = (Seq)tuple26._1();
        Seq addActions2 = (Seq)tuple26._2();
        numRewrittenFiles = addActions2.size();
        numAddedBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)addActions2.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getFileSize()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        numAddedChangeFiles = changeActions2.size();
        changeFileBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)changeActions2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AddCDCFile) {
                    AddCDCFile addCDCFile = (AddCDCFile)A1;
                    object = BoxesRunTime.boxToLong((long)addCDCFile.size());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(FileAction x1) {
                FileAction fileAction = x1;
                boolean bl = fileAction instanceof AddCDCFile;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (filesToRewrite.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            long operationTimestamp = System.currentTimeMillis();
            Seq deleteActions = (Seq)filesToRewrite.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.removeWithTimestamp(operationTimestamp, x$7.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
            numRemovedBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)filesToRewrite.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getFileSize()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            nil$ = (Seq)deleteActions.$plus$plus((GenTraversableOnce)newActions, Seq$.MODULE$.canBuildFrom());
        }
        Nil$ totalActions = nil$;
        ((SQLMetric)this.metrics().apply((Object)"numAddedFiles")).set(numRewrittenFiles);
        ((SQLMetric)this.metrics().apply((Object)"numAddedBytes")).set(numAddedBytes);
        ((SQLMetric)this.metrics().apply((Object)"numAddedChangeFiles")).set(numAddedChangeFiles);
        ((SQLMetric)this.metrics().apply((Object)"changeFileBytes")).set(changeFileBytes);
        ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set(numTouchedFiles);
        ((SQLMetric)this.metrics().apply((Object)"numRemovedBytes")).set(numRemovedBytes);
        ((SQLMetric)this.metrics().apply((Object)"executionTimeMs")).set((System.nanoTime() - startTime) / 1000L / 1000L);
        ((SQLMetric)this.metrics().apply((Object)"scanTimeMs")).set(scanTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"rewriteTimeMs")).set(rewriteTimeMs);
        long outputRows = BoxesRunTime.unboxToLong((Object)txn.getMetric("numOutputRows").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        if (((SQLMetric)this.metrics().apply((Object)"numUpdatedRows")).value() == 0L && outputRows != 0L && ((SQLMetric)this.metrics().apply((Object)"numCopiedRows")).value() == 0L) {
            ((SQLMetric)this.metrics().apply((Object)"numUpdatedRows")).set(((SQLMetric)this.metrics().apply((Object)"numTouchedRows")).value());
        } else {
            ((SQLMetric)this.metrics().apply((Object)"numCopiedRows")).set(((SQLMetric)this.metrics().apply((Object)"numTouchedRows")).value() - ((SQLMetric)this.metrics().apply((Object)"numUpdatedRows")).value());
        }
        txn.registerSQLMetrics(sparkSession, this.metrics());
        Seq finalActions = (Seq)Option$.MODULE$.option2Iterable(this.createSetTransaction(sparkSession, deltaLog, this.createSetTransaction$default$3())).toSeq().$plus$plus((GenTraversableOnce)totalActions, Seq$.MODULE$.canBuildFrom());
        txn.commitIfNeeded(finalActions, (DeltaOperations.Operation)new DeltaOperations.Update(this.condition().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString())));
        this.sendDriverMetrics(sparkSession, this.metrics());
        DeltaLog x$1 = deltaLog;
        String x$22 = "delta.dml.update.stats";
        UpdateMetric x$3 = new UpdateMetric((String)this.condition().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.sql()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "true"), numFilesTotal, numTouchedFiles, numRewrittenFiles, numAddedChangeFiles, changeFileBytes, scanTimeMs, rewriteTimeMs);
        Map<TagDefinition, String> x$42 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, x$22, x$42, x$3, x$5);
    }

    private Seq<FileAction> rewriteFiles(SparkSession spark, OptimisticTransaction txn, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap, Expression condition) {
        HadoopFsRelation baseRelation = this.buildBaseRelation(spark, txn, "update", rootPath, inputLeafFiles, nameToAddFileMap);
        LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), baseRelation.location());
        Dataset targetDf = Dataset$.MODULE$.ofRows(spark, newTarget);
        SQLMetric numTouchedRows = (SQLMetric)this.metrics().apply((Object)"numTouchedRows");
        UserDefinedFunction numTouchedRowsUdf = DeltaUDF$.MODULE$.boolean((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            numTouchedRows.$plus$eq(1L);
            return true;
        }).asNondeterministic();
        Dataset<Row> updatedDataFrame = UpdateCommand$.MODULE$.withUpdatedColumns(this.target(), this.updateExpressions(), condition, (Dataset<Row>)targetDf.filter(numTouchedRowsUdf.apply((Seq)Nil$.MODULE$)).withColumn(UpdateCommand$.MODULE$.CONDITION_COLUMN_NAME(), new Column(condition)), UpdateCommand$.MODULE$.shouldOutputCdc(txn));
        return txn.writeFiles(updatedDataFrame);
    }

    public UpdateCommand copy(TahoeFileIndex tahoeFileIndex, LogicalPlan target, Seq<Expression> updateExpressions, Option<Expression> condition) {
        return new UpdateCommand(tahoeFileIndex, target, updateExpressions, condition);
    }

    public TahoeFileIndex copy$default$1() {
        return this.tahoeFileIndex();
    }

    public LogicalPlan copy$default$2() {
        return this.target();
    }

    public Seq<Expression> copy$default$3() {
        return this.updateExpressions();
    }

    public Option<Expression> copy$default$4() {
        return this.condition();
    }

    public String productPrefix() {
        return "UpdateCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Seq<Expression> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.tahoeFileIndex();
                break;
            }
            case 1: {
                seq = this.target();
                break;
            }
            case 2: {
                seq = this.updateExpressions();
                break;
            }
            case 3: {
                seq = this.condition();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UpdateCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UpdateCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        UpdateCommand updateCommand = (UpdateCommand)((Object)x$1);
        TahoeFileIndex tahoeFileIndex = this.tahoeFileIndex();
        TahoeFileIndex tahoeFileIndex2 = updateCommand.tahoeFileIndex();
        if (tahoeFileIndex == null) {
            if (tahoeFileIndex2 != null) {
                return false;
            }
        } else if (!tahoeFileIndex.equals(tahoeFileIndex2)) return false;
        LogicalPlan logicalPlan = this.target();
        LogicalPlan logicalPlan2 = updateCommand.target();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        Seq<Expression> seq = this.updateExpressions();
        Seq<Expression> seq2 = updateCommand.updateExpressions();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.condition();
        Option<Expression> option2 = updateCommand.condition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!updateCommand.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$2(UpdateCommand $this, SparkSession sparkSession$1, Object nonLocalReturnKey1$1, DeltaLog deltaLog$1, OptimisticTransaction txn) {
        DeltaLog$.MODULE$.assertRemovable(txn.snapshot());
        if ($this.hasBeenExecuted(txn, sparkSession$1, $this.hasBeenExecuted$default$3())) {
            $this.sendDriverMetrics(sparkSession$1, $this.metrics());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Nil$.MODULE$);
        }
        $this.performUpdate(sparkSession$1, deltaLog$1, txn);
    }

    public static final /* synthetic */ Seq $anonfun$performUpdate$5(UpdateCommand $this, SparkSession sparkSession$2, OptimisticTransaction txn$1, Seq filesToRewrite$1, Map nameToAddFile$1, Expression updateCondition$1) {
        return $this.rewriteFiles(sparkSession$2, txn$1, $this.tahoeFileIndex().path(), (Seq<String>)((Seq)filesToRewrite$1.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.path(), Seq$.MODULE$.canBuildFrom())), (Map<String, AddFile>)nameToAddFile$1, updateCondition$1);
    }

    public static final /* synthetic */ boolean $anonfun$performUpdate$7(FileAction x$4) {
        return x$4 instanceof AddCDCFile;
    }

    public UpdateCommand(TahoeFileIndex tahoeFileIndex, LogicalPlan target, Seq<Expression> updateExpressions, Option<Expression> condition) {
        this.tahoeFileIndex = tahoeFileIndex;
        this.target = target;
        this.updateExpressions = updateExpressions;
        this.condition = condition;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$((DeltaProgressReporter)this);
        DatabricksLogging.$init$((DatabricksLogging)this);
        DeltaLogging.$init$((DeltaLogging)this);
        DeltaCommand.$init$((DeltaCommand)this);
        String x$1 = "num_affected_rows";
        LongType$ x$2 = LongType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        this.output = (Seq)new .colon.colon((Object)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$);
    }
}

