/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.scheduler;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.NSparkSnapshotJob;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.rest.scheduler.AbstractSchedulerRunnable;
import org.apache.kylin.rest.scheduler.JobInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class BuildSnapshotRunnable
extends AbstractSchedulerRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildSnapshotRunnable.class);
    private static final String BUILD_SNAPSHOT_ERROR_MESSAGE = "Project[%s] Snapshot[%s] buildSnapshot failed";

    @Override
    public void execute() {
        this.buildSnapshot();
    }

    public void buildSnapshot() {
        if (Boolean.TRUE.equals(this.needRefresh) || Boolean.TRUE.equals(this.checkSnapshotJobFile())) {
            try {
                String url = String.format(Locale.ROOT, "http://%s/kylin/api/snapshots/auto_refresh", this.config.getServerAddress());
                Map<Object, Object> req = this.createRequestAndCheckRunningJob();
                log.debug("buildSnapshot request: {}", req);
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.add("Content-Type", "application/vnd.apache.kylin-v4-public+json");
                ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.PUT, new HttpEntity((Object)JsonUtil.writeValueAsBytes(req), (MultiValueMap)httpHeaders), String.class, new Object[0]);
                String responseBody = (String)Optional.ofNullable(exchange.getBody()).orElse("");
                int responseStatus = exchange.getStatusCodeValue();
                if (responseStatus != 200) {
                    throw new KylinRuntimeException(String.format(Locale.ROOT, BUILD_SNAPSHOT_ERROR_MESSAGE, this.project, this.tableIdentity));
                }
                RestResponse response = (RestResponse)JsonUtil.readValue((String)responseBody, (TypeReference)new TypeReference<RestResponse<JobInfoResponse>>(){});
                if (!StringUtils.equals((CharSequence)response.getCode(), (CharSequence)"000")) {
                    throw new KylinRuntimeException(String.format(Locale.ROOT, BUILD_SNAPSHOT_ERROR_MESSAGE, this.project, this.tableIdentity));
                }
                String jobId = ((JobInfoResponse)response.getData()).getJobs().get(0).getJobId();
                this.saveSnapshotJobFile(false, "", jobId);
                log.info("Project[{}}] Snapshot[{}] buildSnapshot API success, response [{}]", new Object[]{this.project, this.tableIdentity, response.getData()});
            }
            catch (Exception e) {
                this.saveSnapshotJobFile(true, e.getMessage(), "");
                log.error("Project[{}] Snapshot[{}] buildSnapshot failed", (Object)this.project, (Object)this.tableIdentity);
                throw new KylinRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Boolean checkSnapshotJobFile() {
        Map<String, String> snapshotJob = this.readSnapshotJobFile();
        boolean buildError = Boolean.parseBoolean(snapshotJob.getOrDefault("build_error", String.valueOf(true)));
        if (buildError) {
            return true;
        }
        String jobId = snapshotJob.get("job_id");
        if (StringUtils.isBlank((CharSequence)jobId)) {
            return true;
        }
        return this.checkAutoRefreshJobSuccessOrRunning(jobId) == false;
    }

    public Boolean checkAutoRefreshJobSuccessOrRunning(String jobId) {
        try {
            ExecutableManager executableManager = ExecutableManager.getInstance((KylinConfig)this.config, (String)this.project);
            AbstractExecutable autoRefreshJob = executableManager.getJob(jobId);
            if (null == autoRefreshJob) {
                return false;
            }
            return autoRefreshJob.getStatus() == ExecutableState.SUCCEED || autoRefreshJob.getStatus().isRunning();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Map<String, String> readSnapshotJobFile() {
        HashMap snapshotJob;
        block14: {
            snapshotJob = Maps.newHashMap();
            FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
            Path snapshotJobPath = new Path(this.config.getSnapshotAutoRefreshDir(this.project) + "snapshot_job" + "/" + this.tableIdentity);
            try {
                if (!fileSystem.exists(snapshotJobPath)) break block14;
                try (FSDataInputStream inputStream = fileSystem.open(snapshotJobPath);){
                    snapshotJob.putAll((Map)JsonUtil.readValue((InputStream)inputStream, (TypeReference)new TypeReference<Map<String, String>>(){}));
                }
            }
            catch (IOException e) {
                log.error("read SnapshotSourceTableStats path[{}] to SourceTableStats has error", (Object)snapshotJobPath, (Object)e);
            }
        }
        return snapshotJob;
    }

    public void saveSnapshotJobFile(Boolean buildError, String errorMessage, String jobId) {
        HashMap snapshotJob = Maps.newHashMap();
        snapshotJob.put("build_error", buildError);
        snapshotJob.put("error_message", errorMessage);
        snapshotJob.put("job_id", jobId);
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        Path snapshotJobPath = new Path(this.config.getSnapshotAutoRefreshDir(this.project) + "snapshot_job" + "/" + this.tableIdentity);
        try (FSDataOutputStream out = fileSystem.create(snapshotJobPath, true);){
            out.write(JsonUtil.writeValueAsBytes((Object)snapshotJob));
        }
        catch (IOException e) {
            log.error("overwrite SourceTableStats to path[{}] failed!", (Object)snapshotJobPath, (Object)e);
        }
    }

    public Map<Object, Object> createRequestAndCheckRunningJob() {
        HashMap req = Maps.newHashMap();
        req.put("need_refresh", this.needRefresh);
        req.put("project", this.project);
        req.put("tables", Sets.newHashSet((Object[])new String[]{this.tableIdentity}));
        List<NSparkSnapshotJob> runningSnapshotJobs = this.getRunningSnapshotJobs();
        if (StringUtils.isNotBlank((CharSequence)this.partitionColumn)) {
            if (this.checkNeedBuildPartitionAndSetTableOption(req, runningSnapshotJobs)) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, "Project[%s] Snapshot[%s] buildSnapshot failed, because none partitions need build", this.project, this.tableIdentity));
            }
        } else if (CollectionUtils.isNotEmpty(runningSnapshotJobs)) {
            log.info("buildSnapshot: {} has running snapshot job", (Object)this.tableIdentity);
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Project[%s] Snapshot[%s] buildSnapshot failed, because has running snapshot job", this.project, this.tableIdentity));
        }
        return req;
    }

    private List<NSparkSnapshotJob> getRunningSnapshotJobs() {
        ExecutableManager execManager = ExecutableManager.getInstance((KylinConfig)this.config, (String)this.project);
        List executables = execManager.jobInfoToExecutable(execManager.fetchJobsByTypesAndStates(this.project, (List)Lists.newArrayList((Object[])new String[]{JobTypeEnum.SNAPSHOT_BUILD.name(), JobTypeEnum.SNAPSHOT_REFRESH.name()}), null, ExecutableState.getNotFinalStates()));
        return executables.stream().filter(executable -> StringUtils.equalsIgnoreCase((CharSequence)executable.getParam("table"), (CharSequence)this.tableIdentity)).filter(NSparkSnapshotJob.class::isInstance).map(NSparkSnapshotJob.class::cast).collect(Collectors.toList());
    }

    public boolean checkNeedBuildPartitionAndSetTableOption(Map<Object, Object> req, List<NSparkSnapshotJob> runningSnapshotJobs) {
        if (CollectionUtils.isEmpty((Collection)this.needRefreshPartitionsValue)) {
            log.info("buildSnapshot: needRefreshPartitionsValue is empty");
            return true;
        }
        log.info("will build snapshot partitions value : {}", (Object)this.needRefreshPartitionsValue);
        Sets.SetView<String> needBuildPartitionsValue = this.getNeedBuildPartitionsValue(runningSnapshotJobs);
        if (CollectionUtils.isEmpty(needBuildPartitionsValue)) {
            log.info("buildSnapshot: needBuildPartitionsValue is empty");
            return true;
        }
        HashMap tableOption = Maps.newHashMap();
        HashMap option = Maps.newHashMap();
        option.put("partition_col", this.partitionColumn);
        option.put("incremental_build", true);
        option.put("partitions_to_build", needBuildPartitionsValue);
        tableOption.put(this.tableIdentity, option);
        req.put("options", tableOption);
        return false;
    }

    private Sets.SetView<String> getNeedBuildPartitionsValue(List<NSparkSnapshotJob> runningSnapshotJobs) {
        Set runningSnapshotJobsSelectPartitionsValue = runningSnapshotJobs.stream().map(job -> job.getParam("selectedPartition")).map(selectedPartition -> {
            try {
                return JsonUtil.readValueAsSet((String)selectedPartition);
            }
            catch (IOException ignore) {
                return Sets.newHashSet();
            }
        }).flatMap(Collection::stream).collect(Collectors.toSet());
        return Sets.difference((Set)this.needRefreshPartitionsValue, runningSnapshotJobsSelectPartitionsValue);
    }
}

