/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache.memcached;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.internal.BulkFuture;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rest.cache.memcached.KeyHookLookup;
import org.apache.kylin.rest.cache.memcached.MemcachedCache;
import org.apache.kylin.rest.cache.memcached.MemcachedCacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedChunkingCache
extends MemcachedCache
implements KeyHookLookup {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedChunkingCache.class);

    public MemcachedChunkingCache(MemcachedCache cache) {
        super(cache);
        Preconditions.checkArgument((this.config.getMaxChunkSize() > 1 ? 1 : 0) != 0, (String)"maxChunkSize [%d] must be greater than 1", (int)this.config.getMaxChunkSize());
        Preconditions.checkArgument((this.config.getMaxObjectSize() > 261 ? 1 : 0) != 0, (String)"maxObjectSize [%d] must be greater than 261", (int)this.config.getMaxObjectSize());
    }

    protected static byte[][] splitBytes(byte[] data, int nSplit) {
        byte[][] dest = new byte[nSplit][];
        int splitSize = (data.length - 1) / nSplit + 1;
        for (int i = 0; i < nSplit - 1; ++i) {
            dest[i] = Arrays.copyOfRange(data, i * splitSize, (i + 1) * splitSize);
        }
        dest[nSplit - 1] = Arrays.copyOfRange(data, (nSplit - 1) * splitSize, data.length);
        return dest;
    }

    protected static int getValueSplit(MemcachedCacheConfig config, String keyS, int valueBLen) {
        int valueSize = config.getMaxObjectSize() - 2 - 4 - keyS.getBytes(StandardCharsets.UTF_8).length - 6;
        int maxValueSize = config.getMaxChunkSize() * valueSize;
        Preconditions.checkArgument((valueBLen <= maxValueSize ? 1 : 0) != 0, (String)"the value bytes length [%d] exceeds maximum value size [%d]", (int)valueBLen, (int)maxValueSize);
        return (valueBLen - 1) / valueSize + 1;
    }

    protected static Pair<KeyHookLookup.KeyHook, byte[][]> getKeyValuePair(int nSplit, String keyS, byte[] valueB) {
        KeyHookLookup.KeyHook keyHook;
        byte[][] splitValueB = null;
        if (nSplit > 1) {
            String[] chunkKeySs = new String[nSplit];
            for (int i = 0; i < nSplit; ++i) {
                chunkKeySs[i] = keyS + i;
            }
            keyHook = new KeyHookLookup.KeyHook(chunkKeySs, null);
            splitValueB = MemcachedChunkingCache.splitBytes(valueB, nSplit);
        } else {
            keyHook = new KeyHookLookup.KeyHook(null, valueB);
        }
        return new Pair((Object)keyHook, (Object)splitValueB);
    }

    @Override
    public byte[] getBinary(String keyS) {
        BulkFuture bulkFuture;
        if (Strings.isNullOrEmpty((String)keyS)) {
            return new byte[0];
        }
        KeyHookLookup.KeyHook keyHook = this.lookupKeyHook(keyS);
        if (keyHook == null) {
            return new byte[0];
        }
        if (keyHook.getChunkskey() == null || keyHook.getChunkskey().length == 0) {
            if (logger.isDebugEnabled() || this.config.isEnableDebugLog()) {
                logger.debug("Chunking not enabled, return the value bytes in the keyhook directly, value bytes size = {}", (Object)keyHook.getValues().length);
            }
            return keyHook.getValues();
        }
        long start = System.currentTimeMillis();
        if (logger.isDebugEnabled() || this.config.isEnableDebugLog()) {
            logger.debug("Chunking enabled, chunk size = {}", (Object)keyHook.getChunkskey().length);
        }
        Map<String, String> keyLookup = this.computeKeyHash(Arrays.asList(keyHook.getChunkskey()));
        try {
            bulkFuture = this.client.asyncGetBulk(keyLookup.keySet());
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            logger.error("Unable to queue cache operation.", (Throwable)e);
            return new byte[0];
        }
        catch (Throwable t) {
            this.errorCount.incrementAndGet();
            logger.error("Unable to queue cache operation.", t);
            return new byte[0];
        }
        try {
            Map bulkResult = (Map)bulkFuture.get(this.config.getTimeout(), TimeUnit.MILLISECONDS);
            this.cacheGetTime.addAndGet(System.currentTimeMillis() - start);
            if (bulkResult.size() != keyHook.getChunkskey().length) {
                this.missCount.incrementAndGet();
                logger.warn("Some paritial chunks missing for query key: {}", (Object)keyS);
                for (String partitalKey : bulkResult.keySet()) {
                    this.client.delete(partitalKey);
                }
                this.deleteKeyHook(keyS);
                return new byte[0];
            }
            this.hitCount.getAndAdd(keyHook.getChunkskey().length);
            byte[][] bytesArray = new byte[keyHook.getChunkskey().length][];
            for (Map.Entry entry : bulkResult.entrySet()) {
                byte[] bytes = (byte[])entry.getValue();
                this.readBytes.addAndGet(bytes.length);
                String originalKeyS = keyLookup.get(entry.getKey());
                int idx = Integer.parseInt(originalKeyS.substring(keyS.length()));
                bytesArray[idx] = this.decodeValue(originalKeyS.getBytes(StandardCharsets.UTF_8), bytes);
            }
            return this.concatBytes(bytesArray);
        }
        catch (TimeoutException e) {
            this.timeoutCount.incrementAndGet();
            bulkFuture.cancel(false);
            return new byte[0];
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            this.errorCount.incrementAndGet();
            logger.error("ExecutionException when pulling item from cache.", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public void putBinary(String keyS, byte[] valueB, int expiration) {
        if (Strings.isNullOrEmpty((String)keyS)) {
            return;
        }
        int nSplit = MemcachedChunkingCache.getValueSplit(this.config, keyS, valueB.length);
        Pair<KeyHookLookup.KeyHook, byte[][]> keyValuePair = MemcachedChunkingCache.getKeyValuePair(nSplit, keyS, valueB);
        KeyHookLookup.KeyHook keyHook = (KeyHookLookup.KeyHook)keyValuePair.getFirst();
        byte[][] splitValueB = (byte[][])keyValuePair.getSecond();
        if (logger.isDebugEnabled() || this.config.isEnableDebugLog()) {
            logger.debug("put key hook:{} to cache for hash key", (Object)keyHook);
        }
        super.putBinary(keyS, this.serializeValue(keyHook), expiration);
        if (nSplit > 1) {
            for (int i = 0; i < nSplit; ++i) {
                if (logger.isDebugEnabled() || this.config.isEnableDebugLog()) {
                    logger.debug(String.format(Locale.ROOT, "Chunk[ %d ] bytes size before encoding  = %d", i, splitValueB[i].length));
                }
                super.putBinary(keyHook.getChunkskey()[i], splitValueB[i], expiration);
            }
        }
    }

    @Override
    public void evict(String keyS) {
        if (Strings.isNullOrEmpty((String)keyS)) {
            return;
        }
        KeyHookLookup.KeyHook keyHook = this.lookupKeyHook(keyS);
        if (keyHook == null) {
            return;
        }
        if (keyHook.getChunkskey() != null && keyHook.getChunkskey().length > 0) {
            String[] chunkKeys;
            for (String chunkKey : chunkKeys = keyHook.getChunkskey()) {
                super.evict(chunkKey);
            }
        }
        super.evict(keyS);
    }

    protected Map<String, String> computeKeyHash(List<String> keySList) {
        return Maps.uniqueIndex(keySList, this::computeKeyHash);
    }

    private void deleteKeyHook(String keyS) {
        try {
            super.evict(keyS);
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            logger.error("Unable to queue cache operation: ", (Throwable)e);
        }
    }

    private byte[] concatBytes(byte[] ... bytesArray) {
        int length = 0;
        for (byte[] bytes : bytesArray) {
            length += bytes.length;
        }
        byte[] result = new byte[length];
        int destPos = 0;
        for (byte[] bytes : bytesArray) {
            System.arraycopy(bytes, 0, result, destPos, bytes.length);
            destPos += bytes.length;
        }
        if (logger.isDebugEnabled() || this.config.isEnableDebugLog()) {
            logger.debug("Original value bytes size for all chunks  = {}", (Object)result.length);
        }
        return result;
    }

    @Override
    public KeyHookLookup.KeyHook lookupKeyHook(String keyS) {
        byte[] bytes = super.getBinary(keyS);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return (KeyHookLookup.KeyHook)SerializationUtils.deserialize((byte[])bytes);
    }
}

