/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.rest.response.SystemProfileResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.SystemProfileExtractorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service(value="lightningService")
public class LightningService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightningService.class);

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public SystemProfileResponse systemProfile() {
        if (!KapConfig.getInstanceFromEnv().isCloud()) {
            SystemProfileResponse systemProfileResponse = new SystemProfileResponse();
            systemProfileResponse.setIsCloud(false);
            return systemProfileResponse;
        }
        try {
            String data = SystemProfileExtractorFactory.create(KylinConfig.getInstanceFromEnv()).getSystemProfile();
            return (SystemProfileResponse)JsonUtil.readValue((String)data, SystemProfileResponse.class);
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeSystem.SYSTEM_PROFILE_ABNORMAL_DATA, (Throwable)e, new Object[0]);
        }
    }
}

