/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsController;
import org.apache.kylin.common.metrics.MetricsInfluxdbReporter;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.metrics.MetricsObject;
import org.apache.kylin.common.metrics.MetricsObjectType;
import org.apache.kylin.common.metrics.MetricsTag;
import org.apache.kylin.common.metrics.gauges.QueryRatioGauge;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDB;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.Query;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsGroup {
    private static final Logger logger = LoggerFactory.getLogger(MetricsGroup.class);
    public static final Set<String> gauges = Collections.synchronizedSet(new HashSet());
    public static final ConcurrentHashMap<String, Counter> counters = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, Meter> meters = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, Histogram> histograms = new ConcurrentHashMap();
    public static final Map<String, MetricsObject> cacheInfluxMetricStatusMap = new ConcurrentHashMap<String, MetricsObject>();

    private MetricsGroup() {
    }

    public static boolean hostTagCounterInc(MetricsName name, MetricsCategory category, String entity) {
        return MetricsGroup.counterInc(name, category, entity, MetricsGroup.getHostTagMap(entity));
    }

    public static boolean hostTagCounterInc(MetricsName name, MetricsCategory category, String entity, long increments) {
        return MetricsGroup.counterInc(name, category, entity, MetricsGroup.getHostTagMap(entity), increments);
    }

    public static boolean counterInc(MetricsName name, MetricsCategory category, String entity) {
        return MetricsGroup.counterInc(name, category, entity, Collections.emptyMap());
    }

    public static boolean counterInc(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags) {
        return MetricsGroup.counterInc(name, category, entity, tags, 1L);
    }

    public static boolean counterInc(MetricsName name, MetricsCategory category, String entity, long increments) {
        return MetricsGroup.counterInc(name, category, entity, Collections.emptyMap(), increments);
    }

    public static boolean counterInc(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags, long increments) {
        if (!KapConfig.getInstanceFromEnv().isMonitorEnabled()) {
            return true;
        }
        if (increments < 0L) {
            return false;
        }
        try {
            Counter counter = MetricsGroup.registerCounterIfAbsent(name.getVal(), category.getVal(), entity, tags);
            counter.inc(increments);
            return true;
        }
        catch (Exception e) {
            logger.warn("kylin.metrics counterInc {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean hostTagHistogramUpdate(MetricsName name, MetricsCategory category, String entity, long updateTo) {
        return MetricsGroup.histogramUpdate(name, category, entity, MetricsGroup.getHostTagMap(entity), updateTo);
    }

    public static boolean histogramUpdate(MetricsName name, MetricsCategory category, String entity, long updateTo) {
        return MetricsGroup.histogramUpdate(name, category, entity, Collections.emptyMap(), updateTo);
    }

    public static boolean histogramUpdate(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags, long updateTo) {
        if (!KapConfig.getInstanceFromEnv().isMonitorEnabled()) {
            return true;
        }
        if (updateTo < 0L) {
            return false;
        }
        try {
            Histogram histogram = MetricsGroup.registerHistogramIfAbsent(name.getVal(), category.getVal(), entity, tags);
            histogram.update(updateTo);
            return true;
        }
        catch (Exception e) {
            logger.warn("kylin.metrics histogramUpdate {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean meterMark(MetricsName name, MetricsCategory category, String entity) {
        return MetricsGroup.meterMark(name, category, entity, Collections.emptyMap());
    }

    public static boolean meterMark(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags) {
        try {
            Meter meter = MetricsGroup.registerMeterIfAbsent(name.getVal(), category.getVal(), entity, tags);
            meter.mark();
            return true;
        }
        catch (Exception e) {
            logger.warn("kylin.metrics meterMark {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean removeGlobalMetrics() {
        String metricNameSuffix = MetricsGroup.metricNameSuffix(MetricsCategory.GLOBAL.getVal(), "global", Collections.emptyMap());
        MetricRegistry registry = MetricsController.getDefaultMetricRegistry();
        MetricsGroup.removeMetrics(metricNameSuffix, registry);
        return true;
    }

    public static boolean removeProjectMetrics(String projectName) {
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            throw new IllegalArgumentException("removeProjectMetrics, projectName shouldn't be empty.");
        }
        String metricNameSuffix = MetricsGroup.metricNameSuffix(MetricsCategory.PROJECT.getVal(), projectName, Collections.emptyMap());
        MetricRegistry registry = MetricsController.getDefaultMetricRegistry();
        MetricsGroup.removeMetrics(metricNameSuffix, registry);
        return true;
    }

    public static boolean removeModelMetrics(String project, String modelId) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new IllegalArgumentException("removeModelMetrics, projectName shouldn't be empty.");
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            throw new IllegalArgumentException("removeModelMetrics, modelId shouldn't be empty.");
        }
        HashMap tags = Maps.newHashMap();
        tags.put(MetricsTag.MODEL.getVal(), modelId);
        String metricNameSuffix = MetricsGroup.metricNameSuffix(MetricsCategory.PROJECT.getVal(), project, tags);
        MetricRegistry registry = MetricsController.getDefaultMetricRegistry();
        MetricsGroup.removeMetrics(metricNameSuffix, registry);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMetrics(String metricNameSuffix, MetricRegistry registry) {
        Iterator<String> it;
        ConcurrentHashMap<String, Meter> concurrentHashMap = gauges;
        synchronized (concurrentHashMap) {
            it = gauges.iterator();
            MetricsGroup.doRemove(metricNameSuffix, it, registry);
        }
        concurrentHashMap = counters;
        synchronized (concurrentHashMap) {
            it = ((ConcurrentHashMap.KeySetView)counters.keySet()).iterator();
            MetricsGroup.doRemove(metricNameSuffix, it, registry);
        }
        concurrentHashMap = meters;
        synchronized (concurrentHashMap) {
            it = ((ConcurrentHashMap.KeySetView)meters.keySet()).iterator();
            MetricsGroup.doRemove(metricNameSuffix, it, registry);
        }
        concurrentHashMap = histograms;
        synchronized (concurrentHashMap) {
            it = ((ConcurrentHashMap.KeySetView)histograms.keySet()).iterator();
            MetricsGroup.doRemove(metricNameSuffix, it, registry);
        }
    }

    public static Counter getCounter(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags) {
        String metricName = MetricsGroup.metricName(name.getVal(), category.getVal(), entity, tags);
        return counters.get(metricName);
    }

    public static <T> Gauge<T> getGauge(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags) {
        String metricName = MetricsGroup.metricName(name.getVal(), category.getVal(), entity, tags);
        return (Gauge)MetricsController.getDefaultMetricRegistry().getGauges().get(metricName);
    }

    public static boolean registerProjectMetrics(String projectName, String host) {
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            throw new IllegalArgumentException("registerProjectMetrics, projectName shouldn't be empty.");
        }
        Map<String, String> tags = MetricsGroup.getHostTagMap(host, projectName);
        MetricsGroup.newCounter(MetricsName.TRANSACTION_RETRY_COUNTER, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newHistogram(MetricsName.TRANSACTION_LATENCY, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.QUERY, MetricsCategory.PROJECT, projectName, tags);
        Counter denominator = MetricsGroup.getCounter(MetricsName.QUERY, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.QUERY_LT_1S, MetricsCategory.PROJECT, projectName, tags);
        Counter numerator = MetricsGroup.getCounter(MetricsName.QUERY_LT_1S, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_LT_1S_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_1S_3S, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_1S_3S, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_1S_3S_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_3S_5S, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_3S_5S, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_3S_5S_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_5S_10S, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_5S_10S, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_5S_10S_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_SLOW, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_SLOW, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_SLOW_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_FAILED, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.QUERY_PUSH_DOWN, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_PUSH_DOWN, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_PUSH_DOWN_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_CONSTANTS, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_CONSTANTS, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_CONSTANTS_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_CACHE, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_CACHE, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_CACHE_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_AGG_INDEX, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_AGG_INDEX, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_AGG_INDEX_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_TABLE_INDEX, MetricsCategory.PROJECT, projectName, tags);
        numerator = MetricsGroup.getCounter(MetricsName.QUERY_TABLE_INDEX, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newGauge(MetricsName.QUERY_TABLE_INDEX_RATIO, MetricsCategory.PROJECT, projectName, tags, new QueryRatioGauge(numerator, denominator));
        MetricsGroup.newCounter(MetricsName.QUERY_TOTAL_DURATION, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.QUERY_TIMEOUT, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newMeter(MetricsName.QUERY_SLOW_RATE, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newMeter(MetricsName.QUERY_FAILED_RATE, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newMeter(MetricsName.QUERY_PUSH_DOWN_RATE, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newMeter(MetricsName.QUERY_CONSTANTS_RATE, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newMeter(MetricsName.QUERY_TIMEOUT_RATE, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newHistogram(MetricsName.QUERY_LATENCY, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_DURATION, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_FINISHED, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_STEP_ATTEMPTED, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_FAILED_STEP_ATTEMPTED, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_RESUMED, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_DISCARDED, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_ERROR, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newHistogram(MetricsName.JOB_DURATION_HISTOGRAM, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.JOB_WAIT_DURATION, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.METADATA_CLEAN, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.METADATA_BACKUP, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.METADATA_BACKUP_DURATION, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newCounter(MetricsName.METADATA_BACKUP_FAILED, MetricsCategory.PROJECT, projectName, tags);
        MetricsGroup.newHistogram(MetricsName.QUERY_SCAN_BYTES, MetricsCategory.PROJECT, projectName, tags);
        return true;
    }

    public static void newMetricSet(MetricsName name, MetricsCategory category, String entity, MetricSet metricSet) {
        MetricsGroup.newMetrics(name.getVal(), metricSet, category, entity);
    }

    private static void newMetrics(String name, MetricSet metricSet, MetricsCategory category, String entity) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            Metric value = (Metric)entry.getValue();
            if (value instanceof MetricSet) {
                MetricsGroup.newMetrics(MetricsGroup.name(name, (String)entry.getKey()), (MetricSet)value, category, entity);
                continue;
            }
            MetricsGroup.newGauge(MetricsGroup.name(name, (String)entry.getKey()), category, entity, Collections.emptyMap(), value);
        }
    }

    private static String name(String prefix, String part) {
        return "".concat(prefix).concat(".").concat(part);
    }

    public static <T> boolean newGauge(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags, Gauge<T> metric) {
        return MetricsGroup.newGauge(name.getVal(), category, entity, tags, metric);
    }

    public static <T> boolean newGauge(MetricsName name, MetricsCategory category, String entity, Gauge<T> metric) {
        return MetricsGroup.newGauge(name.getVal(), category, entity, Collections.emptyMap(), metric);
    }

    private static boolean newGauge(String name, MetricsCategory category, String entity, Map<String, String> tags, Metric metric) {
        return MetricsGroup.registerGaugeIfAbsent(name, category, entity, tags, metric);
    }

    public static boolean newCounter(MetricsName name, MetricsCategory category, String entity) {
        return MetricsGroup.newCounter(name, category, entity, Collections.emptyMap());
    }

    public static boolean newCounter(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags) {
        MetricsGroup.registerCounterIfAbsent(name.getVal(), category.getVal(), entity, tags);
        return true;
    }

    public static boolean newHistogram(MetricsName name, MetricsCategory category, String entity) {
        return MetricsGroup.newHistogram(name, category, entity, Collections.emptyMap());
    }

    public static boolean newHistogram(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags) {
        try {
            MetricsGroup.registerHistogramIfAbsent(name.getVal(), category.getVal(), entity, tags);
            return true;
        }
        catch (Exception e) {
            logger.warn("kylin.metrics newHistogram {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean newMeter(MetricsName name, MetricsCategory category, String entity) {
        return MetricsGroup.newMeter(name, category, entity, Collections.emptyMap());
    }

    private static boolean newMeter(MetricsName name, MetricsCategory category, String entity, Map<String, String> tags) {
        MetricsGroup.registerMeterIfAbsent(name.getVal(), category.getVal(), entity, tags);
        return true;
    }

    private static SortedMap<String, String> filterTags(Map<String, String> tags) {
        return new TreeMap<String, String>(tags.entrySet().stream().filter(e -> !"category".equals(e.getKey())).filter(e -> !"entity".equals(e.getKey())).filter(e -> StringUtils.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static String metricName(String name, String category, String entity, Map<String, String> tags) {
        Preconditions.checkNotNull((Object)name);
        StringBuilder sb = new StringBuilder(name);
        sb.append(":").append(MetricsGroup.metricNameSuffix(category, entity, tags));
        return sb.toString();
    }

    private static String metricNameSuffix(String category, String entity, Map<String, String> tags) {
        SortedMap<String, String> filteredTags;
        StringBuilder sb = new StringBuilder();
        sb.append("category=");
        sb.append(category);
        sb.append(",entity=");
        sb.append(entity);
        if (!MapUtils.isEmpty(tags) && !(filteredTags = MetricsGroup.filterTags(tags)).isEmpty()) {
            sb.append(",").append(filteredTags.entrySet().stream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerGaugeIfAbsent(String name, MetricsCategory category, String entity, Map<String, String> tags, Metric metric) {
        String metricName = MetricsGroup.metricName(name, category.getVal(), entity, tags);
        if (!gauges.contains(metricName)) {
            Set<String> set = gauges;
            synchronized (set) {
                if (!gauges.contains(metricName)) {
                    MetricsController.getDefaultMetricRegistry().register(metricName, metric);
                    gauges.add(metricName);
                    logger.trace("kylin.metrics register gauge: {}", (Object)metricName);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Counter registerCounterIfAbsent(String name, String category, String entity, Map<String, String> tags) {
        String metricName = MetricsGroup.metricName(name, category, entity, tags);
        if (!counters.containsKey(metricName)) {
            ConcurrentHashMap<String, Counter> concurrentHashMap = counters;
            synchronized (concurrentHashMap) {
                if (!counters.containsKey(metricName)) {
                    Counter metric = MetricsController.getDefaultMetricRegistry().counter(metricName);
                    long restoreVal = MetricsGroup.tryRestoreCounter(name, category, entity, tags);
                    if (restoreVal > 0L) {
                        metric.inc(restoreVal);
                        logger.trace("kylin.metrics counter=[{}] restore with value: {}", (Object)metricName, (Object)restoreVal);
                    }
                    counters.put(metricName, metric);
                    logger.trace("kylin.metrics register counter: {}", (Object)metricName);
                }
            }
        }
        return counters.get(metricName);
    }

    public static long tryRestoreCounter(String fieldName, String category, String entity, Map<String, String> tags) {
        if (!KapConfig.getInstanceFromEnv().isMonitorEnabled()) {
            return 0L;
        }
        try {
            MetricsObject metricsObject = new MetricsObject(fieldName, category, entity, tags);
            if (MetricsName.QUERY.getVal().equals(fieldName)) {
                String cacheKey = metricsObject.toString();
                cacheInfluxMetricStatusMap.put(cacheKey, metricsObject);
                long restoreVal = MetricsGroup.tryRestoreExceptionCounter(fieldName, category, entity, tags);
                cacheInfluxMetricStatusMap.get(cacheKey).setInitStatus(true);
                return restoreVal;
            }
            if (KylinConfig.getInstanceFromEnv().isDevOrUT()) {
                return 0L;
            }
            InfluxDB defaultInfluxDb = MetricsInfluxdbReporter.getInstance().getMetricInstance().getInfluxDB();
            if (!defaultInfluxDb.ping().isGood()) {
                throw new IllegalStateException("the pinged influxdb is not good.");
            }
            KapConfig config = KapConfig.getInstanceFromEnv();
            String querySql = MetricsGroup.getValFromInfluxQuerySql("", metricsObject, null);
            QueryResult result = defaultInfluxDb.query(new Query(querySql, config.getMetricsDbNameWithMetadataUrlPrefix()));
            return MetricsGroup.getResultFromSeries(result, fieldName);
        }
        catch (Exception e) {
            logger.warn("kylin.metrics tryRestoreCounter error. fieldName: [{}], category [{}], entity [{}], tags [{}]. error msg {}", new Object[]{fieldName, category, entity, tags, e.getMessage()});
            return 0L;
        }
    }

    public static void monitorRegisterMetrics() {
        cacheInfluxMetricStatusMap.keySet().forEach(cacheKey -> {
            MetricsObject metricsObject = cacheInfluxMetricStatusMap.get(cacheKey);
            if (!metricsObject.isInitStatus()) {
                String name = metricsObject.getFieldName();
                String category = metricsObject.getCategory();
                String entity = metricsObject.getEntity();
                Map<String, String> tags = metricsObject.getTags();
                String metricName = MetricsGroup.metricName(name, category, entity, tags);
                ConcurrentHashMap<String, Counter> concurrentHashMap = counters;
                synchronized (concurrentHashMap) {
                    Counter metric = MetricsController.getDefaultMetricRegistry().counter(metricName);
                    long restoreVal = MetricsGroup.tryRestoreExceptionCounter(name, category, entity, tags);
                    if (restoreVal > 0L) {
                        metric.dec(metric.getCount());
                        metric.inc(restoreVal);
                        logger.info("Restore monitorRegisterMetrics...metric.getCount()={}, name={}, entity={}, tags={}", new Object[]{metric.getCount(), name, entity, tags});
                    }
                    counters.put(metricName, metric);
                }
            }
        });
    }

    private static long tryRestoreExceptionCounter(String fieldName, String category, String entity, Map<String, String> tags) {
        if (!KapConfig.getInstanceFromEnv().isMonitorEnabled()) {
            return 0L;
        }
        MetricsObject metricsObject = new MetricsObject(fieldName, category, entity, tags);
        if (KylinConfig.getInstanceFromEnv().isDevOrUT()) {
            cacheInfluxMetricStatusMap.get(metricsObject.toString()).setInitStatus(true);
            return 9999999999L;
        }
        return MetricsGroup.tryRestoreExceptionCounter(metricsObject);
    }

    public static long tryRestoreExceptionCounter(MetricsObject metricsObject) {
        try {
            InfluxDB defaultInfluxDb = MetricsInfluxdbReporter.getInstance().getMetricInstance().getInfluxDB();
            if (!defaultInfluxDb.ping().isGood()) {
                throw new IllegalStateException("the pinged influxdb is not good.");
            }
            return MetricsGroup.tryRestoreExceptionCounter(metricsObject, defaultInfluxDb);
        }
        catch (Exception e) {
            logger.warn("Influx tryRestoreExceptionCounter error. metricsObject={}", (Object)metricsObject, (Object)e);
            return 0L;
        }
    }

    public static long tryRestoreExceptionCounter(MetricsObject metricsObject, InfluxDB defaultInfluxDb) {
        KapConfig config = KapConfig.getInstanceFromEnv();
        long currTime = System.currentTimeMillis();
        long startTime = currTime - 604800000L;
        String startTimeFilter = " and time > " + startTime + " ";
        long queryTotalTimesFirst = MetricsGroup.getValFromInflux(MetricsObjectType.FIRST.getVal(), defaultInfluxDb, config, metricsObject, startTimeFilter);
        long queryTotalTimesFirstMaxGThanFirst = MetricsGroup.getValFromInflux(MetricsObjectType.MAX.getVal(), defaultInfluxDb, config, metricsObject, startTimeFilter + " and query_total_times >= " + queryTotalTimesFirst + " ");
        long queryTotalTimesFirstMaxLThanFirst = MetricsGroup.getValFromInflux(MetricsObjectType.MAX.getVal(), defaultInfluxDb, config, metricsObject, startTimeFilter + " and query_total_times < " + queryTotalTimesFirst + " ");
        cacheInfluxMetricStatusMap.get(metricsObject.toString()).setInitStatus(true);
        return queryTotalTimesFirstMaxGThanFirst + queryTotalTimesFirstMaxLThanFirst;
    }

    public static long getValFromInflux(String metricsObjectType, InfluxDB defaultInfluxDb, KapConfig kapConfig, MetricsObject metricsObject, String filter) {
        try {
            String fieldName = metricsObject.getFieldName();
            String querySql = MetricsGroup.getValFromInfluxQuerySql(metricsObjectType, metricsObject, filter);
            QueryResult result = defaultInfluxDb.query(new Query(querySql, kapConfig.getMetricsDbNameWithMetadataUrlPrefix()));
            return MetricsGroup.getResultFromSeries(result, fieldName);
        }
        catch (Exception e) {
            logger.error("GetValFromInflux error metricsObjectType={}, metricsObject={}", new Object[]{metricsObjectType, metricsObject, e});
            return -1L;
        }
    }

    public static long getResultFromSeries(QueryResult result, String fieldName) throws ParseException {
        if (CollectionUtils.isEmpty((Collection)((QueryResult.Result)result.getResults().get(0)).getSeries())) {
            return 0L;
        }
        QueryResult.Series series = (QueryResult.Series)((QueryResult.Result)result.getResults().get(0)).getSeries().get(0);
        String valStr = fieldName.equals(series.getColumns().get(1)) ? String.valueOf(((List)series.getValues().get(0)).get(1)) : String.valueOf(((List)series.getValues().get(0)).get(0));
        return NumberFormat.getInstance(Locale.getDefault(Locale.Category.FORMAT)).parse(valStr).longValue();
    }

    public static String getValFromInfluxQuerySql(String metricsObjectType, MetricsObject metricsObject, String filter) {
        String fieldName = metricsObject.getFieldName();
        String category = metricsObject.getCategory();
        String entity = metricsObject.getEntity();
        Map<String, String> tags = metricsObject.getTags();
        StringBuilder sb = new StringBuilder("select ");
        String tempSql = "(" + fieldName + ") as " + fieldName + " ";
        switch (metricsObjectType) {
            case "last": {
                sb.append(MetricsObjectType.LAST.getVal());
                sb.append(tempSql);
                break;
            }
            case "first": {
                sb.append(MetricsObjectType.FIRST.getVal());
                sb.append(tempSql);
                break;
            }
            case "max": {
                sb.append(MetricsObjectType.MAX.getVal());
                sb.append(tempSql);
                break;
            }
            case "min": {
                sb.append(MetricsObjectType.MIN.getVal());
                sb.append(tempSql);
                break;
            }
            case "count": {
                sb.append(MetricsObjectType.COUNT.getVal());
                sb.append(tempSql);
                break;
            }
            default: {
                sb.append(fieldName);
            }
        }
        sb.append(" from ");
        sb.append("system_metric");
        sb.append(" where category='");
        sb.append(category);
        sb.append("' and entity='");
        sb.append(entity);
        sb.append("'");
        if (!MapUtils.isEmpty(tags)) {
            MetricsGroup.filterTags(tags).forEach((k, v) -> {
                sb.append(" and ");
                sb.append((String)k);
                sb.append("='");
                sb.append((String)v);
                sb.append("'");
            });
        }
        if (filter != null) {
            sb.append(filter);
        }
        sb.append(" order by time desc limit 1;");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Meter registerMeterIfAbsent(String name, String category, String entity, Map<String, String> tags) {
        String metricName = MetricsGroup.metricName(name, category, entity, tags);
        if (!meters.containsKey(metricName)) {
            ConcurrentHashMap<String, Meter> concurrentHashMap = meters;
            synchronized (concurrentHashMap) {
                if (!meters.containsKey(metricName)) {
                    Meter metric = MetricsController.getDefaultMetricRegistry().meter(metricName);
                    meters.put(metricName, metric);
                    logger.trace("kylin.metrics register meter: {}", (Object)metricName);
                }
            }
        }
        return meters.get(metricName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Histogram registerHistogramIfAbsent(String name, String category, String entity, Map<String, String> tags) {
        String metricName = MetricsGroup.metricName(name, category, entity, tags);
        if (!histograms.containsKey(metricName)) {
            ConcurrentHashMap<String, Histogram> concurrentHashMap = histograms;
            synchronized (concurrentHashMap) {
                if (!histograms.containsKey(metricName)) {
                    Histogram metric = MetricsController.getDefaultMetricRegistry().histogram(metricName);
                    histograms.put(metricName, metric);
                    logger.trace("kylin.metrics register histogram: {}", (Object)metricName);
                }
            }
        }
        return histograms.get(metricName);
    }

    private static void doRemove(String metricNameSuffix, Iterator<String> it, MetricRegistry registry) {
        while (it.hasNext()) {
            String metricName = it.next();
            try {
                String[] arr = metricName.split(":", 2);
                if (!metricNameSuffix.equals(arr[1]) && !arr[1].startsWith(metricNameSuffix + ",")) continue;
                registry.remove(metricName);
                it.remove();
                logger.trace("kylin.metrics remove metric: {}", (Object)metricName);
            }
            catch (Exception e) {
                logger.warn("kylin.metrics remove metric: {} {}", (Object)metricName, (Object)e.getMessage());
            }
        }
    }

    public static Map<String, String> getHostTagMap(String entity) {
        String host = AddressUtil.getZkLocalInstance();
        return MetricsGroup.getHostTagMap(host, entity);
    }

    public static Map<String, String> getHostTagMap(String host, String entity) {
        StringBuilder sb = new StringBuilder(host);
        sb.append("-").append(entity);
        HashMap tags = Maps.newHashMap();
        tags.put(MetricsTag.HOST.getVal(), sb.toString());
        return tags;
    }
}

