/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.metrics.MetricsConfig;
import org.apache.kylin.common.metrics.MetricsController;
import org.apache.kylin.common.metrics.MetricsReporter;
import org.apache.kylin.common.metrics.reporter.InfluxdbReporter;
import org.apache.kylin.common.metrics.service.InfluxDBInstance;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.Query;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsInfluxdbReporter
implements MetricsReporter {
    private static final Logger logger = LoggerFactory.getLogger(MetricsInfluxdbReporter.class);
    public static final String METRICS_MEASUREMENT = "system_metric";
    public static final String KYLIN_METRICS_RP = "KYLIN_METRICS_RP";
    public static final String DAILY_METRICS_RETENTION_POLICY_NAME = "KYLIN_METRICS_DAILY_RP";
    public static final String DAILY_METRICS_MEASUREMENT = "system_metric_daily";
    private AtomicInteger retry = new AtomicInteger(0);
    private AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final String reporterName = "MetricsReporter";
    private String defaultMeasurement = null;
    private InfluxdbReporter underlying = null;
    private InfluxDBInstance dailyInstance = null;
    private InfluxDBInstance metricInstance = null;

    public static MetricsInfluxdbReporter getInstance() {
        return (MetricsInfluxdbReporter)Singletons.getInstance(MetricsInfluxdbReporter.class);
    }

    private MetricsInfluxdbReporter() {
    }

    private void updateDailyMetrics(long todayStart, MetricsConfig config) {
        long yesterdayStart = TimeUtil.minusDays((long)todayStart, (int)1);
        this.underlying.getMetrics().forEach(point -> {
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append(StringUtils.join((Iterable)point.getFields().keySet().stream().map(field -> String.format(Locale.ROOT, " LAST(\"%s\") AS \"%s\" ", field, field)).collect(Collectors.toList()), (String)","));
            sql.append(String.format(Locale.ROOT, " FROM %s WHERE ", METRICS_MEASUREMENT));
            sql.append(String.format(Locale.ROOT, " time >= %dms AND time < %dms ", yesterdayStart, todayStart));
            point.getTags().forEach((tag, value) -> sql.append(String.format(Locale.ROOT, " AND %s='%s' ", tag, value)));
            QueryResult queryResult = this.underlying.getInfluxDb().query(new Query(sql.toString(), config.getMetricsDB()));
            if (CollectionUtils.isEmpty((Collection)queryResult.getResults()) || CollectionUtils.isEmpty((Collection)((QueryResult.Result)queryResult.getResults().get(0)).getSeries()) || CollectionUtils.isEmpty((Collection)((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getValues())) {
                logger.warn("Failed to aggregate metric, cause query result is empty, uKey: {}!", (Object)point.getUniqueKey());
                return;
            }
            List columns = ((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getColumns();
            List firstLine = (List)((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getValues().get(0);
            HashMap fields = Maps.newHashMap();
            for (int i = 1; i < columns.size(); ++i) {
                fields.put(columns.get(i), firstLine.get(i));
            }
            this.dailyInstance.write(DAILY_METRICS_MEASUREMENT, point.getTags(), fields, yesterdayStart);
        });
    }

    private void startDailyReport(MetricsConfig config) {
        this.dailyInstance = new InfluxDBInstance(config.getDailyMetricsDB(), DAILY_METRICS_RETENTION_POLICY_NAME, "0d", "30d", 2, true);
        this.dailyInstance.init();
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(() -> {
            try {
                logger.debug("Start to aggregate daily metrics ...");
                long now = System.currentTimeMillis();
                long todayStart = TimeUtil.getDayStart((long)now);
                if (this.lastUpdateTime.get() > 0L && (this.retry.get() == 0 || this.retry.get() > config.getDailyMetricsMaxRetryTimes())) {
                    if (this.lastUpdateTime.get() > todayStart) {
                        return;
                    }
                    if (config.getDailyMetricsRunHour() != TimeUtil.getHour((long)now)) {
                        return;
                    }
                    this.retry.set(0);
                }
                if (CollectionUtils.isEmpty(this.underlying.getMetrics())) {
                    return;
                }
                this.lastUpdateTime.set(now);
                this.updateDailyMetrics(todayStart, config);
                this.retry.set(0);
                logger.debug("Aggregate daily metrics success ...");
            }
            catch (Exception e) {
                this.retry.incrementAndGet();
                logger.error("Failed to aggregate daily metrics, retry: {}", (Object)this.retry.get(), (Object)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(KapConfig kapConfig) {
        MetricsInfluxdbReporter metricsInfluxdbReporter = this;
        synchronized (metricsInfluxdbReporter) {
            if (!this.initialized.get()) {
                MetricsConfig config = new MetricsConfig(kapConfig);
                this.defaultMeasurement = METRICS_MEASUREMENT;
                this.metricInstance = new InfluxDBInstance(config.getMetricsDB(), KYLIN_METRICS_RP, "30d", "7d", 1, true);
                this.metricInstance.init();
                this.underlying = new InfluxdbReporter(this.metricInstance, this.defaultMeasurement, MetricsController.getDefaultMetricRegistry(), "MetricsReporter");
                this.initialized.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(KapConfig kapConfig) {
        MetricsInfluxdbReporter metricsInfluxdbReporter = this;
        synchronized (metricsInfluxdbReporter) {
            if (this.initialized.get()) {
                MetricsConfig config = new MetricsConfig(kapConfig);
                this.startReporter(config.pollingIntervalSecs());
                this.startDailyReport(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReporter(int pollingPeriodInSeconds) {
        MetricsInfluxdbReporter metricsInfluxdbReporter = this;
        synchronized (metricsInfluxdbReporter) {
            if (this.initialized.get() && !this.running.get()) {
                this.underlying.report();
                this.underlying.start(pollingPeriodInSeconds, TimeUnit.SECONDS);
                this.running.set(true);
                logger.info("kylin.metrics influxdb reporter started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReporter() {
        MetricsInfluxdbReporter metricsInfluxdbReporter = this;
        synchronized (metricsInfluxdbReporter) {
            if (this.initialized.get() && this.running.get()) {
                this.underlying.stop();
                this.underlying.close();
                this.running.set(false);
            }
        }
    }

    @Override
    public String getMBeanName() {
        return "kylin.metrics:type=NMetricsInfluxdbReporter";
    }

    @VisibleForTesting
    public boolean isRunning() {
        return this.running.get();
    }

    @Generated
    public InfluxDBInstance getMetricInstance() {
        return this.metricInstance;
    }
}

