/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dao;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.domain.JobLock;
import org.apache.kylin.job.exception.ExecuteRuntimeException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.mapper.JobInfoMapper;
import org.apache.kylin.job.mapper.JobLockMapper;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.job.util.JobInfoUtil;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;

@Component
public class JobInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(JobInfoDao.class);
    @Autowired(required=false)
    private JobInfoMapper jobInfoMapper;
    @Autowired(required=false)
    private JobLockMapper jobLockMapper;

    public List<JobInfo> getJobInfoListByFilter(JobMapperFilter jobMapperFilter) {
        List<JobInfo> jobInfoList = this.jobInfoMapper.selectByJobFilter(jobMapperFilter);
        return jobInfoList;
    }

    public long countByFilter(JobMapperFilter jobMapperFilter) {
        return this.jobInfoMapper.countByJobFilter(jobMapperFilter);
    }

    public List<ExecutablePO> getJobs(String project) {
        JobMapperFilter filter = new JobMapperFilter();
        filter.setProject(project);
        return this.jobInfoMapper.selectByJobFilter(filter).stream().map(JobInfoUtil::deserializeExecutablePO).collect(Collectors.toList());
    }

    public List<ExecutablePO> getJobs(String project, long timeStart, long timeEndExclusive) {
        return this.getJobs(project).stream().filter(x -> x.getLastModified() >= timeStart && x.getLastModified() < timeEndExclusive).collect(Collectors.toList());
    }

    public ExecutablePO addJob(ExecutablePO executablePO) {
        if (this.getExecutablePOByUuid(executablePO.getUuid()) != null) {
            throw new IllegalArgumentException("job id:" + executablePO.getUuid() + " already exists");
        }
        executablePO.setLastModified(System.currentTimeMillis());
        this.jobInfoMapper.insertJobInfoSelective(this.constructJobInfo(executablePO, 1L));
        return executablePO;
    }

    public void updateJob(String uuid, Predicate<ExecutablePO> updater) {
        if (!KylinConfig.getInstanceFromEnv().isUTEnv() && !JdbcUtil.isInExistingTx()) {
            logger.warn("Job is updated without explicitly opening a transaction.");
        }
        JobInfo jobInfo = this.jobInfoMapper.selectByJobId(uuid);
        Preconditions.checkNotNull((Object)jobInfo);
        ExecutablePO job = JobInfoUtil.deserializeExecutablePO(jobInfo);
        Preconditions.checkNotNull((Object)((Object)job));
        ExecutablePO copyForWrite = (ExecutablePO)JsonUtil.copyBySerialization((RootPersistentEntity)job, JobInfoUtil.JOB_SERIALIZER, null);
        copyForWrite.setProject(job.getProject());
        if (updater.test(copyForWrite)) {
            copyForWrite.setLastModified(System.currentTimeMillis());
            int updateAffect = this.jobInfoMapper.updateByJobIdSelective(this.constructJobInfo(copyForWrite, jobInfo.getMvcc()));
            if (updateAffect == 0) {
                String errorMeg = String.format(Locale.ROOT, "job_info update fail for mvcc, job_id = %1s, mvcc = %2d", job.getId(), jobInfo.getMvcc());
                logger.warn(errorMeg);
                throw new OptimisticLockingFailureException(errorMeg);
            }
        }
    }

    public ExecutablePO getExecutablePOByUuid(String uuid) {
        JobInfo jobInfo = this.jobInfoMapper.selectByJobId(uuid);
        if (null != jobInfo) {
            return JobInfoUtil.deserializeExecutablePO(jobInfo);
        }
        return null;
    }

    public List<ExecutablePO> getExecutablePoByStatus(String project, List<String> jobIds, List<ExecutableState> filterStatuses) {
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setProject(project);
        jobMapperFilter.setStatuses(filterStatuses);
        jobMapperFilter.setJobIds(jobIds);
        List<JobInfo> jobInfoList = this.jobInfoMapper.selectByJobFilter(jobMapperFilter);
        if (CollectionUtils.isEmpty(jobInfoList)) {
            return new ArrayList<ExecutablePO>();
        }
        return jobInfoList.stream().map(jobInfo -> JobInfoUtil.deserializeExecutablePO(jobInfo)).collect(Collectors.toList());
    }

    public void dropJob(String jobId) {
        this.jobInfoMapper.deleteByJobId(jobId);
    }

    public void dropJobByIdList(List<String> jobIdList) {
        this.jobInfoMapper.deleteByJobIdList(Arrays.stream(ExecutableState.getFinalStates()).map(executableState -> executableState.name()).collect(Collectors.toList()), jobIdList);
    }

    public void dropAllJobs() {
        this.jobInfoMapper.deleteAllJob();
    }

    public JobInfo constructJobInfo(ExecutablePO executablePO, long mvcc) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setJobId(executablePO.getId());
        jobInfo.setJobType(executablePO.getJobType().name());
        ExecutableState executableState = ExecutableState.valueOf(executablePO.getOutput().getStatus());
        jobInfo.setJobStatus(executableState.name());
        jobInfo.setProject(executablePO.getProject());
        jobInfo.setPriority(executablePO.getPriority());
        String subject = null;
        switch (executablePO.getJobType().getCategory()) {
            case "INTERNAL": 
            case "SNAPSHOT": {
                subject = executablePO.getParams().get("table");
                break;
            }
            case "CRON": {
                subject = executablePO.getJobType().name();
                break;
            }
            default: {
                if (JobTypeEnum.TABLE_SAMPLING == executablePO.getJobType() || JobTypeEnum.LAYOUT_DATA_OPTIMIZE == executablePO.getJobType()) {
                    subject = executablePO.getTargetModel();
                    break;
                }
                if (null == executablePO.getTargetModel() || null == executablePO.getProject()) break;
                if (executablePO.getParams().containsKey("modelName")) {
                    subject = executablePO.getParams().get("modelName");
                    break;
                }
                NDataModelManager nDataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)executablePO.getProject());
                NDataModel nDataModel = nDataModelManager.getDataModelDesc(executablePO.getTargetModel());
                if (null == nDataModel) {
                    logger.warn("Can not get modelName by modelId {}, project {}", (Object)executablePO.getTargetModel(), (Object)executablePO.getProject());
                    break;
                }
                subject = nDataModel.getAlias();
            }
        }
        jobInfo.setSubject(subject);
        jobInfo.setModelId(executablePO.getTargetModel());
        jobInfo.setCreateTime(executablePO.getCreateTime());
        jobInfo.setUpdateTime(executablePO.getLastModified());
        jobInfo.setJobContent(this.checkAndCompressJobContent(JobInfoUtil.serializeExecutablePO(executablePO)));
        ExecutableManager executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), executablePO.getProject());
        AbstractExecutable executable = executableManager.fromPO(executablePO);
        long duration = executable.getDurationFromStepOrStageDurationSum(executablePO);
        jobInfo.setJobDurationMillis(duration);
        jobInfo.setMvcc(mvcc);
        return jobInfo;
    }

    private byte[] checkAndCompressJobContent(byte[] jobContent) {
        try {
            return CompressionUtils.compress((byte[])jobContent);
        }
        catch (IOException e) {
            throw new ExecuteRuntimeException("Compress job content failed.", e);
        }
    }

    public void deleteJobsByProject(String project) {
        int count = this.jobInfoMapper.deleteByProject(project);
        logger.info("delete {} jobs for project {}", (Object)count, (Object)project);
    }

    public List<JobLock> fetchAllJobLock() {
        return this.jobLockMapper.fetchAll();
    }

    public void restoreJobInfo(List<JobInfo> jobInfos, String project, boolean afterTruncate) {
        JobContextUtil.withTxAndRetry(() -> {
            if (afterTruncate) {
                this.jobInfoMapper.deleteByProject(project);
            }
            for (JobInfo jobInfo : jobInfos) {
                jobInfo.setJobContent(this.checkAndCompressJobContent(jobInfo.getJobContent()));
                JobInfo currentJobInfo = this.jobInfoMapper.selectByJobId(jobInfo.getJobId());
                if (currentJobInfo == null) {
                    this.jobInfoMapper.insert(jobInfo);
                    continue;
                }
                jobInfo.setMvcc(currentJobInfo.getMvcc());
                this.jobInfoMapper.updateByJobIdSelective(jobInfo);
            }
            return null;
        });
    }

    public Long getEarliestJobCreateTime() {
        return this.getEarliestJobCreateTime(null);
    }

    public Long getEarliestJobCreateTime(String project) {
        return this.jobInfoMapper.getEarliestCreateTime(project);
    }

    @Generated
    public void setJobInfoMapper(JobInfoMapper jobInfoMapper) {
        this.jobInfoMapper = jobInfoMapper;
    }

    @Generated
    public void setJobLockMapper(JobLockMapper jobLockMapper) {
        this.jobLockMapper = jobLockMapper;
    }
}

