/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.handler;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import lombok.Generated;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.AbstractJobHandler;
import org.apache.kylin.job.model.JobParam;

public class IndexPlanOptimizeJobHandler
extends AbstractJobHandler {
    @Override
    protected AbstractExecutable createJob(JobParam jobParam) {
        return JobFactory.createJob("INDEX_PLAN_OPTIMIZE_JOB_FACTORY", new IndexPlanOptimizeJobParam(jobParam));
    }

    @Override
    protected void checkBeforeHandle(JobParam jobParam) {
    }

    public static class IndexPlanOptimizeJobParam
    extends JobFactory.JobBuildParams {
        private final String project;
        private final String dataflowId;
        private final Integer initializeCuboidCount;
        private final Integer maxCuboidCount;
        private final Integer maxCuboidChangeCount;
        private final Long dataRangeStart;
        private final Long dataRangeEnd;
        private final boolean isAutoApproveEnabled;
        private final String operationToken;

        public IndexPlanOptimizeJobParam(JobParam jobParam) {
            super(null, jobParam.getDeleteLayouts(), jobParam.getOwner(), jobParam.getJobTypeEnum(), jobParam.getJobId(), jobParam.getDeleteLayouts(), jobParam.getIgnoredSnapshotTables(), jobParam.getTargetPartitions(), jobParam.getTargetBuckets(), jobParam.getExtParams());
            this.project = jobParam.getProject();
            this.dataflowId = jobParam.getExtParams().get("dataflowId");
            this.initializeCuboidCount = Integer.parseInt(jobParam.getExtParams().getOrDefault("kylin.planner.initializeCuboidCount", "0"));
            this.maxCuboidCount = Integer.parseInt(jobParam.getExtParams().get("kylin.planner.maxCuboidCount"));
            this.maxCuboidChangeCount = Integer.parseInt(jobParam.getExtParams().getOrDefault("kylin.planner.maxCuboidChangeCount", String.valueOf(0L)));
            this.dataRangeStart = Long.parseLong(jobParam.getExtParams().get("kylin.planner.dataRangeStart"));
            this.dataRangeEnd = Long.parseLong(jobParam.getExtParams().getOrDefault("kylin.planner.dataRangeEnd", String.valueOf(LocalDate.now(ZoneId.systemDefault()).atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli())));
            this.isAutoApproveEnabled = Boolean.parseBoolean(jobParam.getExtParams().getOrDefault("kylin.planner.autoApproveEnabled", Boolean.FALSE.toString()));
            this.operationToken = jobParam.getExtParams().get("kylin.planner.operationToken");
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getDataflowId() {
            return this.dataflowId;
        }

        @Generated
        public Integer getInitializeCuboidCount() {
            return this.initializeCuboidCount;
        }

        @Generated
        public Integer getMaxCuboidCount() {
            return this.maxCuboidCount;
        }

        @Generated
        public Integer getMaxCuboidChangeCount() {
            return this.maxCuboidChangeCount;
        }

        @Generated
        public Long getDataRangeStart() {
            return this.dataRangeStart;
        }

        @Generated
        public Long getDataRangeEnd() {
            return this.dataRangeEnd;
        }

        @Generated
        public boolean isAutoApproveEnabled() {
            return this.isAutoApproveEnabled;
        }

        @Generated
        public String getOperationToken() {
            return this.operationToken;
        }
    }
}

