/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.model;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.job.JobBucket;

public class JobParam {
    private String jobId = RandomUtil.randomUUIDStr();
    private Set<String> targetSegments = Sets.newHashSet();
    private Set<Long> targetLayouts = Sets.newHashSet();
    private String table;
    private String owner;
    private String model;
    private String project;
    private JobTypeEnum jobTypeEnum;
    private Set<String> ignoredSnapshotTables;
    private Set<Long> targetPartitions = Sets.newHashSet();
    private Set<JobBucket> targetBuckets = Sets.newHashSet();
    private int priority = 3;
    private String yarnQueue;
    private Object tag;
    private Map<String, Object> condition = Maps.newHashMap();
    private Set<LayoutEntity> processLayouts;
    private Set<LayoutEntity> deleteLayouts;
    private boolean layoutsDeletableAfterBuild = false;
    private Set<Long> secondStorageDeleteLayoutIds;

    public JobParam addExtParams(String key, String value) {
        Map<String, String> params = this.getExtParams();
        params.put(key, value);
        this.getCondition().putIfAbsent("EXT_PARAMS_JOB", params);
        return this;
    }

    public Map<String, String> getExtParams() {
        return (Map)this.getCondition().getOrDefault("EXT_PARAMS_JOB", Maps.newHashMap());
    }

    public JobParam(String model, String owner) {
        this.model = model;
        this.owner = owner;
        this.setJobId(this.getJobId() + "-" + model);
    }

    public JobParam(Set<String> targetSegments, Set<Long> targetLayouts, String model, String owner, Set<Long> targetPartitions, Set<JobBucket> targetBuckets) {
        this(model, owner);
        this.withTargetSegments(targetSegments);
        this.setTargetLayouts(targetLayouts);
        if (CollectionUtils.isNotEmpty(targetPartitions)) {
            this.setTargetPartitions(targetPartitions);
        }
        if (CollectionUtils.isNotEmpty(targetBuckets)) {
            this.setTargetBuckets(targetBuckets);
        }
    }

    public JobParam(NDataSegment newSegment, String model, String owner) {
        this(model, owner);
        if (Objects.nonNull(newSegment)) {
            this.targetSegments.add(newSegment.getId());
        }
    }

    public JobParam(Set<String> targetSegments, Set<Long> targetLayouts, String model, String owner) {
        this(targetSegments, targetLayouts, model, owner, null, null);
    }

    public JobParam(NDataSegment newSegment, String model, String owner, Set<Long> targetLayouts) {
        this(newSegment, model, owner);
        this.setTargetLayouts(targetLayouts);
    }

    public JobParam withProject(String project) {
        this.project = project;
        return this;
    }

    public JobParam withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public JobParam withIgnoredSnapshotTables(Set<String> ignoredSnapshotTables) {
        this.ignoredSnapshotTables = ignoredSnapshotTables;
        return this;
    }

    public JobParam withJobTypeEnum(JobTypeEnum jobTypeEnum) {
        this.jobTypeEnum = jobTypeEnum;
        return this;
    }

    public JobParam withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public JobParam withTargetSegments(Set<String> targetSegments) {
        if (Objects.nonNull(targetSegments)) {
            this.targetSegments = targetSegments;
        }
        return this;
    }

    public JobParam withYarnQueue(String yarnQueue) {
        this.yarnQueue = yarnQueue;
        return this;
    }

    public JobParam withTag(Object tag) {
        this.tag = tag;
        return this;
    }

    public JobParam withTable(String table) {
        this.table = table;
        return this;
    }

    public JobParam withTargetLayouts(Set<Long> targetLayouts) {
        this.targetLayouts = targetLayouts;
        return this;
    }

    public void setTargetLayouts(Set<Long> targetLayouts) {
        if (Objects.nonNull(targetLayouts)) {
            this.targetLayouts = targetLayouts;
        }
    }

    public void setCondition(Map<String, Object> condition) {
        if (Objects.nonNull(condition)) {
            this.condition = condition;
        }
    }

    public String getSegment() {
        if (this.targetSegments.size() != 1) {
            return null;
        }
        return this.targetSegments.iterator().next();
    }

    public boolean isMultiPartitionJob() {
        return (Boolean)this.condition.getOrDefault("MULTI_PARTITION_JOB", false);
    }

    public static boolean isBuildIndexJob(JobTypeEnum jobTypeEnum) {
        return JobTypeEnum.INDEX_BUILD == jobTypeEnum || JobTypeEnum.SUB_PARTITION_BUILD == jobTypeEnum;
    }

    public static boolean isRefreshJob(JobTypeEnum jobTypeEnum) {
        return JobTypeEnum.INDEX_REFRESH == jobTypeEnum || JobTypeEnum.SUB_PARTITION_REFRESH == jobTypeEnum;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public Set<String> getTargetSegments() {
        return this.targetSegments;
    }

    @Generated
    public Set<Long> getTargetLayouts() {
        return this.targetLayouts;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public JobTypeEnum getJobTypeEnum() {
        return this.jobTypeEnum;
    }

    @Generated
    public Set<String> getIgnoredSnapshotTables() {
        return this.ignoredSnapshotTables;
    }

    @Generated
    public Set<Long> getTargetPartitions() {
        return this.targetPartitions;
    }

    @Generated
    public Set<JobBucket> getTargetBuckets() {
        return this.targetBuckets;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public String getYarnQueue() {
        return this.yarnQueue;
    }

    @Generated
    public Object getTag() {
        return this.tag;
    }

    @Generated
    public Map<String, Object> getCondition() {
        return this.condition;
    }

    @Generated
    public Set<LayoutEntity> getProcessLayouts() {
        return this.processLayouts;
    }

    @Generated
    public Set<LayoutEntity> getDeleteLayouts() {
        return this.deleteLayouts;
    }

    @Generated
    public boolean isLayoutsDeletableAfterBuild() {
        return this.layoutsDeletableAfterBuild;
    }

    @Generated
    public Set<Long> getSecondStorageDeleteLayoutIds() {
        return this.secondStorageDeleteLayoutIds;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setJobTypeEnum(JobTypeEnum jobTypeEnum) {
        this.jobTypeEnum = jobTypeEnum;
    }

    @Generated
    public void setIgnoredSnapshotTables(Set<String> ignoredSnapshotTables) {
        this.ignoredSnapshotTables = ignoredSnapshotTables;
    }

    @Generated
    public void setTargetPartitions(Set<Long> targetPartitions) {
        this.targetPartitions = targetPartitions;
    }

    @Generated
    public void setTargetBuckets(Set<JobBucket> targetBuckets) {
        this.targetBuckets = targetBuckets;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setYarnQueue(String yarnQueue) {
        this.yarnQueue = yarnQueue;
    }

    @Generated
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Generated
    public void setProcessLayouts(Set<LayoutEntity> processLayouts) {
        this.processLayouts = processLayouts;
    }

    @Generated
    public void setDeleteLayouts(Set<LayoutEntity> deleteLayouts) {
        this.deleteLayouts = deleteLayouts;
    }

    @Generated
    public void setLayoutsDeletableAfterBuild(boolean layoutsDeletableAfterBuild) {
        this.layoutsDeletableAfterBuild = layoutsDeletableAfterBuild;
    }

    @Generated
    public void setSecondStorageDeleteLayoutIds(Set<Long> secondStorageDeleteLayoutIds) {
        this.secondStorageDeleteLayoutIds = secondStorageDeleteLayoutIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobParam)) {
            return false;
        }
        JobParam other = (JobParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        Set<String> this$targetSegments = this.getTargetSegments();
        Set<String> other$targetSegments = other.getTargetSegments();
        if (this$targetSegments == null ? other$targetSegments != null : !((Object)this$targetSegments).equals(other$targetSegments)) {
            return false;
        }
        Set<Long> this$targetLayouts = this.getTargetLayouts();
        Set<Long> other$targetLayouts = other.getTargetLayouts();
        if (this$targetLayouts == null ? other$targetLayouts != null : !((Object)this$targetLayouts).equals(other$targetLayouts)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        JobTypeEnum this$jobTypeEnum = this.getJobTypeEnum();
        JobTypeEnum other$jobTypeEnum = other.getJobTypeEnum();
        if (this$jobTypeEnum == null ? other$jobTypeEnum != null : !((Object)((Object)this$jobTypeEnum)).equals((Object)other$jobTypeEnum)) {
            return false;
        }
        Set<String> this$ignoredSnapshotTables = this.getIgnoredSnapshotTables();
        Set<String> other$ignoredSnapshotTables = other.getIgnoredSnapshotTables();
        if (this$ignoredSnapshotTables == null ? other$ignoredSnapshotTables != null : !((Object)this$ignoredSnapshotTables).equals(other$ignoredSnapshotTables)) {
            return false;
        }
        Set<Long> this$targetPartitions = this.getTargetPartitions();
        Set<Long> other$targetPartitions = other.getTargetPartitions();
        if (this$targetPartitions == null ? other$targetPartitions != null : !((Object)this$targetPartitions).equals(other$targetPartitions)) {
            return false;
        }
        Set<JobBucket> this$targetBuckets = this.getTargetBuckets();
        Set<JobBucket> other$targetBuckets = other.getTargetBuckets();
        if (this$targetBuckets == null ? other$targetBuckets != null : !((Object)this$targetBuckets).equals(other$targetBuckets)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        String this$yarnQueue = this.getYarnQueue();
        String other$yarnQueue = other.getYarnQueue();
        if (this$yarnQueue == null ? other$yarnQueue != null : !this$yarnQueue.equals(other$yarnQueue)) {
            return false;
        }
        Object this$tag = this.getTag();
        Object other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        Map<String, Object> this$condition = this.getCondition();
        Map<String, Object> other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        Set<LayoutEntity> this$processLayouts = this.getProcessLayouts();
        Set<LayoutEntity> other$processLayouts = other.getProcessLayouts();
        if (this$processLayouts == null ? other$processLayouts != null : !((Object)this$processLayouts).equals(other$processLayouts)) {
            return false;
        }
        Set<LayoutEntity> this$deleteLayouts = this.getDeleteLayouts();
        Set<LayoutEntity> other$deleteLayouts = other.getDeleteLayouts();
        if (this$deleteLayouts == null ? other$deleteLayouts != null : !((Object)this$deleteLayouts).equals(other$deleteLayouts)) {
            return false;
        }
        if (this.isLayoutsDeletableAfterBuild() != other.isLayoutsDeletableAfterBuild()) {
            return false;
        }
        Set<Long> this$secondStorageDeleteLayoutIds = this.getSecondStorageDeleteLayoutIds();
        Set<Long> other$secondStorageDeleteLayoutIds = other.getSecondStorageDeleteLayoutIds();
        return !(this$secondStorageDeleteLayoutIds == null ? other$secondStorageDeleteLayoutIds != null : !((Object)this$secondStorageDeleteLayoutIds).equals(other$secondStorageDeleteLayoutIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JobParam;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        Set<String> $targetSegments = this.getTargetSegments();
        result = result * 59 + ($targetSegments == null ? 43 : ((Object)$targetSegments).hashCode());
        Set<Long> $targetLayouts = this.getTargetLayouts();
        result = result * 59 + ($targetLayouts == null ? 43 : ((Object)$targetLayouts).hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        JobTypeEnum $jobTypeEnum = this.getJobTypeEnum();
        result = result * 59 + ($jobTypeEnum == null ? 43 : ((Object)((Object)$jobTypeEnum)).hashCode());
        Set<String> $ignoredSnapshotTables = this.getIgnoredSnapshotTables();
        result = result * 59 + ($ignoredSnapshotTables == null ? 43 : ((Object)$ignoredSnapshotTables).hashCode());
        Set<Long> $targetPartitions = this.getTargetPartitions();
        result = result * 59 + ($targetPartitions == null ? 43 : ((Object)$targetPartitions).hashCode());
        Set<JobBucket> $targetBuckets = this.getTargetBuckets();
        result = result * 59 + ($targetBuckets == null ? 43 : ((Object)$targetBuckets).hashCode());
        result = result * 59 + this.getPriority();
        String $yarnQueue = this.getYarnQueue();
        result = result * 59 + ($yarnQueue == null ? 43 : $yarnQueue.hashCode());
        Object $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        Map<String, Object> $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        Set<LayoutEntity> $processLayouts = this.getProcessLayouts();
        result = result * 59 + ($processLayouts == null ? 43 : ((Object)$processLayouts).hashCode());
        Set<LayoutEntity> $deleteLayouts = this.getDeleteLayouts();
        result = result * 59 + ($deleteLayouts == null ? 43 : ((Object)$deleteLayouts).hashCode());
        result = result * 59 + (this.isLayoutsDeletableAfterBuild() ? 79 : 97);
        Set<Long> $secondStorageDeleteLayoutIds = this.getSecondStorageDeleteLayoutIds();
        result = result * 59 + ($secondStorageDeleteLayoutIds == null ? 43 : ((Object)$secondStorageDeleteLayoutIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JobParam(jobId=" + this.getJobId() + ", targetSegments=" + this.getTargetSegments() + ", targetLayouts=" + this.getTargetLayouts() + ", table=" + this.getTable() + ", owner=" + this.getOwner() + ", model=" + this.getModel() + ", project=" + this.getProject() + ", jobTypeEnum=" + (Object)((Object)this.getJobTypeEnum()) + ", ignoredSnapshotTables=" + this.getIgnoredSnapshotTables() + ", targetPartitions=" + this.getTargetPartitions() + ", targetBuckets=" + this.getTargetBuckets() + ", priority=" + this.getPriority() + ", yarnQueue=" + this.getYarnQueue() + ", tag=" + this.getTag() + ", condition=" + this.getCondition() + ", processLayouts=" + this.getProcessLayouts() + ", deleteLayouts=" + this.getDeleteLayouts() + ", layoutsDeletableAfterBuild=" + this.isLayoutsDeletableAfterBuild() + ", secondStorageDeleteLayoutIds=" + this.getSecondStorageDeleteLayoutIds() + ")";
    }

    @Generated
    public JobParam(String jobId, Set<String> targetSegments, Set<Long> targetLayouts, String table, String owner, String model, String project, JobTypeEnum jobTypeEnum, Set<String> ignoredSnapshotTables, Set<Long> targetPartitions, Set<JobBucket> targetBuckets, int priority, String yarnQueue, Object tag, Map<String, Object> condition, Set<LayoutEntity> processLayouts, Set<LayoutEntity> deleteLayouts, boolean layoutsDeletableAfterBuild, Set<Long> secondStorageDeleteLayoutIds) {
        this.jobId = jobId;
        this.targetSegments = targetSegments;
        this.targetLayouts = targetLayouts;
        this.table = table;
        this.owner = owner;
        this.model = model;
        this.project = project;
        this.jobTypeEnum = jobTypeEnum;
        this.ignoredSnapshotTables = ignoredSnapshotTables;
        this.targetPartitions = targetPartitions;
        this.targetBuckets = targetBuckets;
        this.priority = priority;
        this.yarnQueue = yarnQueue;
        this.tag = tag;
        this.condition = condition;
        this.processLayouts = processLayouts;
        this.deleteLayouts = deleteLayouts;
        this.layoutsDeletableAfterBuild = layoutsDeletableAfterBuild;
        this.secondStorageDeleteLayoutIds = secondStorageDeleteLayoutIds;
    }

    @Generated
    public JobParam() {
    }

    public static class ConditionConstant {
        public static final String REFRESH_ALL_LAYOUTS = "REFRESH_ALL_LAYOUTS";
        public static final String MULTI_PARTITION_JOB = "MULTI_PARTITION_JOB";
        public static final String EXT_PARAMS_JOB = "EXT_PARAMS_JOB";

        private ConditionConstant() {
        }
    }
}

