/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.query.util.SparkJobTrace;
import org.apache.kylin.query.util.SparkJobTraceMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHistoryScheduler {
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    protected BlockingQueue<QueryMetrics> queryMetricsQueue;
    private ScheduledExecutorService writeQueryHistoryScheduler;
    private long sparkJobTraceTimeoutMs;
    private boolean isQuerySparkJobTraceEnabled;

    public QueryHistoryScheduler() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.queryMetricsQueue = new LinkedBlockingQueue<QueryMetrics>(kylinConfig.getQueryHistoryBufferSize());
        logger.debug("New NQueryHistoryScheduler created");
    }

    public static QueryHistoryScheduler getInstance() {
        return (QueryHistoryScheduler)Singletons.getInstance(QueryHistoryScheduler.class);
    }

    public void init() throws Exception {
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        this.sparkJobTraceTimeoutMs = kapConfig.getSparkJobTraceTimeoutMs();
        this.isQuerySparkJobTraceEnabled = kapConfig.isQuerySparkJobTraceEnabled();
        this.writeQueryHistoryScheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("WriteQueryHistoryWorker"));
        KylinConfig kyinConfig = KylinConfig.getInstanceFromEnv();
        this.writeQueryHistoryScheduler.scheduleWithFixedDelay(new WriteQueryHistoryRunner(), 1L, kyinConfig.getQueryHistorySchedulerInterval(), TimeUnit.SECONDS);
    }

    public void offerQueryHistoryQueue(QueryMetrics queryMetrics) {
        boolean offer = this.queryMetricsQueue.offer(queryMetrics);
        if (!offer) {
            logger.info("queryMetricsQueue is full");
        }
    }

    synchronized void shutdown() {
        logger.info("Shutting down NQueryHistoryScheduler ....");
        if (this.writeQueryHistoryScheduler != null) {
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.writeQueryHistoryScheduler);
        }
    }

    public boolean isCollectedFinished(String queryId, SparkJobTraceMetric sparkJobTraceMetric, QueryMetrics queryMetrics) {
        if (sparkJobTraceMetric != null) {
            List queryTraceSpans = queryMetrics.getQueryHistoryInfo().getTraces();
            AtomicLong timeCostSum = new AtomicLong(0L);
            queryTraceSpans.forEach(span -> {
                if ("PREPARE_AND_SUBMIT_JOB".equals(span.getName())) {
                    span.setDuration(sparkJobTraceMetric.getPrepareAndSubmitJobMs());
                }
                timeCostSum.addAndGet(span.getDuration());
            });
            queryTraceSpans.add(new QueryHistoryInfo.QueryTraceSpan("WAIT_FOR_EXECUTION", (String)QueryTrace.SPAN_GROUPS.get("WAIT_FOR_EXECUTION"), sparkJobTraceMetric.getWaitForExecutionMs()));
            timeCostSum.addAndGet(sparkJobTraceMetric.getWaitForExecutionMs());
            queryTraceSpans.add(new QueryHistoryInfo.QueryTraceSpan("EXECUTION", (String)QueryTrace.SPAN_GROUPS.get("EXECUTION"), sparkJobTraceMetric.getExecutionMs()));
            timeCostSum.addAndGet(sparkJobTraceMetric.getExecutionMs());
            queryTraceSpans.add(new QueryHistoryInfo.QueryTraceSpan("FETCH_RESULT", (String)QueryTrace.SPAN_GROUPS.get("FETCH_RESULT"), queryMetrics.getQueryDuration() - timeCostSum.get()));
            return true;
        }
        if (System.currentTimeMillis() - (queryMetrics.getQueryTime() + queryMetrics.getQueryDuration()) > this.sparkJobTraceTimeoutMs) {
            logger.warn("QueryMetrics timeout lost spark job trace kylin.query.spark-job-trace-timeout-ms={} queryId:{}", (Object)this.sparkJobTraceTimeoutMs, (Object)queryId);
            return true;
        }
        this.offerQueryHistoryQueue(queryMetrics);
        return false;
    }

    public class WriteQueryHistoryRunner
    implements Runnable {
        RDBMSQueryHistoryDAO queryHistoryDAO = RDBMSQueryHistoryDAO.getInstance();

        WriteQueryHistoryRunner() {
        }

        @Override
        public void run() {
            try {
                List<QueryMetrics> updateMetrics;
                ArrayList metrics = Lists.newArrayList();
                QueryHistoryScheduler.this.queryMetricsQueue.drainTo(metrics);
                List insertMetrics = QueryHistoryScheduler.this.isQuerySparkJobTraceEnabled && metrics.size() > 0 ? metrics.stream().filter(qm -> !qm.isUpdateMetrics()).filter(queryMetrics -> {
                    String queryId = queryMetrics.getQueryId();
                    SparkJobTraceMetric sparkJobTraceMetric = SparkJobTrace.getSparkJobTraceMetric((String)queryId);
                    return QueryHistoryScheduler.this.isCollectedFinished(queryId, sparkJobTraceMetric, (QueryMetrics)queryMetrics);
                }).collect(Collectors.toList()) : metrics.stream().filter(qm -> !qm.isUpdateMetrics()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(insertMetrics)) {
                    this.queryHistoryDAO.insert(insertMetrics);
                }
                if (CollectionUtils.isNotEmpty(updateMetrics = metrics.stream().filter(QueryMetrics::isUpdateMetrics).collect(Collectors.toList()))) {
                    this.updateQueryMetricsTrace(updateMetrics);
                }
            }
            catch (Exception th) {
                logger.error("Error when write query history", (Throwable)th);
            }
        }

        private void updateQueryMetricsTrace(List<QueryMetrics> updateMetrics) {
            List queryIds = updateMetrics.stream().map(QueryMetrics::getQueryId).collect(Collectors.toList());
            Map<String, List<QueryMetrics>> metricsMap = updateMetrics.stream().collect(Collectors.groupingBy(QueryMetrics::getQueryId));
            List queryHistories = this.queryHistoryDAO.getByQueryIds(queryIds);
            List idToQHInfoList = queryHistories.stream().map(hs -> {
                Optional<QueryHistoryInfo.QueryTraceSpan> maxQueryTraceSpan = ((List)metricsMap.get(hs.getQueryId())).stream().flatMap(qm -> qm.getQueryHistoryInfo().getTraces().stream()).filter(span -> "QUERY_RESPONSE_TIME".equals(span.getName())).max(Comparator.comparingLong(QueryHistoryInfo.QueryTraceSpan::getDuration));
                if (maxQueryTraceSpan.isPresent()) {
                    QueryHistoryInfo.QueryTraceSpan trace = maxQueryTraceSpan.get();
                    QueryHistoryInfo qhi = hs.getQueryHistoryInfo();
                    qhi.getTraces().add(trace);
                    return new Pair((Object)hs.getId(), (Object)qhi);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.queryHistoryDAO.batchUpdateQueryHistoriesInfo(idToQHInfoList);
        }
    }
}

