/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

public class PartitionsFilter
implements PathFilter,
Configurable,
Serializable {
    public static final String PARTITION_COL = "partition_col";
    public static final String PARTITIONS = "partitions";
    private Set<String> partitions = Sets.newHashSet();

    public boolean accept(Path path) {
        return this.partitions.contains(path.getParent().getName());
    }

    private Set<String> toPartitions(String colName, String conf) {
        LinkedHashSet<String> partitionNames = new LinkedHashSet<String>();
        for (String id : conf.split(",")) {
            partitionNames.add(colName + "=" + id);
        }
        return partitionNames;
    }

    public Configuration getConf() {
        return null;
    }

    public void setConf(Configuration conf) {
        String colName = conf.get(PARTITION_COL);
        this.partitions = this.toPartitions(colName, conf.get(PARTITIONS));
    }
}

