/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.engine.spark.utils.StorageUtils$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class SparkPrometheusMetrics$
implements Logging {
    public static SparkPrometheusMetrics$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkPrometheusMetrics$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String fetchExecutorMetricsInfo(String applicationId) {
        YarnConfiguration yarnConfiguration = StorageUtils$.MODULE$.getCurrentYarnConfiguration();
        return this.getMetricsByUrlsWithHa((Iterable<String>)((Iterable)this.getSocketAddress(yarnConfiguration).map((Function1 & Serializable & scala.Serializable)address -> MODULE$.getExecutorsUrl((String)address._1(), address._2$mcI$sp(), applicationId, YarnConfiguration.useHttps((Configuration)yarnConfiguration)), Iterable$.MODULE$.canBuildFrom())));
    }

    public String fetchDriverMetricsInfo(String applicationId) {
        YarnConfiguration yarnConfiguration = StorageUtils$.MODULE$.getCurrentYarnConfiguration();
        return this.getMetricsByUrlsWithHa((Iterable<String>)((Iterable)this.getSocketAddress(yarnConfiguration).map((Function1 & Serializable & scala.Serializable)address -> MODULE$.getDriverUrl((String)address._1(), address._2$mcI$sp(), applicationId, YarnConfiguration.useHttps((Configuration)yarnConfiguration)), Iterable$.MODULE$.canBuildFrom())));
    }

    public String getExecutorsUrl(String hostName, int port, String appId, boolean useHttps) {
        return useHttps ? new StringBuilder(45).append("https://").append(hostName).append(":").append(port).append("/proxy/").append(appId).append("/metrics/executors/prometheus").toString() : new StringBuilder(44).append("http://").append(hostName).append(":").append(port).append("/proxy/").append(appId).append("/metrics/executors/prometheus").toString();
    }

    public String getDriverUrl(String hostName, int port, String appId, boolean useHttps) {
        return useHttps ? new StringBuilder(35).append("https://").append(hostName).append(":").append(port).append("/proxy/").append(appId).append("/metrics/prometheus").toString() : new StringBuilder(34).append("http://").append(hostName).append(":").append(port).append("/proxy/").append(appId).append("/metrics/prometheus").toString();
    }

    private String getMetricsByUrlsWithHa(Iterable<String> urls) {
        String string;
        Object object = new Object();
        try {
            urls.foreach((Function1 & Serializable & scala.Serializable)url -> {
                SparkPrometheusMetrics$.$anonfun$getMetricsByUrlsWithHa$1(object, url);
                return BoxedUnit.UNIT;
            });
            string = "";
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    public Map<String, Object> getSocketAddress(YarnConfiguration conf) {
        InetSocketAddress[] inetSocketAddressArray;
        boolean useHttps = YarnConfiguration.useHttps((Configuration)conf);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            Object[] haIds = HAUtil.getRMHAIds((Configuration)conf).toArray();
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(haIds)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Ha ids is empty, please check your yarn-site.xml.");
            inetSocketAddressArray = useHttps ? (InetSocketAddress[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(haIds)).map((Function1 & Serializable & scala.Serializable)id -> conf.getSocketAddr(new StringBuilder(42).append("yarn.resourcemanager.webapp.https.address").append(".").append(id).toString(), "0.0.0.0:8090", 8044), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class))) : (InetSocketAddress[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(haIds)).map((Function1 & Serializable & scala.Serializable)id -> conf.getSocketAddr(new StringBuilder(36).append("yarn.resourcemanager.webapp.address").append(".").append(id).toString(), "0.0.0.0:8088", 8042), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class)));
        } else {
            inetSocketAddressArray = useHttps ? (InetSocketAddress[])((Object[])new InetSocketAddress[]{conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8044)}) : (InetSocketAddress[])((Object[])new InetSocketAddress[]{conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8042)});
        }
        InetSocketAddress[] addresses = inetSocketAddressArray;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addresses)).map((Function1 & Serializable & scala.Serializable)address -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)address.getHostName()), (Object)BoxesRunTime.boxToInteger((int)address.getPort())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public String getResponse(String url, int timeout) {
        String string;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(url);
            httpGet.setConfig(RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(new StringBuilder(52).append("spark3 prometheus metrics request ").append(url).append(" fail, response : ").append(EntityUtils.toString((HttpEntity)response.getEntity())).toString());
            }
            string = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return string;
    }

    public String getResponse(String url) {
        return this.getResponse(url, 5000);
    }

    public static final /* synthetic */ void $anonfun$getMetricsByUrlsWithHa$1(Object nonLocalReturnKey1$1, String url) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)MODULE$.getResponse(url));
        }
        catch (Exception ex) {
            MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ex.getMessage(), ex);
            return;
        }
    }

    private SparkPrometheusMetrics$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

