/*
 * Decompiled with CFR 0.152.
 */
package util.retry.blocking;

import scala.Function0;
import scala.Serializable;
import scala.concurrent.duration.FiniteDuration;
import util.retry.blocking.FibonacciBackOffStrategy;
import util.retry.blocking.FixedWaitRetryStrategy;
import util.retry.blocking.MaxNumberOfRetriesStrategy;
import util.retry.blocking.NoRetry$;
import util.retry.blocking.RandomWaitRetryStrategy;
import util.retry.blocking.RetryForever;
import util.retry.blocking.RetryStrategy;

public final class RetryStrategy$ {
    public static RetryStrategy$ MODULE$;
    private final Function0<RetryStrategy> noRetry;

    static {
        new RetryStrategy$();
    }

    public Function0<RetryStrategy> noRetry() {
        return this.noRetry;
    }

    public Function0<RetryStrategy> noBackOff(int maxAttempts) {
        return (Function0 & java.io.Serializable & Serializable)() -> new MaxNumberOfRetriesStrategy(maxAttempts);
    }

    public Function0<RetryStrategy> forever(int waitTime) {
        return (Function0 & java.io.Serializable & Serializable)() -> new RetryForever(waitTime);
    }

    public Function0<RetryStrategy> fixedBackOff(FiniteDuration retryDuration, int maxAttempts) {
        return (Function0 & java.io.Serializable & Serializable)() -> new FixedWaitRetryStrategy(retryDuration.toMillis(), maxAttempts);
    }

    public Function0<RetryStrategy> randomBackOff(FiniteDuration minimumWaitDuration, FiniteDuration maximumWaitDuration, int maxAttempts) {
        return (Function0 & java.io.Serializable & Serializable)() -> new RandomWaitRetryStrategy(minimumWaitDuration.toMillis(), maximumWaitDuration.toMillis(), maxAttempts);
    }

    public Function0<RetryStrategy> fibonacciBackOff(FiniteDuration initialWaitDuration, int maxAttempts) {
        return (Function0 & java.io.Serializable & Serializable)() -> new FibonacciBackOffStrategy(initialWaitDuration.toMillis(), 1L, maxAttempts);
    }

    private RetryStrategy$() {
        MODULE$ = this;
        this.noRetry = (Function0 & java.io.Serializable & Serializable)() -> NoRetry$.MODULE$;
    }
}

