/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AclTCRRequest;
import org.apache.kylin.rest.response.AclTCRResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/acl"}, produces={"application/vnd.apache.kylin-v4+json"})
public class AclTCRController
extends NBasicController {
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRService aclTCRService;
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;

    @ApiOperation(value="getProjectSidTCR", tags={"MID"}, notes="Update URL: {project}; Update Param: project, authorized_only")
    @GetMapping(value={"/sid/{sid_type:.+}/{sid:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<List<AclTCRResponse>> getProjectSidTCR(@PathVariable(value="sid_type") String sidType, @PathVariable(value="sid") String sid, @RequestParam(value="project") String project, @RequestParam(value="authorized_only", required=false, defaultValue="false") boolean authorizedOnly) throws IOException {
        List<AclTCRResponse> result;
        this.checkProjectName(project);
        if (sidType.equalsIgnoreCase("user")) {
            sid = this.makeUserNameCaseInSentive(sid);
            result = this.getProjectSidTCR(project, sid, true, authorizedOnly);
        } else if (sidType.equalsIgnoreCase("group")) {
            result = this.getProjectSidTCR(project, sid, false, authorizedOnly);
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidSidType());
        }
        result.stream().forEach(resp -> Optional.ofNullable(resp.getTables()).orElse(Lists.newArrayList()).stream().forEach(table -> table.setRowFilter(null)));
        return new EnvelopeResponse("000", result, "");
    }

    @ApiOperation(value="getProjectSidTCR", tags={"MID"}, notes="Update URL: {project}; Update Param: project, authorized_only")
    @GetMapping(value={"/{sid_type:.+}/{sid:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<List<AclTCRResponse>> getProjectSidTCRV2(@PathVariable(value="sid_type") String sidType, @PathVariable(value="sid") String sid, @RequestParam(value="project") String project, @RequestParam(value="authorized_only", required=false, defaultValue="false") boolean authorizedOnly) throws IOException {
        List<AclTCRResponse> result;
        this.checkProjectName(project);
        if (sidType.equalsIgnoreCase("user")) {
            sid = this.makeUserNameCaseInSentive(sid);
            result = this.getProjectSidTCR(project, sid, true, authorizedOnly);
        } else if (sidType.equalsIgnoreCase("group")) {
            result = this.getProjectSidTCR(project, sid, false, authorizedOnly);
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidSidType());
        }
        result.stream().forEach(resp -> Optional.ofNullable(resp.getTables()).orElse(Lists.newArrayList()).stream().forEach(table -> {
            table.setRows(null);
            table.setLikeRows(null);
        }));
        return new EnvelopeResponse("000", result, "");
    }

    @ApiOperation(value="updateProject", tags={"MID"}, notes="Update URL: {project}")
    @PutMapping(value={"/sid/{sid_type:.+}/{sid:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> updateProject(@PathVariable(value="sid_type") String sidType, @PathVariable(value="sid") String sid, @RequestParam(value="project") String project, @RequestBody List<AclTCRRequest> requests) throws IOException {
        this.checkProjectName(project);
        AclPermissionUtil.checkAclUpdatable((String)project, (Set)this.aclTCRService.getCurrentUserGroups());
        requests.stream().forEach(request -> Optional.ofNullable(request.getTables()).orElse(Lists.newArrayList()).stream().forEach(table -> table.setRowFilter(null)));
        if (sidType.equalsIgnoreCase("user")) {
            sid = this.makeUserNameCaseInSentive(sid);
            this.updateSidAclTCR(project, sid, true, requests);
        } else if (sidType.equalsIgnoreCase("group")) {
            this.updateSidAclTCR(project, sid, false, requests);
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidSidType());
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @GetMapping(value={"/updatable"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Boolean> getAllowAclUpdatable(@RequestParam(value="project") String project) throws IOException {
        return new EnvelopeResponse("000", (Object)AclPermissionUtil.isAclUpdatable((String)project, (Set)this.aclTCRService.getCurrentUserGroups()), "");
    }

    private List<AclTCRResponse> getProjectSidTCR(String project, String sid, boolean principal, boolean authorizedOnly) throws IOException {
        this.accessService.checkSid(sid, principal);
        return this.aclTCRService.getAclTCRResponse(project, sid, principal, authorizedOnly);
    }

    private void updateSidAclTCR(String project, String sid, boolean principal, List<AclTCRRequest> requests) throws IOException {
        this.accessService.checkSid(sid, principal);
        boolean hasProjectPermission = this.accessService.hasProjectPermission(project, sid, principal);
        if (!hasProjectPermission) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, String.format(Locale.ROOT, msg.getGrantTableWithSidHasNotProjectPermission(), sid, project));
        }
        this.aclTCRService.updateAclTCR(project, sid, principal, requests);
    }
}

