/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.query.blacklist.SQLBlacklist;
import org.apache.kylin.query.blacklist.SQLBlacklistItem;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.SQLBlacklistItemRequest;
import org.apache.kylin.rest.request.SQLBlacklistRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.QuerySQLBlacklistService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/query_sql_blacklist"}, produces={"application/vnd.apache.kylin-v2+json", "application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class QuerySQLBlacklistController
extends NBasicController {
    @Autowired
    @Qualifier(value="querySQLBlacklistService")
    private QuerySQLBlacklistService querySQLBlacklistService;

    @ApiOperation(value="getSqlBlacklist", tags={"QE"})
    @GetMapping(value={"/{project}"})
    @ResponseBody
    public EnvelopeResponse getSqlBlacklist(@PathVariable(value="project") String project) {
        Message msg = Message.getInstance();
        if (null == project) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_PROJECT_EMPTY, msg.getSqlBlacklistItemProjectEmpty());
        }
        SQLBlacklist sqlBlacklist = this.querySQLBlacklistService.getSqlBlacklist(project);
        return new EnvelopeResponse("000", (Object)sqlBlacklist, "");
    }

    @ApiOperation(value="overwrite", tags={"QE"})
    @PostMapping(value={"/overwrite"})
    @ResponseBody
    public EnvelopeResponse<SQLBlacklist> overwrite(@RequestBody SQLBlacklistRequest sqlBlacklistRequest) throws IOException {
        Message msg = Message.getInstance();
        if (null == sqlBlacklistRequest.getProject()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_PROJECT_EMPTY, msg.getSqlBlacklistItemProjectEmpty());
        }
        this.validateSqlBlacklist(sqlBlacklistRequest.getBlacklistItems());
        SQLBlacklist sqlBlacklist = this.querySQLBlacklistService.saveSqlBlacklist(sqlBlacklistRequest);
        return new EnvelopeResponse("000", (Object)sqlBlacklist, "");
    }

    private void validateSqlBlacklist(List<SQLBlacklistItemRequest> sqlBlacklistItemRequests) {
        Message msg = Message.getInstance();
        HashSet regexSet = Sets.newHashSet();
        HashSet sqlSet = Sets.newHashSet();
        for (SQLBlacklistItemRequest item : sqlBlacklistItemRequests) {
            if (null == item.getRegex() && null == item.getSql()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_REGEX_AND_SQL_EMPTY, msg.getSqlBlacklistItemRegexAndSqlEmpty());
            }
            String regex = item.getRegex();
            if (null != regex && regexSet.contains(regex)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_REGEX_EXISTS, msg.getSqlBlacklistItemRegexExists());
            }
            String sql = item.getSql();
            if (null != sql && sqlSet.contains(sql)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_SQL_EXISTS, msg.getSqlBlacklistItemSqlExists());
            }
            if (null != regex) {
                regexSet.add(item.getRegex());
            }
            if (null == sql) continue;
            sqlSet.add(item.getSql());
        }
    }

    @ApiOperation(value="add_item", tags={"QE"})
    @PostMapping(value={"/add_item/{project}"})
    @ResponseBody
    public EnvelopeResponse<SQLBlacklist> addItem(@PathVariable(value="project") String project, @RequestBody SQLBlacklistItemRequest sqlBlacklistItemRequest) throws IOException {
        Message msg = Message.getInstance();
        if (null == sqlBlacklistItemRequest.getRegex() && null == sqlBlacklistItemRequest.getSql()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_REGEX_AND_SQL_EMPTY, msg.getSqlBlacklistItemRegexAndSqlEmpty());
        }
        if (null == project) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_PROJECT_EMPTY, msg.getSqlBlacklistItemProjectEmpty());
        }
        SQLBlacklistItem sqlBlacklistItemOfRegex = this.querySQLBlacklistService.getItemByRegex(project, sqlBlacklistItemRequest);
        if (null != sqlBlacklistItemOfRegex) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_REGEX_EMPTY, String.format(Locale.ROOT, msg.getSqlBlacklistItemRegexExists(), sqlBlacklistItemOfRegex.getId()));
        }
        SQLBlacklistItem sqlBlacklistItemOfSql = this.querySQLBlacklistService.getItemBySql(project, sqlBlacklistItemRequest);
        if (null != sqlBlacklistItemOfSql) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_SQL_EXISTS, String.format(Locale.ROOT, msg.getSqlBlacklistItemSqlExists(), sqlBlacklistItemOfSql.getId()));
        }
        SQLBlacklist sqlBlacklist = this.querySQLBlacklistService.addSqlBlacklistItem(project, sqlBlacklistItemRequest);
        return new EnvelopeResponse("000", (Object)sqlBlacklist, "");
    }

    @ApiOperation(value="update_item", tags={"QE"})
    @PostMapping(value={"/update_item/{project}"})
    @ResponseBody
    public EnvelopeResponse<SQLBlacklist> updateItem(@PathVariable(value="project") String project, @RequestBody SQLBlacklistItemRequest sqlBlacklistItemRequest) throws IOException {
        Message msg = Message.getInstance();
        if (null == sqlBlacklistItemRequest.getId()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_ITEM_ID_EMPTY, msg.getSqlBlacklistItemIdEmpty());
        }
        if (null == sqlBlacklistItemRequest.getRegex() && null == sqlBlacklistItemRequest.getSql()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_REGEX_AND_SQL_EMPTY, msg.getSqlBlacklistItemRegexAndSqlEmpty());
        }
        if (null == project) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_PROJECT_EMPTY, msg.getSqlBlacklistItemProjectEmpty());
        }
        if (null == this.querySQLBlacklistService.getItemById(project, sqlBlacklistItemRequest)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_ITEM_ID_EMPTY, msg.getSqlBlacklistItemIdNotExists());
        }
        SQLBlacklistItem conflictRegexItem = this.querySQLBlacklistService.checkConflictRegex(project, sqlBlacklistItemRequest);
        if (null != conflictRegexItem) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_REGEX_EMPTY, String.format(Locale.ROOT, msg.getSqlBlacklistItemRegexExists(), conflictRegexItem.getId()));
        }
        SQLBlacklistItem conflictSqlItem = this.querySQLBlacklistService.checkConflictSql(project, sqlBlacklistItemRequest);
        if (null != conflictSqlItem) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_SQL_EXISTS, String.format(Locale.ROOT, msg.getSqlBlacklistItemSqlExists(), conflictSqlItem.getId()));
        }
        SQLBlacklist sqlBlacklist = this.querySQLBlacklistService.updateSqlBlacklistItem(project, sqlBlacklistItemRequest);
        return new EnvelopeResponse("000", (Object)sqlBlacklist, "");
    }

    @ApiOperation(value="delete_item", tags={"QE"})
    @DeleteMapping(value={"/delete_item/{project}/{id}"})
    @ResponseBody
    public EnvelopeResponse<SQLBlacklist> deleteItem(@PathVariable(value="project") String project, @PathVariable(value="id") String id) throws IOException {
        Message msg = Message.getInstance();
        if (null == project) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_PROJECT_EMPTY, msg.getSqlBlacklistItemProjectEmpty());
        }
        if (null == id) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BLACKLIST_ITEM_ID_EMPTY, msg.getSqlBlacklistItemIdToDeleteEmpty());
        }
        SQLBlacklist sqlBlacklist = this.querySQLBlacklistService.deleteSqlBlacklistItem(project, id);
        return new EnvelopeResponse("000", (Object)sqlBlacklist, "");
    }

    @ApiOperation(value="clearBlacklist", tags={"QE"})
    @DeleteMapping(value={"/clear/{project}"})
    @ResponseBody
    public EnvelopeResponse<SQLBlacklist> clearBlacklist(@PathVariable String project) throws IOException {
        SQLBlacklist sqlBlacklist = this.querySQLBlacklistService.clearSqlBlacklist(project);
        return new EnvelopeResponse("000", (Object)sqlBlacklist, "");
    }
}

