/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.context.FacesContext;
import java.io.InputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.util.lang.ConcurrentLRUCache;

public abstract class ResourceLoader {
    public static final String VERSION_INVALID = "INVALID";
    private String prefix;
    private boolean resourceCacheEnabled;
    private ConcurrentLRUCache<Object, Boolean> resourceExistsCache;
    private Comparator<String> _versionComparator = null;

    public ResourceLoader(String prefix) {
        this.prefix = prefix;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(facesContext);
        this.resourceCacheEnabled = myfacesConfig.isResourceHandlerCacheEnabled();
        if (this.resourceCacheEnabled) {
            int maxSize = myfacesConfig.getResourceHandlerCacheSize();
            this.resourceExistsCache = new ConcurrentLRUCache(maxSize * 2, maxSize);
        }
    }

    public abstract String getResourceVersion(String var1);

    public abstract String getLibraryVersion(String var1);

    public abstract URL getResourceURL(ResourceMeta var1);

    public abstract InputStream getResourceInputStream(ResourceMeta var1);

    public abstract ResourceMeta createResourceMeta(String var1, String var2, String var3, String var4, String var5);

    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String contractName) {
        return this.createResourceMeta(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    public abstract boolean libraryExists(String var1);

    public boolean resourceExists(ResourceMeta resourceMeta) {
        if (resourceMeta == null) {
            return false;
        }
        if (this.resourceCacheEnabled) {
            Boolean exists = this.resourceExistsCache.get(resourceMeta);
            if (exists == null && !(exists = Boolean.valueOf(this.getResourceURL(resourceMeta) != null)).booleanValue()) {
                this.resourceExistsCache.put(resourceMeta, exists);
            }
            return exists;
        }
        return this.getResourceURL(resourceMeta) != null;
    }

    public Iterator<String> iterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        return null;
    }

    protected Comparator<String> getVersionComparator() {
        if (this._versionComparator == null) {
            this._versionComparator = new VersionComparator();
        }
        return this._versionComparator;
    }

    protected void setVersionComparator(Comparator<String> versionComparator) {
        this._versionComparator = versionComparator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public static class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            int n1 = 0;
            int n2 = 0;
            String o1 = s1;
            String o2 = s2;
            boolean p1 = true;
            boolean p2 = true;
            while (n1 == n2 && (p1 || p2)) {
                int i1 = o1.indexOf(95);
                int i2 = o2.indexOf(95);
                if (i1 < 0) {
                    if (o1.length() > 0) {
                        p1 = false;
                        n1 = Integer.parseInt(o1);
                        o1 = "";
                    } else {
                        p1 = false;
                        n1 = 0;
                    }
                } else {
                    n1 = Integer.valueOf(o1.substring(0, i1));
                    o1 = o1.substring(i1 + 1);
                }
                if (i2 < 0) {
                    if (o2.length() > 0) {
                        p2 = false;
                        n2 = Integer.valueOf(o2);
                        o2 = "";
                        continue;
                    }
                    p2 = false;
                    n2 = 0;
                    continue;
                }
                n2 = Integer.valueOf(o2.substring(0, i2));
                o2 = o2.substring(i2 + 1);
            }
            if (n1 == n2) {
                return s1.length() - s2.length();
            }
            return n1 - n2;
        }
    }
}

