/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.doctree.DocCommentTree;
import jpt.sun.source.doctree.DocTree;
import jpt.sun.source.doctree.SinceTree;
import jpt.sun.source.tree.AnnotationTree;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.CatchTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.CompoundAssignmentTree;
import jpt.sun.source.tree.DoWhileLoopTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.LambdaExpressionTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.NewArrayTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.ParameterizedTypeTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.SwitchTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TryTree;
import jpt.sun.source.tree.TypeParameterTree;
import jpt.sun.source.tree.UnaryTree;
import jpt.sun.source.tree.UnionTypeTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.tree.WhileLoopTree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.TreePathScanner;
import jpt.sun.source.util.TreeScanner;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.ipi.upgrade.ProjectDependencyUpgrader;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.hints.Bundle;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;

public class JavaFixUtilities {
    private static final java.util.regex.Pattern SPEC_VERSION = java.util.regex.Pattern.compile("[0-9]+(\\.[0-9]+)+");
    private static final Set<Tree.Kind> NUMBER_LITERAL_KINDS = EnumSet.of(Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL);
    private static final Map<Tree.Kind, Integer> OPERATOR_PRIORITIES = new EnumMap<Tree.Kind, Integer>(Tree.Kind.class);

    public static Fix rewriteFix(HintContext ctx, String displayName, TreePath what, String to) {
        return JavaFixUtilities.rewriteFix(ctx.getInfo(), displayName, what, to, ctx.getVariables(), ctx.getMultiVariables(), ctx.getVariableNames(), ctx.getConstraints(), Collections.emptyMap(), new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    static Fix rewriteFix(CompilationInfo info, String displayName, TreePath what, final String to, final Map<String, TreePath> parameters, final Map<String, Collection<? extends TreePath>> parametersMulti, Map<String, String> parameterNames, Map<String, TypeMirror> constraints, Map<String, String> options, String ... imports) {
        void var15_21;
        HashMap<String, TreePathHandle> params = new HashMap<String, TreePathHandle>();
        HashMap<String, Object> extraParamsData = new HashMap<String, Object>();
        HashMap implicitThis = new HashMap();
        for (Map.Entry<String, TreePath> e : parameters.entrySet()) {
            Element element;
            TreePath treePath = e.getValue();
            if (treePath.getParentPath() != null && !JavaFixUtilities.immediateChildren(treePath.getParentPath().getLeaf()).contains(treePath.getLeaf()) && (element = info.getTrees().getElement(treePath)) != null && element.getSimpleName().contentEquals("this")) {
                implicitThis.put((String)e.getKey(), ElementHandle.create(element.getEnclosingElement()));
                continue;
            }
            params.put((String)e.getKey(), TreePathHandle.create((TreePath)e.getValue(), info));
            Iterator<Object> iterator = e.getValue();
            if (!(iterator instanceof Callable)) continue;
            Callable callable = (Callable)((Object)iterator);
            try {
                extraParamsData.put((String)e.getKey(), callable.call());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        HashMap<String, Collection<TreePathHandle>> paramsMulti = new HashMap<String, Collection<TreePathHandle>>();
        for (Map.Entry entry : parametersMulti.entrySet()) {
            LinkedList<TreePathHandle> linkedList = new LinkedList<TreePathHandle>();
            for (TreePath tp : (Collection)entry.getValue()) {
                TreePathHandle x = TreePathHandle.create(tp, info);
                if (x.resolve(info) == null) continue;
                linkedList.add(x);
            }
            paramsMulti.put((String)entry.getKey(), linkedList);
        }
        HashMap constraintsHandles = new HashMap();
        for (Map.Entry<String, TypeMirror> entry : constraints.entrySet()) {
            constraintsHandles.put(entry.getKey(), TypeMirrorHandle.create(entry.getValue()));
        }
        if (displayName == null) {
            Supplier<String> supplier = new Supplier<String>(){
                private String dn = null;

                @Override
                public String get() {
                    if (this.dn == null) {
                        this.dn = JavaFixUtilities.defaultFixDisplayName(parameters, parametersMulti, to);
                    }
                    return this.dn;
                }
            };
        } else {
            Supplier<String> supplier = () -> displayName;
        }
        return new JavaFixRealImpl(info, what, options, (Supplier<String>)var15_21, to, params, extraParamsData, implicitThis, paramsMulti, parameterNames, constraintsHandles, Arrays.asList(imports)).toEditorFix();
    }

    private static Set<Tree> immediateChildren(Tree t) {
        final HashSet<Tree> children = new HashSet<Tree>();
        t.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void p) {
                if (tree != null) {
                    children.add(tree);
                }
                return null;
            }
        }, null);
        return children;
    }

    public static Fix removeFromParent(HintContext ctx, String displayName, TreePath what) {
        return new RemoveFromParent(displayName, ctx.getInfo(), what, false).toEditorFix();
    }

    public static Fix safelyRemoveFromParent(HintContext ctx, String displayName, TreePath what) {
        return RemoveFromParent.canSafelyRemove(ctx.getInfo(), what) ? new RemoveFromParent(displayName, ctx.getInfo(), what, true).toEditorFix() : null;
    }

    private static String defaultFixDisplayName(Map<String, TreePath> variables, Map<String, Collection<? extends TreePath>> parametersMulti, String replaceTarget) {
        LinkedHashMap<Object, String> stringsForVariables = new LinkedHashMap<Object, String>();
        for (Map.Entry<String, Collection<? extends TreePath>> entry : parametersMulti.entrySet()) {
            if (entry.getKey().startsWith("$$")) continue;
            if (entry.getValue().isEmpty()) {
                stringsForVariables.put(entry.getKey() + ";", "");
                stringsForVariables.put(", " + entry.getKey(), "");
                stringsForVariables.put(entry.getKey(), "");
                continue;
            }
            if (entry.getValue().size() == 1) {
                String text = JavaFixUtilities.treePathToString(entry.getValue().iterator().next(), false, entry.getKey());
                stringsForVariables.put(entry.getKey(), text);
                continue;
            }
            stringsForVariables.put(entry.getKey(), entry.getKey().replace("$", "\u2666"));
        }
        variables.entrySet().stream().sorted((e1, e2) -> ((String)e2.getKey()).length() - ((String)e1.getKey()).length()).forEach(e -> stringsForVariables.put((String)e.getKey(), JavaFixUtilities.treePathToString((TreePath)e.getValue(), true, (String)e.getKey())));
        if (!stringsForVariables.containsKey("$this")) {
            stringsForVariables.put("$this", "this");
        }
        for (Map.Entry<String, Collection<TreePath>> entry : stringsForVariables.entrySet()) {
            replaceTarget = replaceTarget.replace(entry.getKey(), (CharSequence)((Object)entry.getValue()));
        }
        return "Rewrite to " + replaceTarget.replace("\u2666", "$").replace(";;", ";").replace("\n", " ").replaceAll("\\s{2,}", " ").replace("<", "&lt;");
    }

    private static String treePathToString(TreePath tp, boolean preferVarName, String fallback) {
        Tree leaf = tp.getLeaf();
        if (preferVarName && leaf.getKind() == Tree.Kind.VARIABLE) {
            return ((VariableTree)leaf).getName().toString();
        }
        String str = leaf.toString();
        return str.equals("(ERROR)") ? fallback : str;
    }

    private static void checkDependency(CompilationInfo copy, Element e, boolean canShowUI) {
        SpecificationVersion sv = JavaFixUtilities.computeSpecVersion(copy, e);
        while (sv == null && e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
            sv = JavaFixUtilities.computeSpecVersion(copy, e);
        }
        if (sv == null) {
            return;
        }
        Project currentProject = FileOwnerQuery.getOwner(copy.getFileObject());
        if (currentProject == null) {
            return;
        }
        FileObject file = JavaFixUtilities.getFile(copy, e);
        if (file == null) {
            return;
        }
        FileObject root = JavaFixUtilities.findRootForFile(file, copy.getClasspathInfo());
        if (root == null) {
            return;
        }
        Project referedProject = FileOwnerQuery.getOwner(file);
        if (referedProject != null && currentProject.getProjectDirectory().equals(referedProject.getProjectDirectory())) {
            return;
        }
        for (ProjectDependencyUpgrader pdu : Lookup.getDefault().lookupAll(ProjectDependencyUpgrader.class)) {
            if (!pdu.ensureDependency(currentProject, root, sv, canShowUI)) continue;
            return;
        }
    }

    static SpecificationVersion computeSpecVersion(CompilationInfo info, Element el) {
        if (!Utilities.isJavadocSupported(info)) {
            return null;
        }
        DocCommentTree javaDoc = info.getDocTrees().getDocCommentTree(el);
        if (javaDoc == null) {
            return null;
        }
        for (DocTree docTree : javaDoc.getBlockTags()) {
            String text;
            java.util.regex.Matcher m;
            if (docTree.getKind() != DocTree.Kind.SINCE || !(m = SPEC_VERSION.matcher(text = ((SinceTree)docTree).getBody().toString())).find()) continue;
            return new SpecificationVersion(m.group());
        }
        return null;
    }

    private static FileObject getFile(CompilationInfo copy, Element e) {
        return SourceUtils.getFile(e, copy.getClasspathInfo());
    }

    private static FileObject findRootForFile(FileObject file, ClasspathInfo cpInfo) {
        ClassPath cp = ClassPathSupport.createProxyClassPath(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE));
        FileObject root = cp.findOwnerRoot(file);
        if (root != null) {
            return root;
        }
        for (ClassPath.Entry e : cp.entries()) {
            ClassPath sourcePath;
            FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots(e.getURL()).getRoots();
            if (sourceRoots.length == 0 || (root = (sourcePath = ClassPathSupport.createClassPath(sourceRoots)).findOwnerRoot(file)) == null) continue;
            return root;
        }
        return null;
    }

    private static boolean isStaticElement(Element el) {
        if (el == null) {
            return false;
        }
        if (el.asType() == null || el.asType().getKind() == TypeKind.ERROR) {
            return false;
        }
        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
            return el.getKind().isClass() || el.getKind().isInterface();
        }
        if (el.getKind().isClass() || el.getKind().isInterface()) {
            return el.getEnclosingElement().getKind() == ElementKind.PACKAGE;
        }
        return false;
    }

    public static boolean isPrimary(@NonNull Tree tree) {
        Integer treePriority = OPERATOR_PRIORITIES.get((Object)tree.getKind());
        return treePriority != null && treePriority <= 1;
    }

    public static boolean requiresParenthesis(Tree inner, Tree original, Tree outter) {
        if (!ExpressionTree.class.isAssignableFrom(inner.getKind().asInterface()) || outter == null) {
            return false;
        }
        if (!ExpressionTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            boolean condition = switch (outter.getKind()) {
                case Tree.Kind.IF -> {
                    if (original == ((IfTree)outter).getCondition()) {
                        yield true;
                    }
                    yield false;
                }
                case Tree.Kind.WHILE_LOOP -> {
                    if (original == ((WhileLoopTree)outter).getCondition()) {
                        yield true;
                    }
                    yield false;
                }
                case Tree.Kind.DO_WHILE_LOOP -> {
                    if (original == ((DoWhileLoopTree)outter).getCondition()) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
            return condition && inner.getKind() != Tree.Kind.PARENTHESIZED;
        }
        if (outter.getKind() == Tree.Kind.PARENTHESIZED || inner.getKind() == Tree.Kind.PARENTHESIZED) {
            return false;
        }
        if (outter.getKind() == Tree.Kind.METHOD_INVOCATION && ((MethodInvocationTree)outter).getArguments().contains(original)) {
            return false;
        }
        if (outter.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            LambdaExpressionTree lt = (LambdaExpressionTree)outter;
            if (lt.getParameters().contains(original)) {
                return false;
            }
            if (lt.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT) {
                return false;
            }
            return original.getKind() == Tree.Kind.PARENTHESIZED;
        }
        if (outter.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)outter).getArguments().contains(original)) {
            return false;
        }
        Integer innerPriority = OPERATOR_PRIORITIES.get((Object)inner.getKind());
        Integer outterPriority = OPERATOR_PRIORITIES.get((Object)outter.getKind());
        if (innerPriority == null || outterPriority == null) {
            Logger.getLogger(JavaFix.class.getName()).log(Level.WARNING, "Unknown tree kind(s): {0}/{1}", new Object[]{inner.getKind(), outter.getKind()});
            return true;
        }
        if (innerPriority > outterPriority) {
            return true;
        }
        if (innerPriority < outterPriority) {
            return false;
        }
        if (BinaryTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            BinaryTree ot = (BinaryTree)outter;
            return ot.getRightOperand() == original;
        }
        if (CompoundAssignmentTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            CompoundAssignmentTree ot = (CompoundAssignmentTree)outter;
            return ot.getVariable() == original;
        }
        if (AssignmentTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            AssignmentTree ot = (AssignmentTree)outter;
            return ot.getVariable() == original;
        }
        return false;
    }

    static {
        OPERATOR_PRIORITIES.put(Tree.Kind.IDENTIFIER, 0);
        for (Tree.Kind k : Tree.Kind.values()) {
            if (k.asInterface() != LiteralTree.class) continue;
            OPERATOR_PRIORITIES.put(k, 0);
        }
        OPERATOR_PRIORITIES.put(Tree.Kind.ARRAY_ACCESS, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.METHOD_INVOCATION, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.MEMBER_REFERENCE, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.MEMBER_SELECT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.POSTFIX_DECREMENT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.POSTFIX_INCREMENT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.NEW_ARRAY, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.NEW_CLASS, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.BITWISE_COMPLEMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.LOGICAL_COMPLEMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.PREFIX_DECREMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.PREFIX_INCREMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNARY_MINUS, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNARY_PLUS, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.TYPE_CAST, 3);
        OPERATOR_PRIORITIES.put(Tree.Kind.DIVIDE, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.MULTIPLY, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.REMAINDER, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.MINUS, 5);
        OPERATOR_PRIORITIES.put(Tree.Kind.PLUS, 5);
        OPERATOR_PRIORITIES.put(Tree.Kind.LEFT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.RIGHT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.INSTANCE_OF, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.GREATER_THAN, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.GREATER_THAN_EQUAL, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.LESS_THAN, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.LESS_THAN_EQUAL, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.EQUAL_TO, 8);
        OPERATOR_PRIORITIES.put(Tree.Kind.NOT_EQUAL_TO, 8);
        OPERATOR_PRIORITIES.put(Tree.Kind.AND, 9);
        OPERATOR_PRIORITIES.put(Tree.Kind.OR, 11);
        OPERATOR_PRIORITIES.put(Tree.Kind.XOR, 10);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_AND, 12);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_OR, 13);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_EXPRESSION, 14);
        OPERATOR_PRIORITIES.put(Tree.Kind.AND_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.DIVIDE_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.MINUS_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.MULTIPLY_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.OR_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.PLUS_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.REMAINDER_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.XOR_ASSIGNMENT, 15);
    }

    private static class JavaFixRealImpl
    extends JavaFix {
        private final Supplier<String> displayName;
        private final Map<String, TreePathHandle> params;
        private final Map<String, Object> extraParamsData;
        private final Map<String, ElementHandle<?>> implicitThis;
        private final Map<String, Collection<TreePathHandle>> paramsMulti;
        private final Map<String, String> parameterNames;
        private final Map<String, TypeMirrorHandle<?>> constraintsHandles;
        private final Iterable<? extends String> imports;
        private final String to;

        public JavaFixRealImpl(CompilationInfo info, TreePath what, Map<String, String> options, Supplier<String> displayName, String to, Map<String, TreePathHandle> params, Map<String, Object> extraParamsData, Map<String, ElementHandle<?>> implicitThis, Map<String, Collection<TreePathHandle>> paramsMulti, Map<String, String> parameterNames, Map<String, TypeMirrorHandle<?>> constraintsHandles, Iterable<? extends String> imports) {
            super(info, what, options);
            this.displayName = displayName;
            this.to = to;
            this.params = params;
            this.extraParamsData = extraParamsData;
            this.implicitThis = implicitThis;
            this.paramsMulti = paramsMulti;
            this.parameterNames = parameterNames;
            this.constraintsHandles = constraintsHandles;
            this.imports = imports;
        }

        @Override
        protected String getText() {
            return this.displayName.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            void var10_25;
            Tree original;
            void var10_23;
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            GeneratorUtilities gen = GeneratorUtilities.get(wc);
            tp = new TreePath(tp.getParentPath(), gen.importComments(tp.getLeaf(), tp.getCompilationUnit()));
            HashMap<String, TreePath> parameters = new HashMap<String, TreePath>();
            for (Map.Entry<String, TreePathHandle> e : this.params.entrySet()) {
                TreePath treePath = e.getValue().resolve(wc);
                if (treePath == null) {
                    Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", e.getValue());
                }
                parameters.put((String)e.getKey(), treePath);
            }
            HashMap<String, Element> implicitThis = new HashMap<String, Element>();
            for (Map.Entry entry : this.implicitThis.entrySet()) {
                Object t = ((ElementHandle)entry.getValue()).resolve(wc);
                if (t == null) {
                    Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", entry.getValue());
                    continue;
                }
                implicitThis.put((String)entry.getKey(), (Element)t);
            }
            HashMap<String, Collection<TreePath>> parametersMulti = new HashMap<String, Collection<TreePath>>();
            for (Map.Entry<String, Collection<TreePathHandle>> entry : this.paramsMulti.entrySet()) {
                LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
                for (TreePathHandle tph : entry.getValue()) {
                    TreePath p = tph.resolve(wc);
                    if (p == null) {
                        Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", entry.getValue());
                        continue;
                    }
                    linkedList.add(p);
                }
                parametersMulti.put(entry.getKey(), linkedList);
            }
            HashMap<String, TypeMirror> hashMap = new HashMap<String, TypeMirror>();
            for (Map.Entry<String, TypeMirrorHandle<?>> entry : this.constraintsHandles.entrySet()) {
                hashMap.put(entry.getKey(), (TypeMirror)entry.getValue().resolve(wc));
            }
            Scope scope = Utilities.constructScope(wc, hashMap, this.imports);
            assert (scope != null);
            Tree tree = Utilities.parseAndAttribute(wc, this.to, scope);
            if (tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && ExpressionTree.class.isAssignableFrom(tp.getLeaf().getKind().asInterface())) {
                ExpressionTree expressionTree = ((ExpressionStatementTree)tree).getExpression();
            }
            IdentityHashMap<Tree, Tree> rewriteFromTo = new IdentityHashMap<Tree, Tree>();
            ArrayList<Tree> order = new ArrayList<Tree>(7);
            if (Utilities.isFakeBlock((Tree)var10_23)) {
                parent = tp.getParentPath();
                List<? extends StatementTree> statements = ((BlockTree)var10_23).getStatements();
                if (tp.getLeaf().getKind() == Tree.Kind.BLOCK) {
                    BlockTree real = (BlockTree)tp.getLeaf();
                    original = real;
                    rewriteFromTo.put(original, wc.getTreeMaker().Block(statements, real.isStatic()));
                } else {
                    statements = statements.subList(1, statements.size() - 1);
                    if (parent.getLeaf().getKind() == Tree.Kind.BLOCK) {
                        LinkedList<? extends StatementTree> newStatements = new LinkedList<StatementTree>();
                        for (StatementTree statementTree : ((BlockTree)parent.getLeaf()).getStatements()) {
                            if (statementTree == tp.getLeaf()) {
                                newStatements.addAll(statements);
                                continue;
                            }
                            newStatements.add(statementTree);
                        }
                        original = parent.getLeaf();
                        rewriteFromTo.put(original, wc.getTreeMaker().Block(newStatements, ((BlockTree)parent.getLeaf()).isStatic()));
                    } else {
                        original = tp.getLeaf();
                        rewriteFromTo.put(original, wc.getTreeMaker().Block(statements, false));
                    }
                }
            } else if (Utilities.isFakeClass((Tree)var10_23)) {
                parent = tp.getParentPath();
                List<? extends Tree> members = ((ClassTree)var10_23).getMembers();
                members = members.subList(1, members.size());
                assert (parent.getLeaf().getKind() == Tree.Kind.CLASS);
                LinkedList<? extends Tree> newMembers = new LinkedList<Tree>();
                ClassTree ct = (ClassTree)parent.getLeaf();
                for (Tree tree2 : ct.getMembers()) {
                    if (tree2 == tp.getLeaf()) {
                        newMembers.addAll(members);
                        continue;
                    }
                    newMembers.add(tree2);
                }
                original = parent.getLeaf();
                rewriteFromTo.put(original, wc.getTreeMaker().Class(ct.getModifiers(), ct.getSimpleName(), ct.getTypeParameters(), ct.getExtendsClause(), ct.getImplementsClause(), ct.getPermitsClause(), newMembers));
            } else if (tp.getLeaf().getKind() == Tree.Kind.BLOCK && parametersMulti.containsKey("$$1$") && var10_23.getKind() != Tree.Kind.BLOCK && StatementTree.class.isAssignableFrom(var10_23.getKind().asInterface())) {
                LinkedList<StatementTree> newStatements = new LinkedList<StatementTree>();
                newStatements.add(wc.getTreeMaker().ExpressionStatement(wc.getTreeMaker().Identifier("$$1$")));
                newStatements.add((StatementTree)var10_23);
                newStatements.add(wc.getTreeMaker().ExpressionStatement(wc.getTreeMaker().Identifier("$$2$")));
                BlockTree blockTree = wc.getTreeMaker().Block(newStatements, ((BlockTree)tp.getLeaf()).isStatic());
                original = tp.getLeaf();
                rewriteFromTo.put(original, blockTree);
            } else {
                while (tp.getParentPath().getLeaf().getKind() == Tree.Kind.PARENTHESIZED && tp.getLeaf().getKind() != var10_23.getKind() && tp.getParentPath() != null && tp.getParentPath().getParentPath() != null && !JavaFixUtilities.requiresParenthesis((Tree)var10_23, tp.getParentPath().getLeaf(), tp.getParentPath().getParentPath().getLeaf()) && JavaFixUtilities.requiresParenthesis(tp.getLeaf(), tp.getParentPath().getLeaf(), tp.getParentPath().getParentPath().getLeaf())) {
                    tp = tp.getParentPath();
                }
                original = tp.getLeaf();
                rewriteFromTo.put(original, (Tree)var10_23);
            }
            order.add(original);
            boolean inImport = var10_25.getKind() == Tree.Kind.IMPORT;
            boolean inPackage = false;
            for (TreePath w = tp; !inImport && w != null; w = w.getParentPath()) {
                inImport |= w.getLeaf().getKind() == Tree.Kind.IMPORT;
                inPackage |= w.getParentPath() != null && w.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && ((CompilationUnitTree)w.getParentPath().getLeaf()).getPackageName() == w.getLeaf();
            }
            final Set<Tree> originalTrees = Collections.newSetFromMap(new IdentityHashMap());
            new ErrorAwareTreeScanner<Void, Void>(){

                @Override
                public Void scan(Tree tree, Void p) {
                    originalTrees.add(tree);
                    return (Void)super.scan(tree, p);
                }
            }.scan(original, null);
            new ReplaceParameters(wc, ctx.isCanShowUI(), inImport, parameters, this.extraParamsData, implicitThis, parametersMulti, this.parameterNames, rewriteFromTo, order, originalTrees).scan(new TreePath(tp.getParentPath(), (Tree)rewriteFromTo.get(original)), null);
            if (inPackage) {
                String string = wc.getTreeUtilities().translate(wc.getCompilationUnit().getPackageName(), new IdentityHashMap<Tree, Tree>(rewriteFromTo)).toString();
                ClassPath classPath = wc.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                FileObject ownerRoot = classPath.findOwnerRoot(wc.getFileObject());
                if (ownerRoot != null) {
                    ctx.getFileChanges().add(new MoveFile(wc.getFileObject(), ownerRoot, string.replace('.', '/')));
                } else {
                    Logger.getLogger(JavaFix.class.getName()).log(Level.WARNING, "{0} not on its source path ({1})", new Object[]{FileUtil.getFileDisplayName(wc.getFileObject()), classPath.toString(ClassPath.PathConversionMode.PRINT)});
                }
            }
            for (Tree tree3 : order) {
                Tree to = (Tree)rewriteFromTo.get(tree3);
                wc.rewrite(tree3, to);
            }
        }
    }

    private static final class RemoveFromParent
    extends JavaFix {
        private final String displayName;
        private final boolean safely;

        public RemoveFromParent(String displayName, CompilationInfo info, TreePath toRemove, boolean safely) {
            super(info, toRemove);
            this.displayName = displayName;
            this.safely = safely;
        }

        @Override
        protected String getText() {
            return this.displayName;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            Element el;
            final WorkingCopy wc = ctx.getWorkingCopy();
            final TreePath tp = ctx.getPath();
            this.doRemoveFromParent(wc, tp);
            if (this.safely && (el = wc.getTrees().getElement(tp)) != null) {
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void scan(Tree tree, Void p) {
                        if (tree != null && tree != tp.getLeaf()) {
                            TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                            Element e = wc.getTrees().getElement(treePath);
                            if (el == e) {
                                this.doRemoveFromParent(wc, treePath);
                            }
                        }
                        return (Void)super.scan(tree, p);
                    }
                }.scan(new TreePath(wc.getCompilationUnit()), (Void)null);
            }
        }

        private void doRemoveFromParent(WorkingCopy wc, TreePath what) {
            TreeMaker make = wc.getTreeMaker();
            Tree leaf = what.getLeaf();
            Tree parentLeaf = what.getParentPath().getLeaf();
            switch (parentLeaf.getKind()) {
                case ANNOTATION: {
                    AnnotationTree at = (AnnotationTree)parentLeaf;
                    AnnotationTree newAnnot = make.removeAnnotationAttrValue(at, (ExpressionTree)leaf);
                    wc.rewrite(at, newAnnot);
                    break;
                }
                case BLOCK: {
                    BlockTree bt = (BlockTree)parentLeaf;
                    wc.rewrite(bt, make.removeBlockStatement(bt, (StatementTree)leaf));
                    break;
                }
                case CASE: {
                    CaseTree caseTree = (CaseTree)parentLeaf;
                    wc.rewrite(caseTree, make.removeCaseStatement(caseTree, (StatementTree)leaf));
                    break;
                }
                case CLASS: {
                    ClassTree nueClassTree;
                    ClassTree classTree = (ClassTree)parentLeaf;
                    if (classTree.getTypeParameters().contains(leaf)) {
                        nueClassTree = make.removeClassTypeParameter(classTree, (TypeParameterTree)leaf);
                    } else if (classTree.getExtendsClause() == leaf) {
                        nueClassTree = make.setExtends(classTree, null);
                    } else if (classTree.getImplementsClause().contains(leaf)) {
                        nueClassTree = make.removeClassImplementsClause(classTree, leaf);
                    } else if (classTree.getMembers().contains(leaf)) {
                        nueClassTree = make.removeClassMember(classTree, leaf);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    wc.rewrite(classTree, nueClassTree);
                    break;
                }
                case UNION_TYPE: {
                    UnionTypeTree disjunct = (UnionTypeTree)parentLeaf;
                    LinkedList<? extends Tree> alternatives = new LinkedList<Tree>(disjunct.getTypeAlternatives());
                    alternatives.remove(leaf);
                    wc.rewrite(disjunct, make.UnionType(alternatives));
                    break;
                }
                case METHOD: {
                    MethodTree newMethod;
                    MethodTree mTree = (MethodTree)parentLeaf;
                    if (mTree.getTypeParameters().contains(leaf)) {
                        newMethod = make.removeMethodTypeParameter(mTree, (TypeParameterTree)leaf);
                    } else if (mTree.getParameters().contains(leaf)) {
                        newMethod = make.removeMethodParameter(mTree, (VariableTree)leaf);
                    } else if (mTree.getThrows().contains(leaf)) {
                        newMethod = make.removeMethodThrows(mTree, (ExpressionTree)leaf);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    wc.rewrite(mTree, newMethod);
                    break;
                }
                case METHOD_INVOCATION: {
                    MethodInvocationTree newInvocation;
                    MethodInvocationTree iTree = (MethodInvocationTree)parentLeaf;
                    if (iTree.getTypeArguments().contains(leaf)) {
                        newInvocation = make.removeMethodInvocationTypeArgument(iTree, (ExpressionTree)leaf);
                    } else if (iTree.getArguments().contains(leaf)) {
                        newInvocation = make.removeMethodInvocationArgument(iTree, (ExpressionTree)leaf);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    wc.rewrite(iTree, newInvocation);
                    break;
                }
                case MODIFIERS: {
                    ModifiersTree modsTree = (ModifiersTree)parentLeaf;
                    wc.rewrite(modsTree, make.removeModifiersAnnotation(modsTree, (AnnotationTree)leaf));
                    break;
                }
                case NEW_CLASS: {
                    NewClassTree newNCT;
                    NewClassTree newCTree = (NewClassTree)parentLeaf;
                    if (newCTree.getTypeArguments().contains(leaf)) {
                        newNCT = make.removeNewClassTypeArgument(newCTree, (ExpressionTree)leaf);
                    } else if (newCTree.getArguments().contains(leaf)) {
                        newNCT = make.removeNewClassArgument(newCTree, (ExpressionTree)leaf);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    wc.rewrite(newCTree, newNCT);
                    break;
                }
                case PARAMETERIZED_TYPE: {
                    ParameterizedTypeTree parTree = (ParameterizedTypeTree)parentLeaf;
                    wc.rewrite(parTree, make.removeParameterizedTypeTypeArgument(parTree, (ExpressionTree)leaf));
                    break;
                }
                case SWITCH: {
                    SwitchTree switchTree = (SwitchTree)parentLeaf;
                    if (!switchTree.getCases().contains(leaf)) {
                        throw new UnsupportedOperationException();
                    }
                    SwitchTree newSwitch = make.removeSwitchCase(switchTree, (CaseTree)leaf);
                    wc.rewrite(switchTree, newSwitch);
                    break;
                }
                case TRY: {
                    TryTree newTry;
                    TryTree tryTree = (TryTree)parentLeaf;
                    if (tryTree.getResources().contains(leaf)) {
                        LinkedList<? extends Tree> resources = new LinkedList<Tree>(tryTree.getResources());
                        resources.remove(leaf);
                        newTry = make.Try(resources, tryTree.getBlock(), tryTree.getCatches(), tryTree.getFinallyBlock());
                    } else if (tryTree.getCatches().contains(leaf)) {
                        newTry = make.removeTryCatch(tryTree, (CatchTree)leaf);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    wc.rewrite(tryTree, newTry);
                    break;
                }
                case EXPRESSION_STATEMENT: {
                    this.doRemoveFromParent(wc, what.getParentPath());
                    break;
                }
                case ASSIGNMENT: {
                    AssignmentTree assignmentTree = (AssignmentTree)parentLeaf;
                    if (leaf == assignmentTree.getVariable()) {
                        if (wc.getTreeUtilities().isExpressionStatement(assignmentTree.getExpression())) {
                            wc.rewrite(parentLeaf, assignmentTree.getExpression());
                            break;
                        }
                        this.doRemoveFromParent(wc, what.getParentPath());
                        break;
                    }
                    throw new UnsupportedOperationException();
                }
                case AND_ASSIGNMENT: 
                case DIVIDE_ASSIGNMENT: 
                case LEFT_SHIFT_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: 
                case MULTIPLY_ASSIGNMENT: 
                case OR_ASSIGNMENT: 
                case PLUS_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: 
                case RIGHT_SHIFT_ASSIGNMENT: 
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                case XOR_ASSIGNMENT: {
                    CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)parentLeaf;
                    if (leaf == compoundAssignmentTree.getVariable()) {
                        if (wc.getTreeUtilities().isExpressionStatement(compoundAssignmentTree.getExpression())) {
                            wc.rewrite(parentLeaf, compoundAssignmentTree.getExpression());
                            break;
                        }
                        this.doRemoveFromParent(wc, what.getParentPath());
                        break;
                    }
                    throw new UnsupportedOperationException();
                }
                default: {
                    wc.rewrite(what.getLeaf(), make.Block(Collections.emptyList(), false));
                }
            }
        }

        private static boolean canSafelyRemove(final CompilationInfo info, final TreePath tp) {
            final AtomicBoolean ret = new AtomicBoolean(true);
            final Element el = info.getTrees().getElement(tp);
            if (el != null) {
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void scan(Tree tree, Void p) {
                        if (tree != null && tree != tp.getLeaf()) {
                            TreePath treePath = new TreePath(this.getCurrentPath(), tree);
                            Element e = info.getTrees().getElement(treePath);
                            if (el == e) {
                                Tree parentLeaf = treePath.getParentPath().getLeaf();
                                switch (parentLeaf.getKind()) {
                                    case ASSIGNMENT: {
                                        AssignmentTree assignmentTree = (AssignmentTree)parentLeaf;
                                        if (tree == assignmentTree.getVariable()) {
                                            if (info.getTreeUtilities().isExpressionStatement(assignmentTree.getExpression()) || !RemoveFromParent.canHaveSideEffects(assignmentTree.getExpression())) break;
                                            ret.set(false);
                                            return null;
                                        }
                                        ret.set(false);
                                        return null;
                                    }
                                    case AND_ASSIGNMENT: 
                                    case DIVIDE_ASSIGNMENT: 
                                    case LEFT_SHIFT_ASSIGNMENT: 
                                    case MINUS_ASSIGNMENT: 
                                    case MULTIPLY_ASSIGNMENT: 
                                    case OR_ASSIGNMENT: 
                                    case PLUS_ASSIGNMENT: 
                                    case REMAINDER_ASSIGNMENT: 
                                    case RIGHT_SHIFT_ASSIGNMENT: 
                                    case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                                    case XOR_ASSIGNMENT: {
                                        CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)parentLeaf;
                                        if (tree == compoundAssignmentTree.getVariable()) {
                                            if (info.getTreeUtilities().isExpressionStatement(compoundAssignmentTree.getExpression()) || !RemoveFromParent.canHaveSideEffects(compoundAssignmentTree.getExpression())) break;
                                            ret.set(false);
                                            return null;
                                        }
                                        ret.set(false);
                                        return null;
                                    }
                                    default: {
                                        ret.set(false);
                                        return null;
                                    }
                                }
                            }
                        }
                        return (Void)super.scan(tree, p);
                    }
                }.scan(new TreePath(info.getCompilationUnit()), (Void)null);
            }
            return ret.get();
        }

        private static boolean canHaveSideEffects(Tree tree) {
            final AtomicBoolean ret = new AtomicBoolean();
            new TreeScanner<Void, Void>(){

                @Override
                public Void scan(Tree tree, Void p) {
                    if (tree != null) {
                        switch (tree.getKind()) {
                            case METHOD_INVOCATION: 
                            case NEW_CLASS: 
                            case POSTFIX_DECREMENT: 
                            case POSTFIX_INCREMENT: 
                            case PREFIX_DECREMENT: 
                            case PREFIX_INCREMENT: {
                                ret.set(true);
                                return null;
                            }
                        }
                    }
                    return (Void)super.scan(tree, p);
                }
            }.scan(tree, null);
            return ret.get();
        }
    }

    private static class MoveFile
    extends SimpleRefactoringElementImplementation {
        private FileObject toMove;
        private final FileObject sourceRoot;
        private final String targetFolderName;
        DataFolder sourceFolder;
        DataObject source;

        public MoveFile(FileObject toMove, FileObject sourceRoot, String targetFolderName) {
            this.toMove = toMove;
            this.sourceRoot = sourceRoot;
            this.targetFolderName = targetFolderName;
        }

        @Override
        public String getText() {
            return Bundle.TXT_MoveFile(this.toMove.getNameExt());
        }

        @Override
        public String getDisplayText() {
            return this.getText();
        }

        @Override
        public void performChange() {
            try {
                FileObject target = FileUtil.createFolder(this.sourceRoot, this.targetFolderName);
                DataFolder targetFolder = DataFolder.findFolder(target);
                if (!this.toMove.isValid()) {
                    String path = FileUtil.getFileDisplayName(this.toMove);
                    Logger.getLogger(JavaFix.class.getName()).fine("Invalid FileObject " + path + "trying to recreate...");
                    this.toMove = FileUtil.toFileObject(FileUtil.toFile(this.toMove));
                    if (this.toMove == null) {
                        Logger.getLogger(JavaFix.class.getName()).severe("Invalid FileObject " + path + "\n. File not found.");
                        return;
                    }
                }
                this.source = DataObject.find(this.toMove);
                this.sourceFolder = this.source.getFolder();
                this.source.move(targetFolder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void undoChange() {
            try {
                this.source.move(this.sourceFolder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public FileObject getParentFile() {
            return this.toMove;
        }

        @Override
        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class ReplaceParameters
    extends ErrorAwareTreePathScanner<Number, Void> {
        private final CompilationInfo info;
        private final TreeMaker make;
        private final boolean canShowUI;
        private final boolean inImport;
        private final Map<String, TreePath> parameters;
        private final Map<String, Object> extraParamsData;
        private final Map<String, Element> implicitThis;
        private final Map<String, Collection<TreePath>> parametersMulti;
        private final Map<String, String> parameterNames;
        private final Map<Tree, Tree> rewriteFromTo;
        private final Set<Tree> originalTrees;
        private final List<Tree> order;
        private final List<Element> nestedTypes = new ArrayList<Element>();
        private static final EnumSet<Tree.Kind> COMPLEX_OPS = EnumSet.of(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR);

        public ReplaceParameters(WorkingCopy wc, boolean canShowUI, boolean inImport, Map<String, TreePath> parameters, Map<String, Object> extraParamsData, Map<String, Element> implicitThis, Map<String, Collection<TreePath>> parametersMulti, Map<String, String> parameterNames, Map<Tree, Tree> rewriteFromTo, List<Tree> order, Set<Tree> originalTrees) {
            this.parameters = parameters;
            this.info = wc;
            this.make = wc.getTreeMaker();
            this.canShowUI = canShowUI;
            this.inImport = inImport;
            this.extraParamsData = extraParamsData;
            this.implicitThis = implicitThis;
            this.parametersMulti = parametersMulti;
            this.parameterNames = parameterNames;
            this.rewriteFromTo = rewriteFromTo;
            this.order = order;
            this.originalTrees = originalTrees;
        }

        @Override
        public Number visitIdentifier(IdentifierTree node, Void p) {
            Element e;
            String name = node.getName().toString();
            Tree newNode = this.handleIdentifier(name, node);
            if (newNode != null) {
                this.rewrite(node, newNode);
                if (NUMBER_LITERAL_KINDS.contains((Object)newNode.getKind())) {
                    return (Number)((LiteralTree)newNode).getValue();
                }
            } else {
                Element implicitThisClass = this.implicitThis.get(name);
                if (implicitThisClass != null) {
                    Element enclClass = this.findEnclosingClass();
                    if (enclClass == implicitThisClass) {
                        this.rewrite(node, this.make.Identifier("this"));
                    } else {
                        this.rewrite(node, this.make.MemberSelect(this.make.QualIdent(implicitThisClass), "this"));
                    }
                    return null;
                }
            }
            if ((e = this.info.getTrees().getElement(this.getCurrentPath())) != null && JavaFixUtilities.isStaticElement(e) && !this.inImport) {
                this.rewrite(node, this.make.QualIdent(e));
            }
            return (Number)super.visitIdentifier(node, p);
        }

        private Element findEnclosingClass() {
            TreePath findClass;
            for (findClass = this.getCurrentPath(); findClass != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)findClass.getLeaf().getKind()); findClass = findClass.getParentPath()) {
            }
            return findClass != null ? this.info.getTrees().getElement(findClass) : null;
        }

        @Override
        public Number visitTypeParameter(TypeParameterTree node, Void p) {
            String name = node.getName().toString();
            Tree newNode = this.handleIdentifier(name, node);
            if (newNode != null) {
                this.rewrite(node, newNode);
                if (NUMBER_LITERAL_KINDS.contains((Object)newNode.getKind())) {
                    return (Number)((LiteralTree)newNode).getValue();
                }
            }
            return (Number)super.visitTypeParameter(node, p);
        }

        private Tree handleIdentifier(String name, Tree node) {
            String variableName;
            TreePath tp = this.parameters.get(name);
            if (tp != null) {
                Tree tree = tp.getLeaf();
                if (tree instanceof Hacks.RenameTree) {
                    Hacks.RenameTree rt = (Hacks.RenameTree)tree;
                    return this.make.setLabel(rt.originalTree, rt.newName);
                }
                if (!this.parameterNames.containsKey(name)) {
                    Tree target = tp.getLeaf();
                    if (NUMBER_LITERAL_KINDS.contains((Object)target.getKind())) {
                        return target;
                    }
                    if (this.getCurrentPath().getParentPath() != null && this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
                        ExpressionTree negated;
                        boolean rewriteNegated;
                        if (tp.getParentPath() == null) {
                            rewriteNegated = true;
                        } else {
                            Tree parent = tp.getParentPath().getLeaf();
                            TreePath aboveNewComplement = this.getCurrentPath().getParentPath().getParentPath();
                            boolean bl = rewriteNegated = parent.getKind() != Tree.Kind.LOGICAL_COMPLEMENT && (!COMPLEX_OPS.contains((Object)target.getKind()) || parent.getKind() != Tree.Kind.PARENTHESIZED || aboveNewComplement != null && aboveNewComplement.getLeaf().getKind() == Tree.Kind.PARENTHESIZED);
                        }
                        if (rewriteNegated && (negated = this.negate((ExpressionTree)tp.getLeaf(), this.getCurrentPath().getParentPath().getParentPath().getLeaf(), true)) != null) {
                            this.rewrite(this.getCurrentPath().getParentPath().getLeaf(), negated);
                        }
                    }
                    if (JavaFixUtilities.requiresParenthesis(target, node, this.getCurrentPath().getParentPath().getLeaf())) {
                        target = this.make.Parenthesized((ExpressionTree)target);
                    }
                    return target;
                }
            }
            if ((variableName = this.parameterNames.get(name)) != null) {
                return this.make.Identifier(variableName);
            }
            return null;
        }

        @Override
        public Number visitMemberSelect(MemberSelectTree node, Void p) {
            MemberSelectTree nue;
            block10: {
                String name;
                Element e = this.info.getTrees().getElement(this.getCurrentPath());
                if (e != null && (e.getKind() != ElementKind.CLASS || ((TypeElement)e).asType().getKind() != TypeKind.ERROR)) {
                    JavaFixUtilities.checkDependency(this.info, e, this.canShowUI);
                    if (JavaFixUtilities.isStaticElement(e) && !this.inImport) {
                        this.rewrite(node, this.make.QualIdent(e));
                        return null;
                    }
                }
                nue = node;
                String selectedName = node.getIdentifier().toString();
                if (selectedName.startsWith("$") && this.parameterNames.get(selectedName) != null) {
                    nue = this.make.MemberSelect(node.getExpression(), this.parameterNames.get(selectedName));
                }
                if (nue.getExpression().getKind() == Tree.Kind.IDENTIFIER && (name = ((IdentifierTree)nue.getExpression()).getName().toString()).startsWith("$") && this.parameters.get(name) == null) {
                    Element implicitThisClass = this.implicitThis.get(name);
                    if (implicitThisClass != null) {
                        for (TreePath findClass = this.getCurrentPath(); findClass != null; findClass = findClass.getParentPath()) {
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)findClass.getLeaf().getKind())) continue;
                            Element clazz = this.info.getTrees().getElement(findClass);
                            if (implicitThisClass.equals(clazz)) {
                                this.rewrite(node, this.make.Identifier(nue.getIdentifier()));
                                return null;
                            }
                            if (!clazz.getKind().isClass() && !clazz.getKind().isInterface()) continue;
                            for (Element element : this.info.getElements().getAllMembers((TypeElement)clazz)) {
                                if (!element.getSimpleName().equals(node.getIdentifier())) continue;
                                break block10;
                            }
                        }
                    } else {
                        this.rewrite(node, this.make.Identifier(nue.getIdentifier()));
                        return null;
                    }
                }
            }
            if (nue != node) {
                this.rewrite(node, nue);
            }
            return (Number)super.visitMemberSelect(node, p);
        }

        @Override
        public Number visitVariable(VariableTree node, Void p) {
            String nueName;
            String name = node.getName().toString();
            if (name.startsWith("$") && (nueName = this.parameterNames.get(name)) != null) {
                name = nueName;
            }
            VariableTree nue = this.make.Variable(node.getModifiers(), name, node.getType(), this.resolveOptionalValue(node.getInitializer()));
            this.rewrite(node, nue);
            return (Number)super.visitVariable(nue, p);
        }

        @Override
        public Number visitIf(IfTree node, Void p) {
            IfTree nue = this.make.If(node.getCondition(), node.getThenStatement(), this.resolveOptionalValue(node.getElseStatement()));
            this.rewrite(node, nue);
            return (Number)super.visitIf(nue, p);
        }

        @Override
        public Number visitMethod(MethodTree node, Void p) {
            String name;
            String newName = name = node.getName().toString();
            if (name.startsWith("$") && this.parameterNames.containsKey(name)) {
                newName = this.parameterNames.get(name);
            }
            List<? extends TypeParameterTree> typeParams = this.resolveMultiParameters(node.getTypeParameters());
            List<? extends VariableTree> params = this.resolveMultiParameters(node.getParameters());
            List<? extends ExpressionTree> thrown = this.resolveMultiParameters(node.getThrows());
            MethodTree nue = this.make.Method(node.getModifiers(), (CharSequence)newName, node.getReturnType(), typeParams, params, thrown, node.getBody(), (ExpressionTree)node.getDefaultValue());
            this.rewrite(node, nue);
            return (Number)super.visitMethod(nue, p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Number visitClass(ClassTree node, Void p) {
            String name;
            String newName = name = node.getSimpleName().toString();
            if (name.startsWith("$") && this.parameterNames.containsKey(name)) {
                newName = this.parameterNames.get(name);
            }
            List<? extends TypeParameterTree> typeParams = this.resolveMultiParameters(node.getTypeParameters());
            List<? extends Tree> implementsClauses = this.resolveMultiParameters(node.getImplementsClause());
            List<? extends Tree> permitsClauses = this.resolveMultiParameters(node.getPermitsClause());
            List<? extends Tree> members = this.resolveMultiParameters(Utilities.filterHidden(this.getCurrentPath(), node.getMembers()));
            Tree extend = this.resolveOptionalValue(node.getExtendsClause());
            ClassTree nue = this.make.Class(node.getModifiers(), newName, typeParams, extend, implementsClauses, permitsClauses, members);
            this.rewrite(node, nue);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            this.nestedTypes.add(el);
            try {
                Number number = (Number)super.visitClass(nue, p);
                return number;
            }
            finally {
                this.nestedTypes.remove(this.nestedTypes.size() - 1);
            }
        }

        @Override
        public Number visitExpressionStatement(ExpressionStatementTree node, Void p) {
            TreePath tp;
            CharSequence name = Utilities.getWildcardTreeName(node);
            if (name != null && (tp = this.parameters.get(name.toString())) != null && StatementTree.class.isAssignableFrom(tp.getLeaf().getKind().asInterface())) {
                this.rewrite(node, tp.getLeaf());
                return null;
            }
            return (Number)super.visitExpressionStatement(node, p);
        }

        @Override
        public Number visitLiteral(LiteralTree node, Void p) {
            Object object = node.getValue();
            if (object instanceof Number) {
                Number number = (Number)object;
                return number;
            }
            return (Number)super.visitLiteral(node, p);
        }

        @Override
        public Number visitBinary(BinaryTree node, Void p) {
            Number left = (Number)this.scan(node.getLeftOperand(), p);
            Number right = (Number)this.scan(node.getRightOperand(), p);
            if (left != null && right != null) {
                Double result;
                switch (node.getKind()) {
                    case MULTIPLY: {
                        Number number;
                        if (left instanceof Double || right instanceof Double) {
                            number = left.doubleValue() * right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            number = Float.valueOf(left.floatValue() * right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() * right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() * right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case DIVIDE: {
                        Number number;
                        if (left instanceof Double || right instanceof Double) {
                            number = left.doubleValue() / right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            number = Float.valueOf(left.floatValue() / right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() / right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() / right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case REMAINDER: {
                        Number number;
                        if (left instanceof Double || right instanceof Double) {
                            number = left.doubleValue() % right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            number = Float.valueOf(left.floatValue() % right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() % right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() % right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case PLUS: {
                        Number number;
                        if (left instanceof Double || right instanceof Double) {
                            number = left.doubleValue() + right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            number = Float.valueOf(left.floatValue() + right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() + right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() + right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case MINUS: {
                        Number number;
                        if (left instanceof Double || right instanceof Double) {
                            number = left.doubleValue() - right.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            number = Float.valueOf(left.floatValue() - right.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() - right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() - right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case LEFT_SHIFT: {
                        Number number;
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() << (int)right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() << right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case RIGHT_SHIFT: {
                        Number number;
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() >> (int)right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() >> right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case UNSIGNED_RIGHT_SHIFT: {
                        Number number;
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() >>> (int)right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() >>> right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case AND: {
                        Number number;
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() & right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() & right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case XOR: {
                        Number number;
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() ^ right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() ^ right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    case OR: {
                        Number number;
                        if (left instanceof Long || right instanceof Long) {
                            number = left.longValue() | right.longValue();
                            break;
                        }
                        if (left instanceof Integer || right instanceof Integer) {
                            number = left.intValue() | right.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + left.getClass() + ", right=" + right.getClass());
                    }
                    default: {
                        Number number = result = null;
                    }
                }
                if (result != null) {
                    this.rewrite(node, this.make.Literal(result));
                    return result;
                }
            }
            return null;
        }

        @Override
        public Number visitUnary(UnaryTree node, Void p) {
            Number op = (Number)this.scan(node.getExpression(), p);
            if (op != null) {
                Number result;
                switch (node.getKind()) {
                    case UNARY_MINUS: {
                        Number number;
                        if (op instanceof Double) {
                            number = -op.doubleValue();
                            break;
                        }
                        if (op instanceof Float) {
                            number = Float.valueOf(-op.floatValue());
                            break;
                        }
                        if (op instanceof Long) {
                            number = -op.longValue();
                            break;
                        }
                        if (op instanceof Integer) {
                            number = -op.intValue();
                            break;
                        }
                        throw new IllegalStateException("op=" + op.getClass());
                    }
                    case UNARY_PLUS: {
                        Number number = op;
                        break;
                    }
                    default: {
                        Number number = result = null;
                    }
                }
                if (result != null) {
                    this.rewrite(node, this.make.Literal(result));
                    return result;
                }
            }
            return (Number)super.visitUnary(node, p);
        }

        @Override
        public Number visitBlock(BlockTree node, Void p) {
            List<? extends StatementTree> nueStatement = this.resolveMultiParameters(node.getStatements());
            BlockTree nue = this.make.Block(nueStatement, node.isStatic());
            this.rewrite(node, nue);
            return (Number)super.visitBlock(nue, p);
        }

        @Override
        public Number visitCase(CaseTree node, Void p) {
            List<? extends StatementTree> statements = this.resolveMultiParameters(node.getStatements());
            CaseTree nue = this.make.Case(node.getExpression(), statements);
            this.rewrite(node, nue);
            return (Number)super.visitCase(node, p);
        }

        @Override
        public Number visitMethodInvocation(MethodInvocationTree node, Void p) {
            List<? extends Tree> typeArgs = this.resolveMultiParameters(node.getTypeArguments());
            List<? extends ExpressionTree> args = this.resolveMultiParameters(node.getArguments());
            MethodInvocationTree nue = this.make.MethodInvocation(typeArgs, node.getMethodSelect(), args);
            this.rewrite(node, nue);
            return (Number)super.visitMethodInvocation(nue, p);
        }

        @Override
        public Number visitNewClass(NewClassTree node, Void p) {
            List<? extends Tree> typeArgs = this.resolveMultiParameters(node.getTypeArguments());
            List<? extends ExpressionTree> args = this.resolveMultiParameters(node.getArguments());
            NewClassTree nue = this.make.NewClass(node.getEnclosingExpression(), typeArgs, node.getIdentifier(), args, node.getClassBody());
            this.rewrite(node, nue);
            return (Number)super.visitNewClass(nue, p);
        }

        @Override
        public Number visitParameterizedType(ParameterizedTypeTree node, Void p) {
            List<? extends Tree> typeArgs = this.resolveMultiParameters(node.getTypeArguments());
            ParameterizedTypeTree nue = this.make.ParameterizedType(node.getType(), typeArgs);
            this.rewrite(node, nue);
            return (Number)super.visitParameterizedType(node, p);
        }

        @Override
        public Number visitSwitch(SwitchTree node, Void p) {
            List<? extends CaseTree> cases = this.resolveMultiParameters(node.getCases());
            SwitchTree nue = this.make.Switch(node.getExpression(), cases);
            this.rewrite(node, nue);
            return (Number)super.visitSwitch(node, p);
        }

        @Override
        public Number visitTry(TryTree node, Void p) {
            List<? extends Tree> resources = this.resolveMultiParameters(node.getResources());
            List<? extends CatchTree> catches = this.resolveMultiParameters(node.getCatches());
            TryTree nue = this.make.Try(resources, node.getBlock(), catches, node.getFinallyBlock());
            this.rewrite(node, nue);
            return (Number)super.visitTry(node, p);
        }

        @Override
        public Number visitModifiers(ModifiersTree node, Void p) {
            IdentifierTree ident;
            ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(node.getAnnotations());
            IdentifierTree identifierTree = ident = !annotations.isEmpty() && ((AnnotationTree)annotations.get(0)).getAnnotationType().getKind() == Tree.Kind.IDENTIFIER ? (IdentifierTree)((AnnotationTree)annotations.get(0)).getAnnotationType() : null;
            if (ident != null) {
                ModifiersTree nue;
                annotations.remove(0);
                String name = ident.getName().toString();
                TreePath orig = this.parameters.get(name);
                if (orig != null && orig.getLeaf().getKind() == Tree.Kind.MODIFIERS) {
                    Object object;
                    Object objects;
                    Object object2;
                    ModifiersTree origMods = (ModifiersTree)orig.getLeaf();
                    Object actualContent = this.extraParamsData.get(name);
                    EnumSet<Modifier> actualFlags = EnumSet.noneOf(Modifier.class);
                    boolean[] actualAnnotationsMask = new boolean[]{};
                    if (actualContent instanceof Object[] && (object2 = (objects = (Object[])actualContent)[0]) instanceof Set) {
                        Set set = (Set)object2;
                        actualFlags.addAll(NbCollections.checkedSetByFilter(set, Modifier.class, false));
                    }
                    if (actualContent instanceof Object[] && (object = (objects = (Object[])actualContent)[1]) instanceof boolean[]) {
                        boolean[] booleans = (boolean[])object;
                        actualAnnotationsMask = booleans;
                    }
                    nue = origMods;
                    for (Modifier m : origMods.getFlags()) {
                        if (actualFlags.contains((Object)m)) continue;
                        nue = this.make.removeModifiersModifier(nue, m);
                    }
                    for (Modifier m : node.getFlags()) {
                        nue = this.make.addModifiersModifier(nue, m);
                    }
                    int ai = 0;
                    block2: for (AnnotationTree annotationTree : origMods.getAnnotations()) {
                        if (actualAnnotationsMask.length <= ai || actualAnnotationsMask[ai++]) continue;
                        Iterator it = annotations.iterator();
                        while (it.hasNext()) {
                            AnnotationTree toCheck = (AnnotationTree)it.next();
                            Collection<? extends Occurrence> match = Matcher.create(this.info).setTreeTopSearch().setSearchRoot(new TreePath(this.getCurrentPath(), annotationTree)).match(Pattern.createSimplePattern(new TreePath(this.getCurrentPath(), toCheck)));
                            if (match.isEmpty()) continue;
                            it.remove();
                            break block2;
                        }
                        nue = this.make.removeModifiersAnnotation(nue, annotationTree);
                    }
                    for (AnnotationTree annotationTree : annotations) {
                        nue = this.make.addModifiersAnnotation(nue, annotationTree);
                        this.scan(annotationTree, p);
                    }
                } else {
                    nue = this.make.removeModifiersAnnotation(node, 0);
                }
                this.rewrite(node, nue);
                return null;
            }
            return (Number)super.visitModifiers(node, p);
        }

        @Override
        public Number visitNewArray(NewArrayTree node, Void p) {
            List<? extends ExpressionTree> dimensions = this.resolveMultiParameters(node.getDimensions());
            List<? extends ExpressionTree> initializers = this.resolveMultiParameters(node.getInitializers());
            NewArrayTree nue = this.make.NewArray(node.getType(), dimensions, initializers);
            this.rewrite(node, nue);
            return (Number)super.visitNewArray(node, p);
        }

        @Override
        public Number visitLambdaExpression(LambdaExpressionTree node, Void p) {
            List<? extends VariableTree> args = this.resolveMultiParameters(node.getParameters());
            LambdaExpressionTree nue = this.make.LambdaExpression(args, node.getBody());
            Hacks.copyLambdaKind(node, nue);
            this.rewrite(node, nue);
            return (Number)super.visitLambdaExpression(node, p);
        }

        @Override
        public Number visitAnnotation(AnnotationTree node, Void p) {
            List<? extends ExpressionTree> args = this.resolveMultiParameters(node.getArguments());
            AnnotationTree nue = this.make.Annotation(node.getAnnotationType(), args);
            this.rewrite(node, nue);
            return (Number)super.visitAnnotation(node, p);
        }

        private <T extends Tree> List<T> resolveMultiParameters(List<T> list) {
            if (list == null) {
                return null;
            }
            if (!Utilities.containsMultistatementTrees(list)) {
                return list;
            }
            LinkedList<Tree> result = new LinkedList<Tree>();
            for (Tree t : list) {
                if (Utilities.isMultistatementWildcardTree(t)) {
                    Collection<TreePath> embedded = this.parametersMulti.get(Utilities.getWildcardTreeName(t).toString());
                    if (embedded == null) continue;
                    for (TreePath tp : embedded) {
                        if (tp == null) continue;
                        result.add(tp.getLeaf());
                    }
                    continue;
                }
                result.add(t);
            }
            return result;
        }

        private <T extends Tree> T resolveOptionalValue(T in) {
            if (in != null && Utilities.isMultistatementWildcardTree(in)) {
                TreePath out = this.parameters.get(Utilities.getWildcardTreeName(in).toString());
                if (out != null) {
                    return (T)out.getLeaf();
                }
                return null;
            }
            return in;
        }

        private ExpressionTree negate(ExpressionTree original, Tree parent, boolean nullOnPlainNeg) {
            ExpressionTree newTree;
            switch (original.getKind()) {
                case PARENTHESIZED: {
                    ExpressionTree expr = ((ParenthesizedTree)original).getExpression();
                    ExpressionTree negatedOrNull = this.negate(expr, original, nullOnPlainNeg);
                    if (negatedOrNull != null && negatedOrNull.getKind() != Tree.Kind.PARENTHESIZED) {
                        negatedOrNull = this.make.Parenthesized(negatedOrNull);
                    }
                    return negatedOrNull;
                }
                case INSTANCE_OF: {
                    return this.make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, this.make.Parenthesized(original));
                }
                case LOGICAL_COMPLEMENT: {
                    newTree = ((UnaryTree)original).getExpression();
                    while (newTree.getKind() == Tree.Kind.PARENTHESIZED && !JavaFixUtilities.requiresParenthesis(((ParenthesizedTree)newTree).getExpression(), original, parent)) {
                        newTree = ((ParenthesizedTree)newTree).getExpression();
                    }
                    break;
                }
                case NOT_EQUAL_TO: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.EQUAL_TO, false);
                    break;
                }
                case EQUAL_TO: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.NOT_EQUAL_TO, false);
                    break;
                }
                case BOOLEAN_LITERAL: {
                    newTree = this.make.Literal((Boolean)((LiteralTree)original).getValue() == false);
                    break;
                }
                case CONDITIONAL_AND: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.CONDITIONAL_OR, true);
                    break;
                }
                case CONDITIONAL_OR: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.CONDITIONAL_AND, true);
                    break;
                }
                case LESS_THAN: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.GREATER_THAN_EQUAL, false);
                    break;
                }
                case LESS_THAN_EQUAL: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.GREATER_THAN, false);
                    break;
                }
                case GREATER_THAN: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.LESS_THAN_EQUAL, false);
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    newTree = this.negateBinaryOperator(original, Tree.Kind.LESS_THAN, false);
                    break;
                }
                default: {
                    if (nullOnPlainNeg) {
                        return null;
                    }
                    newTree = this.make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, original);
                }
            }
            if (JavaFixUtilities.requiresParenthesis(newTree, original, parent)) {
                newTree = this.make.Parenthesized(newTree);
            }
            return newTree;
        }

        private ExpressionTree negateBinaryOperator(Tree original, Tree.Kind newKind, boolean negateOperands) {
            BinaryTree bt = (BinaryTree)original;
            BinaryTree nonNegated = this.make.Binary(newKind, bt.getLeftOperand(), bt.getRightOperand());
            if (negateOperands) {
                ExpressionTree lo = this.negate(bt.getLeftOperand(), nonNegated, false);
                ExpressionTree ro = this.negate(bt.getRightOperand(), nonNegated, false);
                return this.make.Binary(newKind, lo != null ? lo : bt.getLeftOperand(), ro != null ? ro : bt.getRightOperand());
            }
            return nonNegated;
        }

        private void rewrite(Tree from, Tree to) {
            if (this.originalTrees.contains(from)) {
                return;
            }
            this.rewriteFromTo.put(from, to);
            this.order.add(from);
        }
    }

    private static class IK {
        private final Object o;

        public IK(Object o) {
            this.o = o;
        }

        public int hashCode() {
            int hash = 7;
            if (this.o != null) {
                hash = 59 * hash + System.identityHashCode(this.o);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IK)) {
                return false;
            }
            IK other = (IK)obj;
            return other.o == this.o;
        }
    }
}

