/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.Exceptions;

final class SubscriberInputStream<T>
extends InputStream
implements Flow.Subscriber<T> {
    private static final Log logger = LogFactory.getLog(SubscriberInputStream.class);
    private static final Object READY = new Object();
    private static final byte[] DONE = new byte[0];
    private static final byte[] CLOSED = new byte[0];
    private final Function<T, byte[]> mapper;
    private final Consumer<T> onDiscardHandler;
    private final int prefetch;
    private final int limit;
    private final ReentrantLock lock;
    private final Queue<T> queue;
    private final AtomicReference<Object> parkedThread = new AtomicReference();
    private final AtomicInteger workAmount = new AtomicInteger();
    volatile boolean closed;
    private int consumed;
    @Nullable
    private byte[] available;
    private int position;
    @Nullable
    private Flow.Subscription subscription;
    private boolean done;
    @Nullable
    private Throwable error;

    SubscriberInputStream(Function<T, byte[]> mapper, Consumer<T> onDiscardHandler, int demand) {
        Assert.notNull(mapper, (String)"mapper must not be null");
        Assert.notNull(onDiscardHandler, (String)"onDiscardHandler must not be null");
        Assert.isTrue((demand > 0 ? 1 : 0) != 0, (String)"demand must be greater than 0");
        this.mapper = mapper;
        this.onDiscardHandler = onDiscardHandler;
        this.prefetch = demand;
        this.limit = demand == Integer.MAX_VALUE ? Integer.MAX_VALUE : demand - (demand >> 2);
        this.queue = new ArrayBlockingQueue<T>(demand);
        this.lock = new ReentrantLock(false);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscription != null) {
            subscription.cancel();
            return;
        }
        this.subscription = subscription;
        subscription.request(this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch);
    }

    @Override
    public void onNext(T buffer) {
        int previousWorkState;
        Assert.notNull(buffer, (String)"Buffer must not be null");
        if (this.done) {
            this.discard(buffer);
            return;
        }
        if (!this.queue.offer(buffer)) {
            this.discard(buffer);
            this.error = new RuntimeException("Buffer overflow");
            this.done = true;
        }
        if ((previousWorkState = this.addWork()) == Integer.MIN_VALUE) {
            T value = this.queue.poll();
            if (value != null) {
                this.discard(value);
            }
            return;
        }
        if (previousWorkState == 0) {
            this.resume();
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.done) {
            return;
        }
        this.error = throwable;
        this.done = true;
        if (this.addWork() == 0) {
            this.resume();
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.addWork() == 0) {
            this.resume();
        }
    }

    int addWork() {
        int nextProduced;
        int produced;
        do {
            if ((produced = this.workAmount.getPlain()) != Integer.MIN_VALUE) continue;
            return Integer.MIN_VALUE;
        } while (!this.workAmount.weakCompareAndSetRelease(produced, nextProduced = produced == Integer.MAX_VALUE ? 1 : produced + 1));
        return produced;
    }

    private void resume() {
        Object old;
        if (this.parkedThread.get() != READY && (old = this.parkedThread.getAndSet(READY)) != READY) {
            LockSupport.unpark((Thread)old);
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.lock.tryLock()) {
            if (this.closed) {
                return -1;
            }
            throw new ConcurrentModificationException("Concurrent access is not allowed");
        }
        try {
            byte[] next = this.getNextOrAwait();
            if (next == DONE) {
                this.closed = true;
                this.cleanAndFinalize();
                if (this.error == null) {
                    int n = -1;
                    return n;
                }
                throw Exceptions.propagate((Throwable)this.error);
            }
            if (next == CLOSED) {
                this.cleanAndFinalize();
                int n = -1;
                return n;
            }
            int n = next[this.position++] & 0xFF;
            return n;
        }
        catch (Throwable ex) {
            this.closed = true;
            this.requiredSubscriber().cancel();
            this.cleanAndFinalize();
            throw Exceptions.propagate((Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        if (!this.lock.tryLock()) {
            if (this.closed) {
                return -1;
            }
            throw new ConcurrentModificationException("concurrent access is disallowed");
        }
        try {
            int j = 0;
            while (j < len) {
                int i;
                int n;
                byte[] next = this.getNextOrAwait();
                if (next == DONE) {
                    this.cleanAndFinalize();
                    if (this.error == null) {
                        this.closed = true;
                        n = j == 0 ? -1 : j;
                        return n;
                    }
                    if (j == 0) {
                        this.closed = true;
                        throw Exceptions.propagate((Throwable)this.error);
                    }
                    n = j;
                    return n;
                }
                if (next == CLOSED) {
                    this.requiredSubscriber().cancel();
                    this.cleanAndFinalize();
                    n = -1;
                    return n;
                }
                for (i = this.position; i < next.length && j < len; ++i, ++j) {
                    b[off + j] = next[i];
                }
                this.position = i;
            }
            j = len;
            return j;
        }
        catch (Throwable ex) {
            this.closed = true;
            this.requiredSubscriber().cancel();
            this.cleanAndFinalize();
            throw Exceptions.propagate((Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    byte[] getNextOrAwait() {
        if (this.available == null || this.available.length - this.position == 0) {
            this.available = null;
            int actualWorkAmount = this.workAmount.getAcquire();
            while (true) {
                if (this.closed) {
                    return CLOSED;
                }
                boolean done = this.done;
                T buffer = this.queue.poll();
                if (buffer != null) {
                    int consumed = ++this.consumed;
                    this.position = 0;
                    this.available = Objects.requireNonNull(this.mapper.apply(buffer));
                    if (consumed != this.limit) break;
                    this.consumed = 0;
                    this.requiredSubscriber().request(this.limit);
                    break;
                }
                if (done) {
                    return DONE;
                }
                if ((actualWorkAmount = this.workAmount.addAndGet(-actualWorkAmount)) != 0) continue;
                this.await();
            }
        }
        return this.available;
    }

    void cleanAndFinalize() {
        int workAmount;
        this.available = null;
        do {
            T value;
            workAmount = this.workAmount.getPlain();
            while ((value = this.queue.poll()) != null) {
                this.discard(value);
            }
        } while (!this.workAmount.weakCompareAndSetPlain(workAmount, Integer.MIN_VALUE));
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.lock.tryLock()) {
            if (this.addWork() == 0) {
                this.resume();
            }
            return;
        }
        try {
            this.requiredSubscriber().cancel();
            this.cleanAndFinalize();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Flow.Subscription requiredSubscriber() {
        Assert.state((this.subscription != null ? 1 : 0) != 0, (String)"Subscriber must be subscribed to use InputStream");
        return this.subscription;
    }

    void discard(T buffer) {
        block2: {
            try {
                this.onDiscardHandler.accept(buffer);
            }
            catch (Throwable ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("Failed to release " + buffer.getClass().getSimpleName() + ": " + String.valueOf(buffer)), ex);
            }
        }
    }

    private void await() {
        Object current;
        Thread toUnpark = Thread.currentThread();
        while ((current = this.parkedThread.get()) != READY) {
            if (current != null && current != toUnpark) {
                throw new IllegalStateException("Only one (Virtual)Thread can await!");
            }
            if (!this.parkedThread.compareAndSet(null, toUnpark)) continue;
            LockSupport.park();
        }
        this.parkedThread.lazySet(null);
    }
}

