/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.metadata;

import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.AbstractScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;

public class MetadataScoringFilter
extends AbstractScoringFilter {
    public static final String METADATA_DATUM = "scoring.db.md";
    public static final String METADATA_CONTENT = "scoring.content.md";
    public static final String METADATA_PARSED = "scoring.parse.md";
    private static String[] datumMetadata;
    private static String[] contentMetadata;
    private static String[] parseMetadata;

    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) throws ScoringFilterException {
        if (parseMetadata == null || targets == null || parseData == null) {
            return adjust;
        }
        for (Map.Entry<Text, CrawlDatum> nextTarget : targets) {
            for (String meta : parseMetadata) {
                String metaFromParse = parseData.getMeta(meta);
                if (metaFromParse == null) continue;
                nextTarget.getValue().getMetaData().put((Writable)new Text(meta), (Writable)new Text(metaFromParse));
            }
        }
        return adjust;
    }

    public void passScoreBeforeParsing(Text url, CrawlDatum datum, Content content) {
        if (datumMetadata == null || content == null || datum == null) {
            return;
        }
        for (String meta : datumMetadata) {
            Text metaFromDatum = (Text)datum.getMetaData().get((Object)new Text(meta));
            if (metaFromDatum == null) continue;
            content.getMetadata().set(meta, metaFromDatum.toString());
        }
    }

    public void passScoreAfterParsing(Text url, Content content, Parse parse) {
        if (contentMetadata == null || content == null || parse == null) {
            return;
        }
        for (String meta : contentMetadata) {
            String metaFromContent = content.getMetadata().get(meta);
            if (metaFromContent == null) continue;
            parse.getData().getParseMeta().set(meta, metaFromContent);
        }
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        datumMetadata = conf.getStrings(METADATA_DATUM);
        contentMetadata = conf.getStrings(METADATA_CONTENT);
        parseMetadata = conf.getStrings(METADATA_PARSED);
    }
}

