/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.publisher.rabbitmq;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.MethodHandles;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.publisher.NutchPublisher;
import org.apache.nutch.rabbitmq.RabbitMQClient;
import org.apache.nutch.rabbitmq.RabbitMQMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQPublisherImpl
implements NutchPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String exchange;
    private String routingKey;
    private String headersStatic;
    private RabbitMQClient client;

    public boolean setConfig(Configuration conf) {
        try {
            this.exchange = conf.get("rabbitmq.publisher.exchange.name");
            this.routingKey = conf.get("rabbitmq.publisher.routingkey");
            this.headersStatic = conf.get("rabbitmq.publisher.headers.static", "");
            String uri = conf.get("rabbitmq.publisher.server.uri");
            this.client = new RabbitMQClient(uri);
            this.client.openChannel();
            boolean binding = conf.getBoolean("rabbitmq.publisher.binding", false);
            if (binding) {
                String queueName = conf.get("rabbitmq.publisher.queue.name");
                String queueOptions = conf.get("rabbitmq.publisher.queue.options");
                String exchangeOptions = conf.get("rabbitmq.publisher.exchange.options");
                String bindingArguments = conf.get("rabbitmq.publisher.binding.arguments", "");
                this.client.bind(this.exchange, exchangeOptions, queueName, queueOptions, this.routingKey, bindingArguments);
            }
            LOG.info("Configured RabbitMQ publisher");
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not initialize RabbitMQ publisher - {}", (Object)StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public void publish(Object event, Configuration conf) {
        try {
            RabbitMQMessage message = new RabbitMQMessage();
            message.setBody(this.getJSONString(event).getBytes());
            message.setHeaders(this.headersStatic);
            this.client.publish(this.exchange, this.routingKey, message);
        }
        catch (Exception e) {
            LOG.error("Error occured while publishing - {}", (Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    private String getJSONString(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error converting event object to JSON String - {}", (Object)StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public void setConf(Configuration arg0) {
    }

    public Configuration getConf() {
        return null;
    }
}

