/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.types.FeatureProvider;
import org.apache.hadoop.ozone.recon.heatmap.HeatMapServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/features")
@Produces(value={"application/json"})
@AdminOnly
public class FeaturesEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(HeatMapServiceImpl.class);
    private final OzoneConfiguration ozoneConfiguration;

    @Inject
    public FeaturesEndpoint(OzoneConfiguration ozoneConfiguration) {
        this.ozoneConfiguration = ozoneConfiguration;
    }

    @GET
    @Path(value="/disabledFeatures")
    public Response getDisabledFeatures() {
        List<FeatureProvider.Feature> allDisabledFeatures;
        try {
            allDisabledFeatures = FeatureProvider.getAllDisabledFeatures();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        LOG.info("List of disabled features in Recon: {}", (Object)allDisabledFeatures.toString());
        return Response.ok(allDisabledFeatures).build();
    }
}

