/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class LegacyBucketHandler
extends BucketHandler {
    private final String vol;
    private final String bucket;
    private final OmBucketInfo omBucketInfo;

    public LegacyBucketHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OmBucketInfo bucketInfo) {
        super(reconNamespaceSummaryManager, omMetadataManager);
        this.omBucketInfo = bucketInfo;
        this.vol = this.omBucketInfo.getVolumeName();
        this.bucket = this.omBucketInfo.getBucketName();
    }

    @Override
    public EntityType determineKeyPath(String keyName) throws IOException {
        String filename = OzoneFSUtils.removeTrailingSlashIfNeeded((String)keyName);
        String key = "/" + this.vol + "/" + this.bucket + "/" + filename;
        Table<String, OmKeyInfo> keyTable = this.getKeyTable();
        try (Table.KeyValueIterator iterator = keyTable.iterator();){
            iterator.seek((Object)key);
            if (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String dbKey = (String)kv.getKey();
                if (dbKey.equals(key)) {
                    EntityType entityType = EntityType.KEY;
                    return entityType;
                }
                if (dbKey.equals(key + "/")) {
                    EntityType entityType = EntityType.DIRECTORY;
                    return entityType;
                }
            }
            EntityType entityType = EntityType.UNKNOWN;
            return entityType;
        }
    }

    @Override
    public long calculateDUUnderObject(long parentId) throws IOException {
        Table<String, OmKeyInfo> keyTable = this.getKeyTable();
        long totalDU = 0L;
        String seekPrefix = "/" + this.vol + "/" + this.bucket + "/";
        NSSummary nsSummary = this.getReconNamespaceSummaryManager().getNSSummary(parentId);
        if (nsSummary == null) {
            return 0L;
        }
        if (this.omBucketInfo.getObjectID() != parentId) {
            String dirName = nsSummary.getDirName();
            seekPrefix = seekPrefix + dirName;
        }
        String[] seekKeys = seekPrefix.split("/");
        try (Table.KeyValueIterator iterator = keyTable.iterator();){
            iterator.seek((Object)seekPrefix);
            while (iterator.hasNext()) {
                OmKeyInfo keyInfo;
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String dbKey = (String)kv.getKey();
                if (!dbKey.startsWith(seekPrefix)) {
                    break;
                }
                String[] keys = dbKey.split("/");
                if (keys.length - seekKeys.length > 1 || (keyInfo = (OmKeyInfo)kv.getValue()) == null || keyInfo.getKeyName().endsWith("/")) continue;
                totalDU += keyInfo.getReplicatedSize();
            }
        }
        Set<Long> subDirIds = nsSummary.getChildDir();
        for (long subDirId : subDirIds) {
            totalDU += this.calculateDUUnderObject(subDirId);
        }
        return totalDU;
    }

    @Override
    public long handleDirectKeys(long parentId, boolean withReplica, boolean listFile, List<DUResponse.DiskUsage> duData, String normalizedPath) throws IOException {
        Table<String, OmKeyInfo> keyTable = this.getKeyTable();
        long keyDataSizeWithReplica = 0L;
        String seekPrefix = "/" + this.vol + "/" + this.bucket + "/";
        NSSummary nsSummary = this.getReconNamespaceSummaryManager().getNSSummary(parentId);
        if (nsSummary == null) {
            return 0L;
        }
        if (this.omBucketInfo.getObjectID() != parentId) {
            String dirName = nsSummary.getDirName();
            seekPrefix = seekPrefix + dirName;
        }
        String[] seekKeys = seekPrefix.split("/");
        try (Table.KeyValueIterator iterator = keyTable.iterator();){
            iterator.seek((Object)seekPrefix);
            while (iterator.hasNext()) {
                OmKeyInfo keyInfo;
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String dbKey = (String)kv.getKey();
                if (!dbKey.startsWith(seekPrefix)) {
                    break;
                }
                String[] keys = dbKey.split("/");
                if (keys.length - seekKeys.length > 1 || (keyInfo = (OmKeyInfo)kv.getValue()) == null || keyInfo.getKeyName().endsWith("/")) continue;
                DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
                String subpath = LegacyBucketHandler.buildSubpath(normalizedPath, keyInfo.getFileName());
                diskUsage.setSubpath(subpath);
                diskUsage.setKey(true);
                diskUsage.setSize(keyInfo.getDataSize());
                if (withReplica) {
                    long keyDU = keyInfo.getReplicatedSize();
                    keyDataSizeWithReplica += keyDU;
                    diskUsage.setSizeWithReplica(keyDU);
                }
                if (!listFile) continue;
                duData.add(diskUsage);
            }
        }
        return keyDataSizeWithReplica;
    }

    @Override
    public long getDirObjectId(String[] names) throws IOException {
        return this.getDirObjectId(names, names.length);
    }

    @Override
    public long getDirObjectId(String[] names, int cutoff) throws IOException {
        long dirObjectId = this.getBucketObjectId(names);
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < cutoff; ++i) {
            bld.append("/").append(names[i]);
        }
        bld.append("/");
        String dirKey = bld.toString();
        OmKeyInfo dirInfo = (OmKeyInfo)this.getKeyTable().getSkipCache((Object)dirKey);
        if (dirInfo == null) {
            throw new IOException("OmKeyInfo for the directory is null");
        }
        dirObjectId = dirInfo.getObjectID();
        return dirObjectId;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.LEGACY;
    }

    @Override
    public OmKeyInfo getKeyInfo(String[] names) throws IOException {
        String ozoneKey = "/";
        ozoneKey = ozoneKey + String.join((CharSequence)"/", names);
        OmKeyInfo keyInfo = (OmKeyInfo)this.getKeyTable().getSkipCache((Object)ozoneKey);
        return keyInfo;
    }

    public Table<String, OmKeyInfo> getKeyTable() {
        Table keyTable = this.getOmMetadataManager().getKeyTable(this.getBucketLayout());
        return keyTable;
    }

    @Override
    public OmDirectoryInfo getDirInfo(String[] names) throws IOException {
        String path = "/";
        path = path + String.join((CharSequence)"/", names);
        Preconditions.checkArgument((names.length >= 3 ? 1 : 0) != 0, (String)"Path should be a directory: %s", (Object)path);
        return OmDirectoryInfo.newBuilder().setName(names[2]).build();
    }
}

