/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.spi.ReconFileMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountKey;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileSizeCountTaskHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(FileSizeCountTaskHelper.class);
    private static final Object TRUNCATE_LOCK = new Object();

    public static void handlePutKeyEvent(OmKeyInfo omKeyInfo, Map<FileSizeCountKey, Long> fileSizeCountMap) {
        FileSizeCountKey key = FileSizeCountTaskHelper.getFileSizeCountKey(omKeyInfo);
        Long count = fileSizeCountMap.containsKey(key) ? fileSizeCountMap.get(key) + 1L : 1L;
        fileSizeCountMap.put(key, count);
    }

    public static void handleDeleteKeyEvent(String key, OmKeyInfo omKeyInfo, Map<FileSizeCountKey, Long> fileSizeCountMap) {
        if (omKeyInfo == null) {
            LOG.warn("Deleting a key not found while handling DELETE key event. Key not found in Recon OM DB: {}", (Object)key);
        } else {
            FileSizeCountKey countKey = FileSizeCountTaskHelper.getFileSizeCountKey(omKeyInfo);
            Long count = fileSizeCountMap.containsKey(countKey) ? fileSizeCountMap.get(countKey) - 1L : -1L;
            fileSizeCountMap.put(countKey, count);
        }
    }

    public static FileSizeCountKey getFileSizeCountKey(OmKeyInfo omKeyInfo) {
        return new FileSizeCountKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), ReconUtils.getFileSizeUpperBound(omKeyInfo.getDataSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateFileCountTableIfNeeded(ReconFileMetadataManager reconFileMetadataManager, String taskName) {
        Object object = TRUNCATE_LOCK;
        synchronized (object) {
            if (ReconConstants.FILE_SIZE_COUNT_TABLE_TRUNCATED.compareAndSet(false, true)) {
                try {
                    reconFileMetadataManager.clearFileCountTable();
                    LOG.info("Successfully truncated file count table for reprocess by task: {}", (Object)taskName);
                }
                catch (Exception e) {
                    LOG.error("Failed to truncate file count table for task: {}", (Object)taskName, (Object)e);
                    ReconConstants.FILE_SIZE_COUNT_TABLE_TRUNCATED.set(false);
                    throw new RuntimeException("Failed to truncate file count table", e);
                }
            } else {
                LOG.debug("File count table already truncated by another task, skipping for task: {}", (Object)taskName);
            }
        }
    }

    public static ReconOmTask.TaskResult reprocess(OMMetadataManager omMetadataManager, ReconFileMetadataManager reconFileMetadataManager, BucketLayout bucketLayout, String taskName) {
        LOG.info("Starting RocksDB Reprocess for {}", (Object)taskName);
        HashMap<FileSizeCountKey, Long> fileSizeCountMap = new HashMap<FileSizeCountKey, Long>();
        long startTime = Time.monotonicNow();
        FileSizeCountTaskHelper.truncateFileCountTableIfNeeded(reconFileMetadataManager, taskName);
        boolean status = FileSizeCountTaskHelper.reprocessBucketLayout(bucketLayout, omMetadataManager, fileSizeCountMap, reconFileMetadataManager, taskName);
        if (!status) {
            return FileSizeCountTaskHelper.buildTaskResult(taskName, false);
        }
        FileSizeCountTaskHelper.writeCountsToDB(fileSizeCountMap, reconFileMetadataManager);
        long endTime = Time.monotonicNow();
        LOG.info("{} completed RocksDB Reprocess in {} ms.", (Object)taskName, (Object)(endTime - startTime));
        return FileSizeCountTaskHelper.buildTaskResult(taskName, true);
    }

    public static boolean reprocessBucketLayout(BucketLayout bucketLayout, OMMetadataManager omMetadataManager, Map<FileSizeCountKey, Long> fileSizeCountMap, ReconFileMetadataManager reconFileMetadataManager, String taskName) {
        Table omKeyInfoTable = omMetadataManager.getKeyTable(bucketLayout);
        int totalKeysProcessed = 0;
        try (Table.KeyValueIterator keyIter = omKeyInfoTable.iterator();){
            while (keyIter.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                FileSizeCountTaskHelper.handlePutKeyEvent((OmKeyInfo)kv.getValue(), fileSizeCountMap);
                ++totalKeysProcessed;
                if (fileSizeCountMap.size() < 100000) continue;
                LOG.debug("Flushing {} accumulated counts to RocksDB for {}", (Object)fileSizeCountMap.size(), (Object)taskName);
                FileSizeCountTaskHelper.writeCountsToDB(fileSizeCountMap, reconFileMetadataManager);
                fileSizeCountMap.clear();
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to populate File Size Count for {} in RocksDB.", (Object)taskName, (Object)ioEx);
            return false;
        }
        LOG.info("Reprocessed {} keys for bucket layout {} using RocksDB.", (Object)totalKeysProcessed, (Object)bucketLayout);
        return true;
    }

    public static ReconOmTask.TaskResult processEvents(OMUpdateEventBatch events, String tableName, ReconFileMetadataManager reconFileMetadataManager, String taskName) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        HashMap<FileSizeCountKey, Long> fileSizeCountMap = new HashMap<FileSizeCountKey, Long>();
        long startTime = Time.monotonicNow();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            if (!tableName.equals(omdbUpdateEvent.getTable())) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            Object value = omdbUpdateEvent.getValue();
            Object oldValue = omdbUpdateEvent.getOldValue();
            if (value instanceof OmKeyInfo) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)value;
                OmKeyInfo omKeyInfoOld = (OmKeyInfo)oldValue;
                try {
                    switch (omdbUpdateEvent.getAction()) {
                        case PUT: {
                            FileSizeCountTaskHelper.handlePutKeyEvent(omKeyInfo, fileSizeCountMap);
                            break;
                        }
                        case DELETE: {
                            FileSizeCountTaskHelper.handleDeleteKeyEvent(updatedKey, omKeyInfo, fileSizeCountMap);
                            break;
                        }
                        case UPDATE: {
                            if (omKeyInfoOld != null) {
                                FileSizeCountTaskHelper.handleDeleteKeyEvent(updatedKey, omKeyInfoOld, fileSizeCountMap);
                                FileSizeCountTaskHelper.handlePutKeyEvent(omKeyInfo, fileSizeCountMap);
                                break;
                            }
                            LOG.warn("Update event does not have the old keyInfo for {}.", (Object)updatedKey);
                            break;
                        }
                        default: {
                            LOG.trace("Skipping DB update event: {}", (Object)omdbUpdateEvent.getAction());
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception while processing key {}.", (Object)updatedKey, (Object)e);
                    return FileSizeCountTaskHelper.buildTaskResult(taskName, false);
                }
            }
            LOG.warn("Unexpected value type {} for key {}. Skipping processing.", (Object)value.getClass().getName(), (Object)updatedKey);
        }
        FileSizeCountTaskHelper.writeCountsToDB(fileSizeCountMap, reconFileMetadataManager);
        LOG.debug("{} successfully processed using RocksDB in {} milliseconds", (Object)taskName, (Object)(Time.monotonicNow() - startTime));
        return FileSizeCountTaskHelper.buildTaskResult(taskName, true);
    }

    private static boolean isFileCountTableEmpty(ReconFileMetadataManager reconFileMetadataManager) {
        boolean bl;
        block8: {
            Table.KeyValueIterator iterator = reconFileMetadataManager.getFileCountTable().iterator();
            try {
                boolean bl2 = bl = !iterator.hasNext();
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Error checking if file count table is empty, assuming not empty", (Throwable)e);
                    return false;
                }
            }
            iterator.close();
        }
        return bl;
    }

    public static void writeCountsToDB(Map<FileSizeCountKey, Long> fileSizeCountMap, ReconFileMetadataManager reconFileMetadataManager) {
        if (fileSizeCountMap.isEmpty()) {
            return;
        }
        boolean isTableEmpty = FileSizeCountTaskHelper.isFileCountTableEmpty(reconFileMetadataManager);
        LOG.debug("writeCountsToDB: processing {} entries, isTableEmpty={}", (Object)fileSizeCountMap.size(), (Object)isTableEmpty);
        try (RDBBatchOperation rdbBatchOperation = new RDBBatchOperation();){
            for (Map.Entry<FileSizeCountKey, Long> entry : fileSizeCountMap.entrySet()) {
                FileSizeCountKey key = entry.getKey();
                Long deltaCount = entry.getValue();
                LOG.debug("Processing key: {}, deltaCount: {}", (Object)key, (Object)deltaCount);
                if (isTableEmpty) {
                    LOG.debug("Direct insert (table empty): key={}, deltaCount={}", (Object)key, (Object)deltaCount);
                    if (deltaCount <= 0L) continue;
                    reconFileMetadataManager.batchStoreFileSizeCount((BatchOperation)rdbBatchOperation, key, deltaCount);
                    LOG.debug("Storing key={} with deltaCount={}", (Object)key, (Object)deltaCount);
                    continue;
                }
                Long existingCount = reconFileMetadataManager.getFileSizeCount(key);
                Long newCount = (existingCount != null ? existingCount : 0L) + deltaCount;
                LOG.debug("Incremental update: key={}, existingCount={}, deltaCount={}, newCount={}", new Object[]{key, existingCount, deltaCount, newCount});
                if (newCount > 0L) {
                    reconFileMetadataManager.batchStoreFileSizeCount((BatchOperation)rdbBatchOperation, key, newCount);
                    LOG.debug("Storing key={} with newCount={}", (Object)key, (Object)newCount);
                    continue;
                }
                if (existingCount == null) continue;
                reconFileMetadataManager.batchDeleteFileSizeCount((BatchOperation)rdbBatchOperation, key);
                LOG.debug("Deleting key={} as newCount={} <= 0", (Object)key, (Object)newCount);
            }
            LOG.debug("Committing batch operation with {} operations", (Object)fileSizeCountMap.size());
            reconFileMetadataManager.commitBatchOperation(rdbBatchOperation);
            LOG.debug("Batch operation committed successfully");
        }
        catch (Exception e) {
            LOG.error("Error writing file size counts to RocksDB", (Throwable)e);
            throw new RuntimeException("Failed to write to RocksDB", e);
        }
    }

    public static ReconOmTask.TaskResult buildTaskResult(String taskName, boolean success) {
        return new ReconOmTask.TaskResult.Builder().setTaskName(taskName).setTaskSuccess(success).build();
    }
}

