/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.List;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.common.BekInfoUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketSetPropertyResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketSetPropertyRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMBucketSetPropertyRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMBucketSetPropertyRequest.class);
    }

    public OMBucketSetPropertyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder setBucketPropertyRequestBuilder = this.getOmRequest().getSetBucketPropertyRequest().toBuilder().setModificationTime(modificationTime);
        OzoneManagerProtocolProtos.BucketArgs bucketArgs = this.getOmRequest().getSetBucketPropertyRequest().getBucketArgs();
        if (bucketArgs.hasBekInfo()) {
            KeyProviderCryptoExtension kmsProvider = ozoneManager.getKmsProvider();
            OzoneManagerProtocolProtos.BucketArgs.Builder bucketArgsBuilder = setBucketPropertyRequestBuilder.getBucketArgsBuilder();
            bucketArgsBuilder.setBekInfo(BekInfoUtils.getBekInfo(kmsProvider, bucketArgs.getBekInfo()));
            setBucketPropertyRequestBuilder.setBucketArgs(bucketArgsBuilder.build());
        }
        return this.getOmRequest().toBuilder().setSetBucketPropertyRequest(setBucketPropertyRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientResponse omClientResponse;
        boolean success;
        Exception exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        String bucketName;
        String volumeName;
        OmBucketArgs omBucketArgs;
        OMMetrics omMetrics;
        block21: {
            long transactionLogIndex = context.getIndex();
            OzoneManagerProtocolProtos.SetBucketPropertyRequest setBucketPropertyRequest = this.getOmRequest().getSetBucketPropertyRequest();
            Preconditions.checkNotNull((Object)setBucketPropertyRequest);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketUpdates();
            OzoneManagerProtocolProtos.BucketArgs bucketArgs = setBucketPropertyRequest.getBucketArgs();
            omBucketArgs = OmBucketArgs.getFromProtobuf((OzoneManagerProtocolProtos.BucketArgs)bucketArgs);
            volumeName = bucketArgs.getVolumeName();
            bucketName = bucketArgs.getBucketName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OmBucketInfo omBucketInfo = null;
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            exception = null;
            boolean acquiredBucketLock = false;
            success = true;
            omClientResponse = null;
            try {
                try {
                    BucketEncryptionKeyInfo bek;
                    DefaultReplicationConfig defaultReplicationConfig;
                    Boolean versioning;
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAclPermission(ozoneManager, volumeName, bucketName);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                    String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                    OmBucketInfo dbBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
                    if (dbBucketInfo == null) {
                        LOG.debug("bucket: {} not found ", (Object)bucketName);
                        throw new OMException("Bucket doesn't exist", OMException.ResultCodes.BUCKET_NOT_FOUND);
                    }
                    if (dbBucketInfo.isLink()) {
                        throw new OMException("Cannot set property on link", OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
                    }
                    OmBucketInfo.Builder bucketInfoBuilder = dbBucketInfo.toBuilder();
                    bucketInfoBuilder.setUpdateID(transactionLogIndex);
                    bucketInfoBuilder.addAllMetadata(KeyValueUtil.getFromProtobuf((List)bucketArgs.getMetadataList()));
                    bucketInfoBuilder.setModificationTime(setBucketPropertyRequest.getModificationTime());
                    StorageType storageType = omBucketArgs.getStorageType();
                    if (storageType != null) {
                        bucketInfoBuilder.setStorageType(storageType);
                        LOG.debug("Updating bucket storage type for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
                    }
                    if ((versioning = omBucketArgs.getIsVersionEnabled()) != null) {
                        bucketInfoBuilder.setIsVersionEnabled(versioning.booleanValue());
                        LOG.debug("Updating bucket versioning for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
                    }
                    String volumeKey = omMetadataManager.getVolumeKey(volumeName);
                    OmVolumeArgs omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)volumeKey);
                    if (this.checkQuotaBytesValid(omMetadataManager, omVolumeArgs, omBucketArgs, dbBucketInfo)) {
                        bucketInfoBuilder.setQuotaInBytes(omBucketArgs.getQuotaInBytes());
                    }
                    if (this.checkQuotaNamespaceValid(omVolumeArgs, omBucketArgs, dbBucketInfo)) {
                        bucketInfoBuilder.setQuotaInNamespace(omBucketArgs.getQuotaInNamespace());
                    }
                    if ((defaultReplicationConfig = omBucketArgs.getDefaultReplicationConfig()) != null) {
                        bucketInfoBuilder.setDefaultReplicationConfig(defaultReplicationConfig);
                    }
                    if ((bek = omBucketArgs.getBucketEncryptionKeyInfo()) != null && bek.getKeyName() != null) {
                        bucketInfoBuilder.setBucketEncryptionKey(bek);
                    }
                    omBucketInfo = bucketInfoBuilder.build();
                    omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), CacheValue.get((long)transactionLogIndex, (Object)omBucketInfo));
                    omResponse.setSetBucketPropertyResponse(OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder().build());
                    omClientResponse = new OMBucketSetPropertyResponse(omResponse.build(), omBucketInfo);
                }
                catch (IOException | InvalidPathException ex) {
                    success = false;
                    exception = ex;
                    omClientResponse = new OMBucketSetPropertyResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.UPDATE_BUCKET, omBucketArgs.toAuditMap(), exception, userInfo));
        if (success) {
            LOG.debug("Setting bucket property for bucket:{} in volume:{}", (Object)bucketName, (Object)volumeName);
            return omClientResponse;
        }
        LOG.error("Setting bucket property failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        omMetrics.incNumBucketUpdateFails();
        return omClientResponse;
    }

    private void checkAclPermission(OzoneManager ozoneManager, String volumeName, String bucketName) throws IOException {
        if (ozoneManager.getAccessAuthorizer().isNative()) {
            UserGroupInformation ugi = this.createUGIForApi();
            String bucketOwner = ozoneManager.getBucketOwner(volumeName, bucketName, IAccessAuthorizer.ACLType.READ, OzoneObj.ResourceType.BUCKET);
            if (!ozoneManager.isAdmin(ugi) && !ozoneManager.isOwner(ugi, bucketOwner)) {
                throw new OMException("Bucket properties are allowed to changed by Admin and Owner", OMException.ResultCodes.PERMISSION_DENIED);
            }
        } else {
            this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, null);
        }
    }

    public boolean checkQuotaBytesValid(OMMetadataManager metadataManager, OmVolumeArgs omVolumeArgs, OmBucketArgs omBucketArgs, OmBucketInfo dbBucketInfo) throws IOException {
        if (!omBucketArgs.hasQuotaInBytes()) {
            return false;
        }
        long quotaInBytes = omBucketArgs.getQuotaInBytes();
        if (quotaInBytes == -1L && omVolumeArgs.getQuotaInBytes() != -1L) {
            throw new OMException("Can not clear bucket spaceQuota because volume spaceQuota is not cleared.", OMException.ResultCodes.QUOTA_ERROR);
        }
        if (quotaInBytes < -1L || quotaInBytes == 0L) {
            return false;
        }
        long totalBucketQuota = 0L;
        long volumeQuotaInBytes = omVolumeArgs.getQuotaInBytes();
        if (quotaInBytes > -1L) {
            totalBucketQuota = quotaInBytes;
            if (quotaInBytes < dbBucketInfo.getTotalBucketSpace()) {
                throw new OMException("Cannot update bucket quota. Requested spaceQuota less than used spaceQuota.", OMException.ResultCodes.QUOTA_ERROR);
            }
        }
        if (quotaInBytes < dbBucketInfo.getQuotaInBytes()) {
            return true;
        }
        List bucketList = metadataManager.listBuckets(omVolumeArgs.getVolume(), null, null, Integer.MAX_VALUE, false);
        for (OmBucketInfo bucketInfo : bucketList) {
            long nextQuotaInBytes;
            if (omBucketArgs.getBucketName().equals(bucketInfo.getBucketName()) || (nextQuotaInBytes = bucketInfo.getQuotaInBytes()) <= -1L) continue;
            totalBucketQuota += nextQuotaInBytes;
        }
        if (volumeQuotaInBytes < totalBucketQuota && volumeQuotaInBytes != -1L) {
            throw new OMException("Total buckets quota in this volume should not be greater than volume quota : the total space quota is set to:" + totalBucketQuota + ". But the volume space quota is:" + volumeQuotaInBytes, OMException.ResultCodes.QUOTA_EXCEEDED);
        }
        return true;
    }

    public boolean checkQuotaNamespaceValid(OmVolumeArgs omVolumeArgs, OmBucketArgs omBucketArgs, OmBucketInfo dbBucketInfo) throws IOException {
        if (!omBucketArgs.hasQuotaInNamespace()) {
            return false;
        }
        long quotaInNamespace = omBucketArgs.getQuotaInNamespace();
        if (quotaInNamespace < -1L || quotaInNamespace == 0L) {
            return false;
        }
        if (quotaInNamespace != -1L && quotaInNamespace < dbBucketInfo.getTotalBucketNamespace()) {
            throw new OMException("Cannot update bucket quota. NamespaceQuota requested is less than used namespaceQuota.", OMException.ResultCodes.QUOTA_ERROR);
        }
        return true;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.SetBucketProperty)
    public static OzoneManagerProtocolProtos.OMRequest disallowSetBucketPropertyWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        OzoneManagerProtocolProtos.SetBucketPropertyRequest propReq;
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && (propReq = req.getSetBucketPropertyRequest()).hasBucketArgs() && propReq.getBucketArgs().hasDefaultReplicationConfig() && propReq.getBucketArgs().getDefaultReplicationConfig().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMBucketSetPropertyRequest.java", OMBucketSetPropertyRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.bucket.OMBucketSetPropertyRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 80);
    }
}

