/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyDeleteRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyDeleteRequest.class);
    }

    public OMKeyDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest = super.preExecute(ozoneManager).getDeleteKeyRequest();
        Preconditions.checkNotNull((Object)deleteKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
        String keyPath = keyArgs.getKeyName();
        OmUtils.verifyKeyNameWithSnapshotReservedWordForDeletion((String)keyPath);
        keyPath = OMKeyDeleteRequest.normalizeKeyPath(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(keyPath);
        OzoneManagerProtocolProtos.KeyArgs resolvedArgs = this.resolveBucketAndCheckAcls(ozoneManager, newKeyArgs);
        return this.getOmRequest().toBuilder().setDeleteKeyRequest(deleteKeyRequest.toBuilder().setKeyArgs(resolvedArgs)).setUserInfo(this.getUserIfNotExists(ozoneManager)).build();
    }

    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketAndCheckAcls(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs) throws IOException {
        return (OzoneManagerProtocolProtos.KeyArgs)MetricUtil.captureLatencyNs((MutableRate)ozoneManager.getPerfMetrics().getDeleteKeyResolveBucketAndAclCheckLatencyNs(), () -> this.resolveBucketAndCheckKeyAcls(newKeyArgs.build(), ozoneManager, IAccessAuthorizer.ACLType.DELETE));
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        Exception exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest;
        block20: {
            long trxnLogIndex = context.getIndex();
            deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
            auditMap = this.buildLightKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyDeletes();
            OMPerformanceMetrics perfMetrics = ozoneManager.getPerfMetrics();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            boolean acquiredLock = false;
            omClientResponse = null;
            result = null;
            long startNanos = Time.monotonicNowNanos();
            try {
                try {
                    String objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)objectKey);
                    if (omKeyInfo == null) {
                        throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, keyName)), CacheValue.get((long)trxnLogIndex));
                    OmBucketInfo omBucketInfo = OMKeyDeleteRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long quotaReleased = OMKeyDeleteRequest.sumBlockLengths(omKeyInfo);
                    boolean isKeyNonEmpty = !OmKeyInfo.isKeyEmpty((OmKeyInfo)omKeyInfo);
                    omBucketInfo.decrUsedBytes(quotaReleased, isKeyNonEmpty);
                    omBucketInfo.decrUsedNamespace(1L, isKeyNonEmpty);
                    OmKeyInfo deletedOpenKeyInfo = null;
                    String dbOpenKey = null;
                    String hsyncClientId = (String)omKeyInfo.getMetadata().get("hsyncClientId");
                    if (hsyncClientId != null) {
                        Table openKeyTable = omMetadataManager.getOpenKeyTable(this.getBucketLayout());
                        OmKeyInfo openKeyInfo = (OmKeyInfo)openKeyTable.get((Object)(dbOpenKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, hsyncClientId)));
                        if (openKeyInfo != null) {
                            openKeyInfo.getMetadata().put("deletedHsyncKey", "true");
                            openKeyTable.addCacheEntry((Object)dbOpenKey, (Object)openKeyInfo, trxnLogIndex);
                            deletedOpenKeyInfo = openKeyInfo;
                        } else {
                            LOG.warn("Potentially inconsistent DB state: open key not found with dbOpenKey '{}'", (Object)dbOpenKey);
                        }
                    }
                    omClientResponse = new OMKeyDeleteResponse(omResponse.setDeleteKeyResponse(OzoneManagerProtocolProtos.DeleteKeyResponse.newBuilder()).build(), omKeyInfo, omBucketInfo.copyObject(), deletedOpenKeyInfo);
                    if (omKeyInfo.isFile()) {
                        auditMap.put("dataSize", String.valueOf(omKeyInfo.getDataSize()));
                        auditMap.put("replicationConfig", omKeyInfo.getReplicationConfig().toString());
                    }
                    result = OMClientRequest.Result.SUCCESS;
                    long endNanosDeleteKeySuccessLatencyNs = Time.monotonicNowNanos();
                    perfMetrics.setDeleteKeySuccessLatencyNs(endNanosDeleteKeySuccessLatencyNs - startNanos);
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyDeleteResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    long endNanosDeleteKeyFailureLatencyNs = Time.monotonicNowNanos();
                    perfMetrics.setDeleteKeyFailureLatencyNs(endNanosDeleteKeyFailureLatencyNs - startNanos);
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.DELETE_KEY, auditMap, exception, userInfo));
        switch (result) {
            case SUCCESS: {
                omMetrics.decNumKeys();
                LOG.debug("Key deleted. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                omMetrics.incNumKeyDeleteFails();
                LOG.error("Key delete failed. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.DeleteKey)
    public static OzoneManagerProtocolProtos.OMRequest blockDeleteKeyWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getDeleteKeyRequest().hasKeyArgs() && (keyArgs = req.getDeleteKeyRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyDeleteRequest.java", OMKeyDeleteRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 77);
    }
}

