/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotMoveDeletedKeysResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

@CleanupTableInfo(cleanupTables={"deletedTable", "snapshotInfoTable"})
public class OMKeyPurgeResponse
extends OmKeyResponse {
    private List<OmBucketInfo> bucketInfosToBeUpdated;
    private List<String> purgeKeyList;
    private List<String> renamedList;
    private SnapshotInfo fromSnapshot;
    private List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> keysToUpdateList;

    public OMKeyPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<String> keyList, @Nonnull List<String> renamedList, SnapshotInfo fromSnapshot, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> keysToUpdate, List<OmBucketInfo> bucketInfosToBeUpdated) {
        super(omResponse);
        this.purgeKeyList = keyList;
        this.renamedList = renamedList;
        this.fromSnapshot = fromSnapshot;
        this.keysToUpdateList = keysToUpdate;
        this.bucketInfosToBeUpdated = bucketInfosToBeUpdated == null ? Collections.emptyList() : bucketInfosToBeUpdated;
    }

    public OMKeyPurgeResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.fromSnapshot != null) {
            OmSnapshotManager omSnapshotManager = ((OmMetadataManagerImpl)omMetadataManager).getOzoneManager().getOmSnapshotManager();
            Object object = null;
            Object var5_6 = null;
            try (UncheckedAutoCloseableSupplier<OmSnapshot> rcOmFromSnapshot = omSnapshotManager.getSnapshot(this.fromSnapshot.getSnapshotId());){
                OmSnapshot fromOmSnapshot = (OmSnapshot)rcOmFromSnapshot.get();
                DBStore fromSnapshotStore = fromOmSnapshot.getMetadataManager().getStore();
                Throwable throwable = null;
                Object var10_13 = null;
                try (BatchOperation writeBatch = fromSnapshotStore.initBatchOperation();){
                    this.processKeys(writeBatch, fromOmSnapshot.getMetadataManager());
                    this.processKeysToUpdate(writeBatch, fromOmSnapshot.getMetadataManager());
                    fromSnapshotStore.commitBatchOperation(writeBatch);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            omMetadataManager.getSnapshotInfoTable().putWithBatch(batchOperation, (Object)this.fromSnapshot.getTableKey(), (Object)this.fromSnapshot);
        } else {
            this.processKeys(batchOperation, omMetadataManager);
            this.processKeysToUpdate(batchOperation, omMetadataManager);
        }
        for (OmBucketInfo bucketInfo : this.bucketInfosToBeUpdated) {
            String bucketKey = omMetadataManager.getBucketKey(bucketInfo.getVolumeName(), bucketInfo.getBucketName());
            omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)bucketKey, (Object)bucketInfo);
        }
    }

    private void processKeysToUpdate(BatchOperation batchOp, OMMetadataManager metadataManager) throws IOException {
        if (this.keysToUpdateList == null) {
            return;
        }
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos keyToUpdate : this.keysToUpdateList) {
            List keyInfosList = keyToUpdate.getKeyInfosList();
            RepeatedOmKeyInfo repeatedOmKeyInfo = OMSnapshotMoveDeletedKeysResponse.createRepeatedOmKeyInfo(keyInfosList, keyToUpdate.getBucketId());
            metadataManager.getDeletedTable().putWithBatch(batchOp, (Object)keyToUpdate.getKey(), (Object)repeatedOmKeyInfo);
        }
    }

    private void processKeys(BatchOperation batchOp, OMMetadataManager metadataManager) throws IOException {
        for (String key : this.purgeKeyList) {
            metadataManager.getDeletedTable().deleteWithBatch(batchOp, (Object)key);
        }
        for (String key : this.renamedList) {
            metadataManager.getSnapshotRenamedTable().deleteWithBatch(batchOp, (Object)key);
        }
    }
}

