/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.ozone.om.snapshot.PersistentList;
import org.apache.hadoop.ozone.util.ClosableIterator;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDbPersistentList<E>
implements PersistentList<E> {
    private final ManagedRocksDB db;
    private final ColumnFamilyHandle columnFamilyHandle;
    private final CodecRegistry codecRegistry;
    private final Class<E> entryType;
    private int currentIndex;

    public RocksDbPersistentList(ManagedRocksDB db, ColumnFamilyHandle columnFamilyHandle, CodecRegistry codecRegistry, Class<E> entryType) {
        this.db = db;
        this.columnFamilyHandle = columnFamilyHandle;
        this.codecRegistry = codecRegistry;
        this.entryType = entryType;
        this.currentIndex = 0;
    }

    @Override
    public boolean add(E entry) {
        try {
            byte[] rawKey = this.codecRegistry.asRawData((Object)this.currentIndex++);
            byte[] rawValue = this.codecRegistry.asRawData(entry);
            ((RocksDB)this.db.get()).put(this.columnFamilyHandle, rawKey, rawValue);
            return true;
        }
        catch (IOException | RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean addAll(PersistentList<E> from) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ClosableIterator<E> iterator = from.iterator();){
            iterator.forEachRemaining(this::add);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    @Override
    public E get(int index) {
        try {
            byte[] rawKey = this.codecRegistry.asRawData((Object)index);
            byte[] rawValue = ((RocksDB)this.db.get()).get(this.columnFamilyHandle, rawKey);
            return (E)this.codecRegistry.asObject(rawValue, this.entryType);
        }
        catch (IOException | RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public ClosableIterator<E> iterator() {
        final ManagedRocksIterator managedRocksIterator = new ManagedRocksIterator(((RocksDB)this.db.get()).newIterator(this.columnFamilyHandle));
        ((RocksIterator)managedRocksIterator.get()).seekToFirst();
        return new ClosableIterator<E>(){

            public boolean hasNext() {
                return ((RocksIterator)managedRocksIterator.get()).isValid();
            }

            public E next() {
                byte[] rawKey = ((RocksIterator)managedRocksIterator.get()).value();
                ((RocksIterator)managedRocksIterator.get()).next();
                try {
                    return RocksDbPersistentList.this.codecRegistry.asObject(rawKey, RocksDbPersistentList.this.entryType);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }

            public void close() {
                managedRocksIterator.close();
            }
        };
    }
}

