/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.interfaces;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.ozoneimpl.DataScanResult;
import org.apache.hadoop.ozone.container.ozoneimpl.MetadataScanResult;

public interface Container<CONTAINERDATA extends ContainerData> {
    public void create(VolumeSet var1, VolumeChoosingPolicy var2, String var3) throws StorageContainerException;

    public void delete() throws StorageContainerException;

    public boolean hasBlocks() throws IOException;

    public void update(Map<String, String> var1, boolean var2) throws StorageContainerException;

    public void update(Map<String, String> var1, boolean var2, String var3) throws StorageContainerException;

    public void updateDataScanTimestamp(Instant var1) throws StorageContainerException;

    public CONTAINERDATA getContainerData();

    public ContainerProtos.ContainerDataProto.State getContainerState();

    public void markContainerForClose() throws StorageContainerException;

    public void markContainerUnhealthy() throws StorageContainerException;

    public void markContainerForDelete();

    public void quasiClose() throws StorageContainerException;

    public void close() throws StorageContainerException;

    public ContainerProtos.ContainerType getContainerType();

    public File getContainerFile();

    public void updateDeleteTransactionId(long var1);

    public void importContainerData(InputStream var1, ContainerPacker<CONTAINERDATA> var2) throws IOException;

    public void exportContainerData(OutputStream var1, ContainerPacker<CONTAINERDATA> var2) throws IOException;

    public StorageContainerDatanodeProtocolProtos.ContainerReplicaProto getContainerReport() throws StorageContainerException;

    public void updateBlockCommitSequenceId(long var1);

    public long getBlockCommitSequenceId();

    public MetadataScanResult scanMetaData() throws InterruptedException;

    public boolean shouldScanData();

    public DataScanResult scanData(DataTransferThrottler var1, Canceler var2) throws InterruptedException;

    public void readLock();

    public void readLockInterruptibly() throws InterruptedException;

    public void readUnlock();

    public boolean hasReadLock();

    public void writeLock();

    public void writeLockInterruptibly() throws InterruptedException;

    public void writeUnlock();

    public boolean hasWriteLock();
}

