/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@InterfaceAudience.Private
@Metrics(about="Background Volume Scanner Metrics", context="dfs")
public class BackgroundVolumeScannerMetrics {
    public static final String SOURCE_NAME = BackgroundVolumeScannerMetrics.class.getSimpleName();
    @Metric(value={"number of volumes scanned in the last iteration"})
    private MutableGaugeLong numVolumesScannedInLastIteration;
    @Metric(value={"number of iterations the volume scanner has completed since the last restart"})
    private MutableCounterLong numScanIterations;
    @Metric(value={"number of data volume scans since the last restart"})
    private MutableCounterLong numDataVolumeScans;
    @Metric(value={"number of metadata volume scans since the last restart"})
    private MutableCounterLong numMetadataVolumeScans;
    @Metric(value={"number of volume scanner iterations skipped because the minimum gap since the last iteration had not elapsed"})
    private MutableCounterLong numIterationsSkipped;

    public static BackgroundVolumeScannerMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (BackgroundVolumeScannerMetrics)ms.register(SOURCE_NAME, "Background Volume Scanner Metrics", (Object)new BackgroundVolumeScannerMetrics());
    }

    public long getNumVolumesScannedInLastIteration() {
        return this.numVolumesScannedInLastIteration.value();
    }

    public void setNumVolumesScannedInLastIteration(long value) {
        this.numVolumesScannedInLastIteration.set(value);
    }

    public long getNumScanIterations() {
        return this.numScanIterations.value();
    }

    public void incNumScanIterations() {
        this.numScanIterations.incr();
    }

    public long getNumDataVolumeScans() {
        return this.numDataVolumeScans.value();
    }

    public void incNumDataVolumeScans(long count) {
        this.numDataVolumeScans.incr(count);
    }

    public long getNumMetadataVolumeScans() {
        return this.numMetadataVolumeScans.value();
    }

    public void incNumMetadataVolumeScans(long count) {
        this.numMetadataVolumeScans.incr(count);
    }

    public long getNumIterationsSkipped() {
        return this.numIterationsSkipped.value();
    }

    public void incNumIterationsSkipped() {
        this.numIterationsSkipped.incr();
    }

    public void unregister() {
        DefaultMetricsSystem.instance().unregisterSource(SOURCE_NAME);
    }
}

