/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;

final class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtil() {
    }

    private static String toJsonString(Class<?> clazz, Object value) {
        return JsonUtil.toJsonString(clazz.getSimpleName(), value);
    }

    public static String toJsonString(String key, Object value) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put(key, value);
        try {
            return MAPPER.writeValueAsString(m);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String toJsonString(Object obj) throws IOException {
        return MAPPER.writeValueAsString(obj);
    }

    public static String toJsonString(FsServerDefaults serverDefaults) {
        return JsonUtil.toJsonString(FsServerDefaults.class, JsonUtil.toJsonMap(serverDefaults));
    }

    private static Object toJsonMap(FsServerDefaults serverDefaults) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("blockSize", serverDefaults.getBlockSize());
        m.put("bytesPerChecksum", serverDefaults.getBytesPerChecksum());
        m.put("writePacketSize", serverDefaults.getWritePacketSize());
        m.put("replication", serverDefaults.getReplication());
        m.put("fileBufferSize", serverDefaults.getFileBufferSize());
        m.put("encryptDataTransfer", serverDefaults.getEncryptDataTransfer());
        m.put("trashInterval", serverDefaults.getTrashInterval());
        m.put("checksumType", serverDefaults.getChecksumType().id);
        m.put("keyProviderUri", serverDefaults.getKeyProviderUri());
        m.put("defaultStoragePolicyId", serverDefaults.getDefaultStoragePolicyId());
        return m;
    }

    public static String toJsonString(SnapshotDiffReport diffReport) {
        return JsonUtil.toJsonString(SnapshotDiffReport.class.getSimpleName(), JsonUtil.toJsonMap(diffReport));
    }

    private static Object toJsonMap(SnapshotDiffReport diffReport) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("snapshotRoot", diffReport.getSnapshotRoot());
        m.put("fromSnapshot", diffReport.getFromSnapshot());
        m.put("toSnapshot", diffReport.getLaterSnapshotName());
        Object[] diffList = new Object[diffReport.getDiffList().size()];
        for (int i = 0; i < diffReport.getDiffList().size(); ++i) {
            diffList[i] = JsonUtil.toJsonMap((SnapshotDiffReport.DiffReportEntry)diffReport.getDiffList().get(i));
        }
        m.put("diffList", diffList);
        return m;
    }

    private static Object toJsonMap(SnapshotDiffReport.DiffReportEntry diffReportEntry) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("type", diffReportEntry.getType());
        if (diffReportEntry.getSourcePath() != null) {
            m.put("sourcePath", DFSUtilClient.bytes2String((byte[])diffReportEntry.getSourcePath()));
        }
        if (diffReportEntry.getTargetPath() != null) {
            m.put("targetPath", DFSUtilClient.bytes2String((byte[])diffReportEntry.getTargetPath()));
        }
        return m;
    }
}

