/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.metrics;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.hadoop.hdds.scm.container.placement.metrics.DatanodeMetric;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class LongMetric
implements DatanodeMetric<Long, Long> {
    private Long value;

    public LongMetric(Long value) {
        this.value = value;
    }

    @Override
    public boolean isGreater(Long o) {
        return this.compareTo(o) > 0;
    }

    @Override
    public boolean isLess(Long o) {
        return this.compareTo(o) < 0;
    }

    @Override
    public boolean isEqual(Long o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public boolean hasResources(Long resourceNeeded) {
        return this.isGreater(resourceNeeded);
    }

    @Override
    public Long get() {
        return this.value;
    }

    @Override
    public void set(Long setValue) {
        this.value = setValue;
    }

    @Override
    public void add(Long addValue) {
        this.value = this.value + addValue;
    }

    @Override
    public void subtract(Long subValue) {
        this.value = this.value - subValue;
    }

    public int compareTo(Long o) {
        return Long.compare(this.value, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongMetric that = (LongMetric)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

