/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationQueue;
import org.apache.hadoop.hdds.scm.container.replication.UnhealthyReplicationProcessor;

public class OverReplicatedProcessor
extends UnhealthyReplicationProcessor<ContainerHealthResult.OverReplicatedHealthResult> {
    public OverReplicatedProcessor(ReplicationManager replicationManager, Supplier<Duration> interval) {
        super(replicationManager, interval);
    }

    @Override
    protected ContainerHealthResult.OverReplicatedHealthResult dequeueHealthResultFromQueue(ReplicationQueue queue) {
        return queue.dequeueOverReplicatedContainer();
    }

    @Override
    protected void requeueHealthResult(ReplicationQueue queue, ContainerHealthResult.OverReplicatedHealthResult healthResult) {
        queue.enqueue(healthResult);
    }

    @Override
    protected boolean inflightOperationLimitReached(ReplicationManager rm, long pendingOpLimit) {
        return false;
    }

    @Override
    protected int sendDatanodeCommands(ReplicationManager replicationManager, ContainerHealthResult.OverReplicatedHealthResult healthResult) throws IOException {
        return replicationManager.processOverReplicatedContainer(healthResult);
    }
}

