/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import org.jooq.SQLDialect;
import org.jooq.meta.Database;
import org.jooq.meta.cubrid.CUBRIDDatabase;
import org.jooq.meta.derby.DerbyDatabase;
import org.jooq.meta.firebird.FirebirdDatabase;
import org.jooq.meta.h2.H2Database;
import org.jooq.meta.hsqldb.HSQLDBDatabase;
import org.jooq.meta.jdbc.JDBCDatabase;
import org.jooq.meta.mariadb.MariaDBDatabase;
import org.jooq.meta.mysql.MySQLDatabase;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.sqlite.SQLiteDatabase;

public class Databases {
    public static final Class<? extends Database> databaseClass(SQLDialect dialect) {
        Class result = JDBCDatabase.class;
        switch (dialect) {
            case CUBRID: {
                result = CUBRIDDatabase.class;
                break;
            }
            case DERBY: {
                result = DerbyDatabase.class;
                break;
            }
            case FIREBIRD_2_5: 
            case FIREBIRD_3_0: 
            case FIREBIRD: {
                result = FirebirdDatabase.class;
                break;
            }
            case H2: {
                result = H2Database.class;
                break;
            }
            case HSQLDB: {
                result = HSQLDBDatabase.class;
                break;
            }
            case MARIADB: {
                result = MariaDBDatabase.class;
                break;
            }
            case MYSQL_5_7: 
            case MYSQL_8_0: 
            case MYSQL: {
                result = MySQLDatabase.class;
                break;
            }
            case POSTGRES_9_3: 
            case POSTGRES_9_4: 
            case POSTGRES_9_5: 
            case POSTGRES_10: 
            case POSTGRES: {
                result = PostgresDatabase.class;
                break;
            }
            case SQLITE: {
                result = SQLiteDatabase.class;
                break;
            }
            case DEFAULT: 
            case SQL99: {
                result = JDBCDatabase.class;
            }
        }
        return result;
    }

    public static final Database database(SQLDialect dialect) {
        try {
            return Databases.databaseClass(dialect).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create an Database instance for " + dialect, e);
        }
    }
}

