/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.util.Arrays;
import org.apache.hadoop.hdds.utils.db.RDBStoreAbstractIterator;
import org.apache.hadoop.hdds.utils.db.RDBTable;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.rocksdb.RocksIterator;

class RDBStoreByteArrayIterator
extends RDBStoreAbstractIterator<byte[]> {
    private static byte[] copyPrefix(byte[] prefix) {
        return prefix == null || prefix.length == 0 ? null : Arrays.copyOf(prefix, prefix.length);
    }

    RDBStoreByteArrayIterator(ManagedRocksIterator iterator, RDBTable table, byte[] prefix, Table.KeyValueIterator.Type type) {
        super(iterator, table, RDBStoreByteArrayIterator.copyPrefix(prefix), type);
        this.seekToFirst();
    }

    @Override
    byte[] key() {
        return ((RocksIterator)this.getRocksDBIterator().get()).key();
    }

    @Override
    Table.KeyValue<byte[], byte[]> getKeyValue() {
        ManagedRocksIterator i = this.getRocksDBIterator();
        byte[] key = this.getType().readKey() ? ((RocksIterator)i.get()).key() : null;
        byte[] value = this.getType().readValue() ? ((RocksIterator)i.get()).value() : null;
        return Table.newKeyValue(key, value);
    }

    @Override
    void seek0(byte[] key) {
        ((RocksIterator)this.getRocksDBIterator().get()).seek(key);
    }

    @Override
    void delete(byte[] key) throws RocksDatabaseException {
        this.getRocksDBTable().delete(key);
    }

    @Override
    boolean startsWithPrefix(byte[] value) {
        byte[] prefix = (byte[])this.getPrefix();
        if (prefix == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        int length = prefix.length;
        if (value.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (value[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }
}

