/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.IOException;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.audit.S3GAction;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.s3.commontypes.BucketMetadata;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListBucketResponse;
import org.apache.hadoop.ozone.s3.endpoint.S3Owner;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RootEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(RootEndpoint.class);

    @GET
    public Response get() throws OS3Exception, IOException {
        long startNanos = Time.monotonicNowNanos();
        boolean auditSuccess = true;
        try {
            Iterator<? extends OzoneBucket> bucketIterator;
            ListBucketResponse response = new ListBucketResponse();
            try {
                bucketIterator = this.listS3Buckets(null, volume -> response.setOwner(S3Owner.of(volume.getOwner())));
            }
            catch (Exception e) {
                this.getMetrics().updateListS3BucketsFailureStats(startNanos);
                throw e;
            }
            while (bucketIterator.hasNext()) {
                OzoneBucket next = bucketIterator.next();
                BucketMetadata bucketMetadata = new BucketMetadata();
                bucketMetadata.setName(next.getName());
                bucketMetadata.setCreationDate(next.getCreationTime());
                response.addBucket(bucketMetadata);
            }
            this.getMetrics().updateListS3BucketsSuccessStats(startNanos);
            Response response2 = Response.ok((Object)response).build();
            return response2;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(S3GAction.LIST_S3_BUCKETS, this.getAuditParameters(), ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(S3GAction.LIST_S3_BUCKETS, this.getAuditParameters()));
            }
        }
    }

    @Override
    public void init() {
    }
}

