/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import javax.ws.rs.core.HttpHeaders;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="Owner")
public class S3Owner {
    public static final String DEFAULT_S3OWNER_ID = "bb2bd7ca4a327f84e6cd3979f8fa3828a50a08893c1b68f9d6715352c8d07b93";
    public static final S3Owner DEFAULT_S3_OWNER = new S3Owner("bb2bd7ca4a327f84e6cd3979f8fa3828a50a08893c1b68f9d6715352c8d07b93", "ozone");
    @XmlElement(name="DisplayName")
    private String displayName;
    @XmlElement(name="ID")
    private String id;

    public S3Owner() {
    }

    public static S3Owner of(String displayName) {
        return new S3Owner(DEFAULT_S3OWNER_ID, displayName);
    }

    public S3Owner(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "S3Owner{displayName='" + this.displayName + '\'' + ", id='" + this.id + '\'' + '}';
    }

    public static boolean hasBucketOwnershipVerificationConditions(HttpHeaders headers) {
        if (headers == null) {
            return false;
        }
        String expectedBucketOwner = headers.getHeaderString("x-amz-expected-bucket-owner");
        if (!StringUtils.isEmpty((CharSequence)expectedBucketOwner)) {
            return true;
        }
        String expectedSourceBucketOwner = headers.getHeaderString("x-amz-source-expected-bucket-owner");
        return !StringUtils.isEmpty((CharSequence)expectedSourceBucketOwner);
    }

    public static void verifyBucketOwnerCondition(HttpHeaders headers, String bucketName, String bucketOwner) throws OS3Exception {
        S3Owner.verify(headers, "x-amz-expected-bucket-owner", bucketOwner, bucketName);
    }

    public static void verifyBucketOwnerConditionOnCopyOperation(HttpHeaders headers, String sourceBucketName, String sourceOwner, String destBucketName, String destOwner) throws OS3Exception {
        S3Owner.verify(headers, "x-amz-source-expected-bucket-owner", sourceOwner, sourceBucketName);
        S3Owner.verify(headers, "x-amz-expected-bucket-owner", destOwner, destBucketName);
    }

    private static void verify(HttpHeaders headers, String headerKey, String actualOwner, String bucketName) throws OS3Exception {
        if (headers == null || actualOwner == null) {
            return;
        }
        String expectedBucketOwner = headers.getHeaderString(headerKey);
        if (StringUtils.isEmpty((CharSequence)expectedBucketOwner)) {
            return;
        }
        if (expectedBucketOwner.equals(actualOwner)) {
            return;
        }
        throw S3ErrorTable.newError(S3ErrorTable.BUCKET_OWNER_MISMATCH, bucketName);
    }
}

