/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.paimon.spark;

import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.options.ConfigOption;

import static org.apache.paimon.options.ConfigOptions.key;

/** Options for spark catalog. */
public class SparkCatalogOptions {
    public static final ConfigOption<Boolean> CREATE_UNDERLYING_SESSION_CATALOG =
            key("catalog.create-underlying-session-catalog")
                    .booleanType()
                    .defaultValue(false)
                    .withDescription(
                            "If true, create and use an underlying session catalog instead of default session catalog when use SparkGenericCatalog.");

    public static final ConfigOption<String> DEFAULT_DATABASE =
            key("defaultDatabase")
                    .stringType()
                    .defaultValue(Catalog.DEFAULT_DATABASE)
                    .withDescription("The default database name.");

    public static final ConfigOption<Boolean> V1FUNCTION_ENABLED =
            key("v1Function.enabled")
                    .booleanType()
                    .defaultValue(true)
                    .withDescription("Whether to enable v1 function.");
}
