/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageBuilder;
import org.apache.rocketmq.client.java.message.MessageImpl;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.commons.lang3.ArrayUtils;
import org.apache.rocketmq.shaded.commons.lang3.StringUtils;

public class MessageBuilderImpl
implements MessageBuilder {
    public static final Pattern TOPIC_PATTERN = Pattern.compile("^[%a-zA-Z0-9_-]+$");
    protected String topic = null;
    protected byte[] body = null;
    protected String tag = null;
    protected String messageGroup = null;
    protected String liteTopic = null;
    protected Long deliveryTimestamp = null;
    protected Integer priority = null;
    protected Collection<String> keys = new HashSet<String>();
    protected final Map<String, String> properties = new HashMap<String, String>();

    @Override
    public MessageBuilder setTopic(String topic) {
        Preconditions.checkNotNull(topic, "topic should not be null");
        Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(), "topic does not match the regex [regex=%s]", (Object)TOPIC_PATTERN.pattern());
        this.topic = topic;
        return this;
    }

    @Override
    public MessageBuilder setBody(byte[] body) {
        Preconditions.checkArgument(ArrayUtils.isNotEmpty(body), "body should not be empty");
        this.body = (byte[])body.clone();
        return this;
    }

    @Override
    public MessageBuilder setTag(String tag) {
        Preconditions.checkArgument(StringUtils.isNotBlank(tag), "tag should not be blank");
        Preconditions.checkArgument(!tag.contains("|"), "tag should not contain \"|\"");
        this.tag = tag;
        return this;
    }

    @Override
    public MessageBuilder setKeys(String ... keys) {
        for (String key : keys) {
            Preconditions.checkArgument(StringUtils.isNotBlank(key), "key should not be blank");
        }
        this.keys = new ArrayList<String>();
        this.keys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public MessageBuilder setMessageGroup(String messageGroup) {
        Preconditions.checkArgument(null == this.deliveryTimestamp, "messageGroup and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument(null == this.liteTopic, "messageGroup and liteTopic should not be set at same time");
        Preconditions.checkArgument(null == this.priority, "messageGroup and priority should not be set at same time");
        Preconditions.checkArgument(StringUtils.isNotBlank(messageGroup), "messageGroup should not be blank");
        this.messageGroup = messageGroup;
        return this;
    }

    @Override
    public MessageBuilder setLiteTopic(String liteTopic) {
        Preconditions.checkArgument(null == this.deliveryTimestamp, "liteTopic and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument(null == this.messageGroup, "liteTopic and messageGroup should not be set at same time");
        Preconditions.checkArgument(null == this.priority, "liteTopic and priority should not be set at same time");
        Preconditions.checkArgument(StringUtils.isNotBlank(liteTopic), "liteTopic should not be blank");
        this.liteTopic = liteTopic;
        return this;
    }

    @Override
    public MessageBuilder setDeliveryTimestamp(long deliveryTimestamp) {
        Preconditions.checkArgument(null == this.messageGroup, "deliveryTimestamp and messageGroup should not be set at same time");
        Preconditions.checkArgument(null == this.liteTopic, "deliveryTimestamp and liteTopic should not be set at same time");
        Preconditions.checkArgument(null == this.priority, "deliveryTimestamp and priority should not be set at same time");
        this.deliveryTimestamp = deliveryTimestamp;
        return this;
    }

    @Override
    public MessageBuilder setPriority(int priority) {
        Preconditions.checkArgument(null == this.deliveryTimestamp, "priority and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument(null == this.messageGroup, "priority and messageGroup should not be set at same time");
        Preconditions.checkArgument(null == this.liteTopic, "priority and liteTopic should not be set at same time");
        Preconditions.checkArgument(priority >= 0, "priority must be greater than or equal to 0");
        this.priority = priority;
        return this;
    }

    @Override
    public MessageBuilder addProperty(String key, String value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key should not be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank(value), "value should not be blank");
        this.properties.put(key, value);
        return this;
    }

    @Override
    public Message build() {
        Preconditions.checkNotNull(this.topic, "topic has not been set yet");
        Preconditions.checkNotNull(this.body, "body has not been set yet");
        return new MessageImpl(this);
    }
}

