/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.cache.Caches;
import io.kubernetes.client.informer.cache.Indexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class Cache<ApiType extends KubernetesObject>
implements Indexer<ApiType> {
    private Function<ApiType, String> keyFunc;
    private Map<String, Function<ApiType, List<String>>> indexers = new HashMap<String, Function<ApiType, List<String>>>();
    private Map<String, ApiType> items = new HashMap<String, ApiType>();
    private Map<String, Map<String, Set<String>>> indices = new HashMap<String, Map<String, Set<String>>>();

    public Cache() {
        this("namespace", Caches::metaNamespaceIndexFunc, Caches::deletionHandlingMetaNamespaceKeyFunc);
    }

    public Cache(String indexName, Function<ApiType, List<String>> indexFunc, Function<ApiType, String> keyFunc) {
        this.indexers.put(indexName, indexFunc);
        this.keyFunc = keyFunc;
        this.indices.put(indexName, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        Cache cache = this;
        synchronized (cache) {
            KubernetesObject oldObj = (KubernetesObject)this.items.get(key);
            this.items.put(key, obj);
            this.updateIndices(oldObj, obj, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        Cache cache = this;
        synchronized (cache) {
            KubernetesObject oldObj = (KubernetesObject)this.items.get(key);
            this.items.put(key, obj);
            this.updateIndices(oldObj, obj, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        Cache cache = this;
        synchronized (cache) {
            boolean exists = this.items.containsKey(key);
            if (exists) {
                this.deleteFromIndices((KubernetesObject)this.items.get(key), key);
                this.items.remove(key);
            }
        }
    }

    @Override
    public synchronized void replace(List<ApiType> list, String resourceVersion) {
        HashMap<String, ApiType> newItems = new HashMap<String, ApiType>();
        for (KubernetesObject kubernetesObject : list) {
            String key = this.keyFunc.apply(kubernetesObject);
            newItems.put(key, kubernetesObject);
        }
        this.items = newItems;
        this.indices = new HashMap<String, Map<String, Set<String>>>();
        for (Map.Entry entry : this.items.entrySet()) {
            this.updateIndices(null, (KubernetesObject)entry.getValue(), (String)entry.getKey());
        }
    }

    @Override
    public void resync() {
    }

    @Override
    public synchronized List<String> listKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.items.size());
        for (Map.Entry<String, ApiType> entry : this.items.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiType get(ApiType obj) {
        String key = this.keyFunc.apply(obj);
        Cache cache = this;
        synchronized (cache) {
            return this.getByKey(key);
        }
    }

    @Override
    public synchronized List<ApiType> list() {
        ArrayList<KubernetesObject> itemList = new ArrayList<KubernetesObject>(this.items.size());
        for (Map.Entry<String, ApiType> entry : this.items.entrySet()) {
            itemList.add((KubernetesObject)entry.getValue());
        }
        return itemList;
    }

    @Override
    public synchronized ApiType getByKey(String key) {
        return (ApiType)((KubernetesObject)this.items.get(key));
    }

    @Override
    public synchronized List<ApiType> index(String indexName, ApiType obj) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Function<ApiType, List<String>> indexFunc = this.indexers.get(indexName);
        List<String> indexKeys = indexFunc.apply(obj);
        Map<String, Set<String>> index = this.indices.get(indexName);
        if (MapUtils.isEmpty(index)) {
            return new ArrayList();
        }
        HashSet<String> returnKeySet = new HashSet<String>();
        for (String indexKey : indexKeys) {
            Set<String> set = index.get(indexKey);
            if (CollectionUtils.isEmpty(set)) continue;
            returnKeySet.addAll(set);
        }
        ArrayList<KubernetesObject> items = new ArrayList<KubernetesObject>(returnKeySet.size());
        for (String absoluteKey : returnKeySet) {
            items.add((KubernetesObject)this.items.get(absoluteKey));
        }
        return items;
    }

    @Override
    public synchronized List<String> indexKeys(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        ArrayList<String> keys = new ArrayList<String>(set.size());
        for (String key : set) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    public synchronized List<ApiType> byIndex(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        if (set == null) {
            return Arrays.asList(new KubernetesObject[0]);
        }
        ArrayList<KubernetesObject> items = new ArrayList<KubernetesObject>(set.size());
        for (String key : set) {
            items.add((KubernetesObject)this.items.get(key));
        }
        return items;
    }

    @Override
    public Map<String, Function<ApiType, List<String>>> getIndexers() {
        return this.indexers;
    }

    @Override
    public void addIndexers(Map<String, Function<ApiType, List<String>>> newIndexers) {
        if (!this.items.isEmpty()) {
            throw new IllegalStateException("cannot add indexers to a non-empty cache");
        }
        Set<String> oldKeys = this.indexers.keySet();
        Set<String> newKeys = newIndexers.keySet();
        HashSet<String> intersection = new HashSet<String>(oldKeys);
        intersection.retainAll(newKeys);
        if (!intersection.isEmpty()) {
            throw new IllegalArgumentException("indexer conflict: " + intersection);
        }
        for (Map.Entry<String, Function<ApiType, List<String>>> indexEntry : newIndexers.entrySet()) {
            this.addIndexFunc(indexEntry.getKey(), indexEntry.getValue());
        }
    }

    public void updateIndices(ApiType oldObj, ApiType newObj, String key) {
        if (oldObj != null) {
            this.deleteFromIndices(oldObj, key);
        }
        for (Map.Entry<String, Function<ApiType, List<String>>> indexEntry : this.indexers.entrySet()) {
            String indexName = indexEntry.getKey();
            Function<ApiType, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(newObj);
            if (CollectionUtils.isEmpty(indexValues)) continue;
            Map index = this.indices.computeIfAbsent(indexName, k -> new HashMap());
            for (String indexValue : indexValues) {
                Set indexSet = index.computeIfAbsent(indexValue, k -> new HashSet());
                indexSet.add(key);
            }
        }
    }

    private void deleteFromIndices(ApiType oldObj, String key) {
        for (Map.Entry<String, Function<ApiType, List<String>>> indexEntry : this.indexers.entrySet()) {
            Map<String, Set<String>> index;
            Function<ApiType, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(oldObj);
            if (CollectionUtils.isEmpty(indexValues) || (index = this.indices.get(indexEntry.getKey())) == null) continue;
            for (String indexValue : indexValues) {
                Set<String> indexSet = index.get(indexValue);
                if (indexSet == null) continue;
                indexSet.remove(key);
            }
        }
    }

    public void addIndexFunc(String indexName, Function<ApiType, List<String>> indexFunc) {
        this.indices.put(indexName, new HashMap());
        this.indexers.put(indexName, indexFunc);
    }

    public Function<ApiType, String> getKeyFunc() {
        return this.keyFunc;
    }

    public void setKeyFunc(Function<ApiType, String> keyFunc) {
        this.keyFunc = keyFunc;
    }
}

