/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff.runtime;

import com.dyuproject.protostuff.runtime.ArraySchema;
import com.dyuproject.protostuff.runtime.ClassSchema;
import com.dyuproject.protostuff.runtime.IdStrategy;
import com.dyuproject.protostuff.runtime.NumberSchema;
import com.dyuproject.protostuff.runtime.ObjectSchema;
import com.dyuproject.protostuff.runtime.PolymorphicCollectionSchema;
import com.dyuproject.protostuff.runtime.PolymorphicEnumSchema;
import com.dyuproject.protostuff.runtime.PolymorphicMapSchema;
import com.dyuproject.protostuff.runtime.PolymorphicSchema;
import com.dyuproject.protostuff.runtime.PolymorphicThrowableSchema;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PolymorphicSchemaFactories implements PolymorphicSchema.Factory
{
    ARRAY{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new ArraySchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    NUMBER{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new NumberSchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    CLASS{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new ClassSchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    ENUM{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicEnumSchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    COLLECTION{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicCollectionSchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    MAP{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicMapSchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    THROWABLE{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicThrowableSchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    OBJECT{

        public PolymorphicSchema newSchema(IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new ObjectSchema(strategy){

                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    };


    public static PolymorphicSchema.Factory getFactoryFromField(Class<?> clazz) {
        if (clazz.isArray()) {
            return ARRAY;
        }
        if (Number.class == clazz) {
            return NUMBER;
        }
        if (Class.class == clazz) {
            return CLASS;
        }
        if (Enum.class == clazz) {
            return ENUM;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MAP;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return COLLECTION;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return THROWABLE;
        }
        return OBJECT;
    }

    public static PolymorphicSchema.Factory getFactoryFromRepeatedValueGenericType(Class<?> clazz) {
        if (clazz.isArray()) {
            return ARRAY;
        }
        if (Number.class == clazz) {
            return NUMBER;
        }
        if (Class.class == clazz) {
            return CLASS;
        }
        if (Enum.class == clazz) {
            return ENUM;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return THROWABLE;
        }
        if (Object.class == clazz) {
            return OBJECT;
        }
        return null;
    }

    public static PolymorphicSchema getSchemaFromCollectionOrMapGenericType(Class<?> clazz, IdStrategy strategy) {
        if (clazz.isArray()) {
            return strategy.ARRAY_ELEMENT_SCHEMA;
        }
        if (Number.class == clazz) {
            return strategy.NUMBER_ELEMENT_SCHEMA;
        }
        if (Class.class == clazz) {
            return strategy.CLASS_ELEMENT_SCHEMA;
        }
        if (Enum.class == clazz) {
            return strategy.POLYMORPHIC_ENUM_ELEMENT_SCHEMA;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return strategy.POLYMORPHIC_THROWABLE_ELEMENT_SCHEMA;
        }
        if (Object.class == clazz) {
            return strategy.OBJECT_ELEMENT_SCHEMA;
        }
        return null;
    }
}

