/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.DiscoveryDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.DiscoveryVO;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final DiscoveryService discoveryService;

    public DiscoveryDataConfigsExportImportHandler(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.Discovery;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<DiscoveryVO> discoveryList = this.discoveryService.listAllDataByNamespaceId(namespaceId);
        if (CollectionUtils.isNotEmpty(discoveryList)) {
            discoveryList.forEach(discoveryVO -> discoveryVO.setNamespaceId(null));
            return Optional.of(JsonUtils.toJson(discoveryList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List discoveryList = GsonUtils.getInstance().fromList(data, DiscoveryDTO.class);
        ConfigImportResult configImportResult = this.discoveryService.importData(namespaceId, discoveryList, context);
        context.getResult().put("discoveryImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("discoveryImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

