/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(unit, startTimestamp, endTimestamp) - Gets the difference between the timestamps `endTimestamp` and `startTimestamp` in the specified units by truncating the fraction part.", arguments="\n    Arguments:\n      * unit - this indicates the units of the difference between the given timestamps.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * startTimestamp - A timestamp which the expression subtracts from `endTimestamp`.\n      * endTimestamp - A timestamp from which the expression subtracts `startTimestamp`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, timestamp_ntz'2022-02-11 20:30:00', timestamp_ntz'2022-02-12 04:30:00');\n       8\n      > SELECT _FUNC_(MONTH, timestamp_ltz'2022-01-01 00:00:00', timestamp_ltz'2022-02-28 00:00:00');\n       1\n      > SELECT _FUNC_(SECOND, date'2022-01-01', timestamp'2021-12-31 23:59:50');\n       -10\n      > SELECT _FUNC_(YEAR, timestamp'2000-01-01 01:02:03.123456', timestamp'2010-01-01 01:02:03.123456');\n       10\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001\u0002\u0016,\u0001bB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\tA\u0002\u0011\t\u0012)A\u0005+\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B2\t\u0011%\u0004!Q3A\u0005\u0002)D\u0001B\u001c\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006_\u0002!\tA\u001e\u0005\u0006y\u0002!\tE\u0019\u0005\u0006{\u0002!\tE\u0019\u0005\u0006}\u0002!\te \u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\t9\u0003\u0001C!\u0003SA!\"!\f\u0001\u0011\u000b\u0007I\u0011BA\u0018\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!a\u0017\u0001\t\u0003\ni\u0006\u0003\u0004\u0002z\u0001!\t\u0005\u0016\u0005\u0006a\u0001!\t\u0005\u0016\u0005\b\u0003w\u0002A\u0011KA?\u0011%\t9\tAA\u0001\n\u0003\tI\tC\u0005\u0002\u0014\u0002\t\n\u0011\"\u0001\u0002\u0016\"I\u00111\u0016\u0001\u0012\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003c\u0003\u0011\u0013!C\u0001\u0003[C\u0011\"a-\u0001#\u0003%\t!!.\t\u0013\u0005e\u0006!!A\u0005B\u0005m\u0006\"CAd\u0001\u0005\u0005I\u0011AAe\u0011%\t\t\u000eAA\u0001\n\u0003\t\u0019\u000eC\u0005\u0002Z\u0002\t\t\u0011\"\u0011\u0002\\\"I\u0011\u0011\u001e\u0001\u0002\u0002\u0013\u0005\u00111\u001e\u0005\n\u0003k\u0004\u0011\u0011!C!\u0003o<\u0011B!\t,\u0003\u0003E\tAa\t\u0007\u0011)Z\u0013\u0011!E\u0001\u0005KAaa\u001c\u0012\u0005\u0002\tM\u0002\"\u0003B\u001bE\u0005\u0005IQ\tB\u001c\u0011%\u0011IDIA\u0001\n\u0003\u0013Y\u0004C\u0005\u0003F\t\n\n\u0011\"\u0001\u00026\"I!q\t\u0012\u0002\u0002\u0013\u0005%\u0011\n\u0005\n\u0005/\u0012\u0013\u0013!C\u0001\u0003kC\u0011B!\u0017#\u0003\u0003%IAa\u0017\u0003\u001bQKW.Z:uC6\u0004H)\u001b4g\u0015\taS&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u00180\u0003!\u0019\u0017\r^1msN$(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\nQa\u001d9be.T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011c\u0002\u0001:{\u0001;%\n\u0015\t\u0003umj\u0011aK\u0005\u0003y-\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA!E\u001d\tQ$)\u0003\u0002DW\u00059\u0001/Y2lC\u001e,\u0017BA#G\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!aQ\u0016\u0011\u0005iB\u0015BA%,\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJA\u0004Qe>$Wo\u0019;\u0011\u0005-\u000b\u0016B\u0001*M\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011)h.\u001b;\u0016\u0003U\u0003\"AV/\u000f\u0005][\u0006C\u0001-M\u001b\u0005I&B\u0001.8\u0003\u0019a$o\\8u}%\u0011A\fT\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]\u0019\u0006)QO\\5uA\u0005q1\u000f^1siRKW.Z:uC6\u0004X#A2\u0011\u0005i\"\u0017BA3,\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0010gR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA\u0005aQM\u001c3US6,7\u000f^1na\u0006iQM\u001c3US6,7\u000f^1na\u0002\n!\u0002^5nKj{g.Z%e+\u0005Y\u0007cA&m+&\u0011Q\u000e\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bE\u00148\u000f^;\u0011\u0005i\u0002\u0001\"B*\n\u0001\u0004)\u0006\"B1\n\u0001\u0004\u0019\u0007\"B4\n\u0001\u0004\u0019\u0007bB5\n!\u0003\u0005\ra\u001b\u000b\u0005c^D(\u0010C\u0003T\u0015\u0001\u0007Q\u000bC\u0003z\u0015\u0001\u00071-\u0001\u0005rk\u0006tG/\u001b;z\u0011\u0015Y(\u00021\u0001d\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018AC5oaV$H+\u001f9fgV\u0011\u0011\u0011\u0001\t\u0007\u0003\u0007\tY!!\u0005\u000f\t\u0005\u0015\u0011\u0011\u0002\b\u00041\u0006\u001d\u0011\"A'\n\u0005\rc\u0015\u0002BA\u0007\u0003\u001f\u00111aU3r\u0015\t\u0019E\n\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9bL\u0001\u0006if\u0004Xm]\u0005\u0005\u00037\t)B\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\"A!\u00111CA\u0012\u0013\u0011\t)#!\u0006\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAb^5uQRKW.\u001a.p]\u0016$2aRA\u0016\u0011\u0015Iw\u00021\u0001V\u00031QxN\\3JI&sWI^1m+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\tQLW.\u001a\u0006\u0003\u0003w\tAA[1wC&!\u0011qHA\u001b\u0005\u0019QvN\\3JI\"\u001a\u0001#a\u0011\u0011\u0007-\u000b)%C\u0002\u0002H1\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u00055\u00131KA,!\rY\u0015qJ\u0005\u0004\u0003#b%aA!os\"9\u0011QK\tA\u0002\u00055\u0013aC:uCJ$X*[2s_NDq!!\u0017\u0012\u0001\u0004\ti%A\u0005f]\u0012l\u0015n\u0019:pg\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003?\nY'!\u001e\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a,\u0003\u001d\u0019w\u000eZ3hK:LA!!\u001b\u0002d\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002nI\u0001\r!a\u001c\u0002\u0007\r$\b\u0010\u0005\u0003\u0002b\u0005E\u0014\u0002BA:\u0003G\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002xI\u0001\r!a\u0018\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006c\u0006}\u00141\u0011\u0005\u0007\u0003\u0003+\u0002\u0019A2\u0002\u000f9,w\u000fT3gi\"1\u0011QQ\u000bA\u0002\r\f\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0005r\u0003\u0017\u000bi)a$\u0002\u0012\"91K\u0006I\u0001\u0002\u0004)\u0006bB1\u0017!\u0003\u0005\ra\u0019\u0005\bOZ\u0001\n\u00111\u0001d\u0011\u001dIg\u0003%AA\u0002-\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0018*\u001aQ+!',\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!*M\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\u000byJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00020*\u001a1-!'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA\\U\rY\u0017\u0011T\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u000bl!!!1\u000b\t\u0005\r\u0017\u0011H\u0001\u0005Y\u0006tw-C\u0002_\u0003\u0003\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a3\u0011\u0007-\u000bi-C\u0002\u0002P2\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0014\u0002V\"I\u0011q[\u000f\u0002\u0002\u0003\u0007\u00111Z\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0007CBAp\u0003K\fi%\u0004\u0002\u0002b*\u0019\u00111\u001d'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0006\u0005(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!<\u0002tB\u00191*a<\n\u0007\u0005EHJA\u0004C_>dW-\u00198\t\u0013\u0005]w$!AA\u0002\u00055\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002n\u0006e\b\"CAlA\u0005\u0005\t\u0019AA'Q]\u0001\u0011Q B\u0002\u0005\u000b\u0011IAa\u0003\u0003\u0010\tE!Q\u0003B\f\u00057\u0011i\u0002E\u0002;\u0003\u007fL1A!\u0001,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0002\u0002\u0003Ozf)\u0016(D?\"*h.\u001b;-AM$\u0018M\u001d;US6,7\u000f^1na2\u0002SM\u001c3US6,7\u000f^1na&\u0002S\u0006I$fiN\u0004C\u000f[3!I&4g-\u001a:f]\u000e,\u0007EY3uo\u0016,g\u000e\t;iK\u0002\"\u0018.\\3ti\u0006l\u0007o\u001d\u0011aK:$G+[7fgR\fW\u000e\u001d1!C:$\u0007\u0005Y:uCJ$H+[7fgR\fW\u000e\u001d1!S:\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004SO\\5ug\u0002\u0012\u0017\u0010\t;sk:\u001c\u0017\r^5oO\u0002\"\b.\u001a\u0011ge\u0006\u001cG/[8oAA\f'\u000f\u001e\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018E\u0001B\u0007\u0003\u0011-%\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011v]&$\b%\f\u0011uQ&\u001c\b%\u001b8eS\u000e\fG/Z:!i\",\u0007%\u001e8jiN\u0004sN\u001a\u0011uQ\u0016\u0004C-\u001b4gKJ,gnY3!E\u0016$x/Z3oAQDW\rI4jm\u0016t\u0007\u0005^5nKN$\u0018-\u001c9t])\u0001\u0003\u0005\t\u0011!A\u0001\u00023+\u001e9q_J$X\r\u001a\u0011tiJLgn\u001a\u0011wC2,Xm\u001d\u0011pM\u0002\u0002WO\\5uA\u0002\n'/\u001a\u0011)G\u0006\u001cX\rI5og\u0016t7/\u001b;jm\u0016L#H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%W#B%\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\nV+\u0011*U\u000bJ\u0013\u0003%\f\u00114A5|g\u000e\u001e5t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b>sE\u000b\u0013\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012X\u000b\u0016[%\u0005I\u0017!o\u0001\"\u0017-_:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012E\u0003f\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0003jT+SE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5Ke*\u0016+FE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!EM+5i\u0014(EE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5KE\nT%T\u000b\u000e{e\n\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u0013\u000e\u0013vjU#D\u001f:#%E\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9![\u0001\n\u0005\u0005^5nKN$\u0018-\u001c9!o\"L7\r\u001b\u0011uQ\u0016\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!gV\u0014GO]1diN\u0004cM]8nA\u0001,g\u000e\u001a+j[\u0016\u001cH/Y7qA:R\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a8e)&lWm\u001d;b[B\u0004S\u0006I!!i&lWm\u001d;b[B\u0004cM]8nA]D\u0017n\u00195!i\",\u0007%\u001a=qe\u0016\u001c8/[8oAM,(\r\u001e:bGR\u001c\b\u0005Y:uCJ$H+[7fgR\fW\u000e\u001d1/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tM\u0011aa \u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q!{UK\u0015\u0017!i&lWm\u001d;b[B|f\u000e\u001e>(eA\u0012$'\f\u00193[E\n\u0004E\r\u0019;gAR\u0004\u0007M\u0014-AQLW.Z:uC6\u0004xL\u001c;{OI\u0002$GM\u00171e5\n$\u0007\t\u00195uM\u0002$\b\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015N\u001f:#\u0006\n\f\u0011uS6,7\u000f^1na~cGO_\u00143aI\u0012T\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004g\n\u0017!i&lWm\u001d;b[B|F\u000e\u001e>(eA\u0012$'\f\u00193[IB\u0004\u0005\r\u0019;aAR\u0004\u0007M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK*F\u0007>sE\t\f\u0011eCR,wE\r\u00193e5\u0002\u0014'\f\u00192O1\u0002C/[7fgR\fW\u000e]\u00143aI\nT&\r\u001a.gE\u0002#g\r\u001e6si*\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015Z\u000b\u0006\u0013F\u0006\t;j[\u0016\u001cH/Y7qOI\u0002\u0004\u0007M\u00171c5\u0002\u0014\u0007\t\u00192uA\u0012$\bM\u001a/cI\u001aD'\u000e\u001c(Y\u0001\"\u0018.\\3ti\u0006l\u0007o\n\u001a1cAj\u0003'M\u00171c\u0001\u0002\u0014G\u000f\u00193uA\u001ad&\r\u001a4iU2t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u00053\ta\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003 \u0005)1GL\u001a/a\u0005iA+[7fgR\fW\u000e\u001d#jM\u001a\u0004\"A\u000f\u0012\u0014\t\t\u00129\u0003\u0015\t\n\u0005S\u0011y#V2dWFl!Aa\u000b\u000b\u0007\t5B*A\u0004sk:$\u0018.\\3\n\t\tE\"1\u0006\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001B\u0012\u0003!!xn\u0015;sS:<GCAA_\u0003\u0015\t\u0007\u000f\u001d7z)%\t(Q\bB \u0005\u0003\u0012\u0019\u0005C\u0003TK\u0001\u0007Q\u000bC\u0003bK\u0001\u00071\rC\u0003hK\u0001\u00071\rC\u0004jKA\u0005\t\u0019A6\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003L\tM\u0003\u0003B&m\u0005\u001b\u0002ra\u0013B(+\u000e\u001c7.C\u0002\u0003R1\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003B+O\u0005\u0005\t\u0019A9\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003^A!\u0011q\u0018B0\u0013\u0011\u0011\t'!1\u0003\r=\u0013'.Z2u\u0001")
public class TimestampDiff
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
TimeZoneAwareExpression,
scala.Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression startTimestamp;
    private final Expression endTimestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampDiff$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampDiff timestampDiff) {
        return TimestampDiff$.MODULE$.unapply(timestampDiff);
    }

    public static Option<String> apply$default$4() {
        return TimestampDiff$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampDiff> tupled() {
        return TimestampDiff$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampDiff>>>> curried() {
        return TimestampDiff$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression startTimestamp() {
        return this.startTimestamp;
    }

    public Expression endTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.startTimestamp();
    }

    @Override
    public Expression right() {
        return this.endTimestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.endTimestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneIdInEval$lzycompute();
        }
        return this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object startMicros, Object endMicros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff(this.unit(), BoxesRunTime.unboxToLong((Object)startMicros), BoxesRunTime.unboxToLong((Object)endMicros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(s, e) -> new StringBuilder(24).append(dtu).append(".timestampDiff(\"").append(this.unit()).append("\", ").append((String)s).append(", ").append((String)e).append(", ").append(zid).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "timestampdiff";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((TraversableOnce)((SeqLike)this.children().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.sql(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringBuilder(2).append(this.prettyName()).append("(").append(childrenSQL).append(")").toString();
    }

    @Override
    public TimestampDiff withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampDiff copy(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        return new TimestampDiff(unit, startTimestamp, endTimestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.startTimestamp();
    }

    public Expression copy$default$3() {
        return this.endTimestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampDiff";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.startTimestamp();
            }
            case 2: {
                return this.endTimestamp();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampDiff;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampDiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampDiff timestampDiff = (TimestampDiff)x$1;
        String string = this.unit();
        String string2 = timestampDiff.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.startTimestamp();
        Expression expression2 = timestampDiff.startTimestamp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.endTimestamp();
        Expression expression4 = timestampDiff.endTimestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampDiff.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampDiff.canEqual(this)) return false;
        return true;
    }

    public TimestampDiff(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
    }

    public TimestampDiff(String unit, Expression quantity, Expression timestamp) {
        this(unit, quantity, timestamp, (Option<String>)None$.MODULE$);
    }
}

