/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.linalg.operators.HasOps$;
import breeze.storage.Zero$;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\b\u0010\u0001qA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005c!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0019Q\u0005\u0001\"\u0001\u0014'\"A1\r\u0001EC\u0002\u0013%A\r\u0003\u0005o\u0001!\u0015\r\u0011\"\u0003D\u0011!\u0001\b\u0001#b\u0001\n\u0013\t\b\u0002C:\u0001\u0011\u000b\u0007I\u0011\u0002;\t\u000bY\u0004A\u0011A<\t\u000bm\u0004A\u0011\u0001?\t\r}\u0004A\u0011BA\u0001\u0005QiU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f\u000f\u0006,8o]5b]*\u0011\u0001#E\u0001\rI&\u001cHO]5ckRLwN\u001c\u0006\u0003%M\tAa\u001d;bi*\u0011A#F\u0001\u0003[2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011bcBA\u0013+\u001d\t1\u0013&D\u0001(\u0015\tA3$\u0001\u0004=e>|GOP\u0005\u0002A%\u00111fH\u0001\ba\u0006\u001c7.Y4f\u0013\ticF\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002,?\u0005!Q.Z1o+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0014\u0003\u0019a\u0017N\\1mO&\u0011ag\r\u0002\u0007-\u0016\u001cGo\u001c:)\u0007\u0005Ad\b\u0005\u0002:y5\t!H\u0003\u0002<+\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005uR$!B*j]\u000e,\u0017%A \u0002\u000bIr\u0003G\f\u0019\u0002\u000b5,\u0017M\u001c\u0011)\u0007\tAd(A\u0002d_Z,\u0012\u0001\u0012\t\u0003e\u0015K!AR\u001a\u0003\r5\u000bGO]5yQ\r\u0019\u0001HP\u0001\u0005G>4\b\u0005K\u0002\u0005qy\na\u0001P5oSRtDc\u0001'O!B\u0011Q\nA\u0007\u0002\u001f!)q&\u0002a\u0001c!\u001aa\n\u000f \t\u000b\t+\u0001\u0019\u0001#)\u0007ACd\bK\u0002\u0006qy\"2\u0001\u0014+`\u0011\u0015yc\u00011\u0001V!\r1&\fX\u0007\u0002/*\u0011A\u0007\u0017\u0006\u00023\u00061!M]3fu\u0016L!aW,\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\t\u0003=uK!AX\u0010\u0003\r\u0011{WO\u00197f\u0011\u0015\u0011e\u00011\u0001a!\r1\u0016\rX\u0005\u0003E^\u00131\u0002R3og\u0016l\u0015\r\u001e:jq\u0006)A/\u001e9mKV\tQ\rE\u0003\u001fM\u0012c\u0006.\u0003\u0002h?\t1A+\u001e9mKN\u0002\"AM5\n\u0005m\u001b\u0004FA\u0004l!\tqB.\u0003\u0002n?\tIAO]1og&,g\u000e^\u0001\u0010e>|GoU5h[\u0006LeN^'bi\"\u0012\u0001b[\u0001\u0002kV\tA\f\u000b\u0002\nW\u0006\t\"o\\8u'&<W.Y%om6+H.T;\u0016\u0003!D#AC6\u0002\u0007A$g\r\u0006\u0002]q\")\u0011p\u0003a\u0001c\u0005\t\u0001\u0010K\u0002\fqy\na\u0001\\8ha\u00124GC\u0001/~\u0011\u0015IH\u00021\u00012Q\ra\u0001HP\u0001\u001dG\u0006d7-\u001e7bi\u0016\u001cuN^1sS\u0006t7-Z\"p]N$\u0018M\u001c;t+\t\t\u0019\u0001E\u0003\u001f\u0003\u000b\u0001G,C\u0002\u0002\b}\u0011a\u0001V;qY\u0016\u0014\u0004f\u0001\u0001\u0002\fA\u0019\u0011(!\u0004\n\u0007\u0005=!H\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000eK\u0002\u0001qy\u0002")
public class MultivariateGaussian
implements Serializable {
    private transient Tuple3<Matrix, Object, org.apache.spark.ml.linalg.DenseVector> tuple;
    private transient Matrix rootSigmaInvMat;
    private transient double u;
    private transient org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu;
    private final Vector mean;
    private final Matrix cov;
    private volatile transient byte bitmap$trans$0;

    public Vector mean() {
        return this.mean;
    }

    public Matrix cov() {
        return this.cov;
    }

    private Tuple3<Matrix, Object, org.apache.spark.ml.linalg.DenseVector> tuple$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Tuple2<DenseMatrix<Object>, Object> tuple2 = this.calculateCovarianceConstants();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DenseMatrix rootSigmaInv = (DenseMatrix)tuple2._1();
                double u = tuple2._2$mcD$sp();
                Tuple2 tuple22 = new Tuple2((Object)rootSigmaInv, (Object)BoxesRunTime.boxToDouble((double)u));
                Tuple2 tuple23 = tuple22;
                DenseMatrix rootSigmaInv2 = (DenseMatrix)tuple23._1();
                double u2 = tuple23._2$mcD$sp();
                Matrix rootSigmaInvMat = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)rootSigmaInv2);
                org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu = rootSigmaInvMat.multiply(this.mean());
                this.tuple = new Tuple3((Object)rootSigmaInvMat, (Object)BoxesRunTime.boxToDouble((double)u2), (Object)rootSigmaInvMulMu);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.tuple;
    }

    private Tuple3<Matrix, Object, org.apache.spark.ml.linalg.DenseVector> tuple() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tuple$lzycompute() : this.tuple;
    }

    private Matrix rootSigmaInvMat$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rootSigmaInvMat = (Matrix)this.tuple()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.rootSigmaInvMat;
    }

    private Matrix rootSigmaInvMat() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rootSigmaInvMat$lzycompute() : this.rootSigmaInvMat;
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.u = BoxesRunTime.unboxToDouble((Object)this.tuple()._2());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.u;
    }

    private double u() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.u$lzycompute() : this.u;
    }

    private org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.rootSigmaInvMulMu = (org.apache.spark.ml.linalg.DenseVector)this.tuple()._3();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.rootSigmaInvMulMu;
    }

    private org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.rootSigmaInvMulMu$lzycompute() : this.rootSigmaInvMulMu;
    }

    public double pdf(Vector x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(Vector x) {
        org.apache.spark.ml.linalg.DenseVector v = this.rootSigmaInvMulMu().copy();
        BLAS$.MODULE$.gemv(-1.0, this.rootSigmaInvMat(), x, 1.0, v);
        return this.u() - 0.5 * BLAS$.MODULE$.dot((Vector)v, (Vector)v);
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.cov().asBreeze().toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        Tuple2 tuple23 = tuple22;
        DenseVector d2 = (DenseVector)tuple23._1();
        DenseMatrix u2 = (DenseMatrix)tuple23._2();
        double tol = Utils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable)x$3 -> x$3 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable)v -> v > tol ? package$.MODULE$.sqrt(1.0 / v) : 0.0, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double()))).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl((ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()));
            tuple2 = new Tuple2(pinvS.$times(u2.t(HasOps$.MODULE$.canTranspose_DM()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mean().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mean, Matrix cov) {
        this.mean = mean;
        this.cov = cov;
        Predef$.MODULE$.require(cov.numCols() == cov.numRows(), (Function0 & Serializable)() -> "Covariance matrix must be square");
        Predef$.MODULE$.require(mean.size() == cov.numCols(), (Function0 & Serializable)() -> "Mean vector length must match covariance matrix size");
    }

    public MultivariateGaussian(DenseVector<Object> mean, DenseMatrix<Object> cov) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mean), Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)cov));
    }
}

