/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hive.ql.exec.spark.HiveBaseFunctionResultList;
import org.apache.hadoop.hive.ql.exec.spark.SparkReduceRecordHandler;
import org.apache.hadoop.hive.ql.io.HiveKey;
import scala.Tuple2;

public class HiveReduceFunctionResultList<V>
extends HiveBaseFunctionResultList<Tuple2<HiveKey, V>> {
    private static final long serialVersionUID = 1L;
    private final SparkReduceRecordHandler reduceRecordHandler;

    public HiveReduceFunctionResultList(Iterator<Tuple2<HiveKey, V>> inputIterator, SparkReduceRecordHandler reducer) {
        super(inputIterator);
        this.reduceRecordHandler = reducer;
    }

    @Override
    protected void processNextRecord(Tuple2<HiveKey, V> inputRecord) throws IOException {
        HiveKey key = (HiveKey)((Object)inputRecord._1());
        Object value = inputRecord._2();
        if (value instanceof Iterable) {
            Iterable values = (Iterable)value;
            this.reduceRecordHandler.processRow((Object)key, values.iterator());
        } else {
            this.reduceRecordHandler.processRow((Object)key, value);
        }
    }

    @Override
    protected boolean processingDone() {
        return false;
    }

    @Override
    protected void closeRecordProcessor() {
        this.reduceRecordHandler.close();
    }
}

