/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$ParseState$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eha\u0002\u001d:!\u0003\r\tA\u0012\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0005T\u0011\u001d9\u0006A1A\u0005\u0012MCq\u0001\u0017\u0001C\u0002\u0013E1\u000bC\u0004Z\u0001\t\u0007I\u0011C*\t\u000fi\u0003!\u0019!C\t'\"91\f\u0001b\u0001\n\u001b\u0019\u0006\"\u0002/\u0001\t\u0003i\u0006\"\u0002/\u0001\t\u0003A\u0007\"B8\u0001\t\u0003\u0001\b\"B8\u0001\t\u0003I\b\"\u0002?\u0001\t\u0003i\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\u0000\u0001!\t\"!!\t\u0013\u0005\u001d\u0005A1A\u0005\u0012\u0005%\u0005\"CAF\u0001\t\u0007I\u0011CAE\u0011%\ti\t\u0001b\u0001\n#\tI\tC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0005\u0002\n\"I\u0011\u0011\u0013\u0001C\u0002\u0013E\u0011\u0011\u0012\u0005\n\u0003'\u0003!\u0019!C\t\u0003\u0013C\u0011\"!&\u0001\u0005\u0004%\t\"!#\t\u0013\u0005]\u0005A1A\u0005\u0012\u0005%\u0005\"CAM\u0001\t\u0007I\u0011CAE\u0011%\tY\n\u0001b\u0001\n#\tI\tC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0005\u0002\n\u001e9\u0011q\u0014\u0001\t\n\u0005\u0005faBAS\u0001!%\u0011q\u0015\u0005\b\u0003_sB\u0011AAY\u000b\u0019\t)K\b\u0001\u00024\"I\u00111\u0018\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u007fs\u0002\u0015!\u0003\u00024\"I\u0011\u0011\u0019\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u0007t\u0002\u0015!\u0003\u00024\"I\u0011Q\u0019\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u000ft\u0002\u0015!\u0003\u00024\"I\u0011\u0011\u001a\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u0017t\u0002\u0015!\u0003\u00024\"I\u0011Q\u001a\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u001ft\u0002\u0015!\u0003\u00024\"I\u0011\u0011\u001b\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003't\u0002\u0015!\u0003\u00024\"I\u0011Q\u001b\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003/t\u0002\u0015!\u0003\u00024\"I\u0011\u0011\u001c\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u00037t\u0002\u0015!\u0003\u00024\"I\u0011Q\u001c\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003?t\u0002\u0015!\u0003\u00024\"I\u0011\u0011\u001d\u0010C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003Gt\u0002\u0015!\u0003\u00024\u001e9\u0011Q]\u001d\t\u0002\u0005\u001dhA\u0002\u001d:\u0011\u0003\tY\u000fC\u0004\u00020Z\"\t!a<\u0003%M\u0003\u0018M]6J]R,'O^1m+RLGn\u001d\u0006\u0003um\nA!\u001e;jY*\u0011A(P\u0001\tG\u0006$\u0018\r\\=ti*\u0011ahP\u0001\u0004gFd'B\u0001!B\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\u0004\u0001M\u0011\u0001a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005y\u0005C\u0001%Q\u0013\t\t\u0016J\u0001\u0003V]&$\u0018aB'B1~#\u0015)W\u000b\u0002)B\u0011\u0001*V\u0005\u0003-&\u0013A\u0001T8oO\u0006AQ*\u0011-`\u0011>+&+\u0001\u0006N\u0003b{V*\u0013(V)\u0016\u000b!\"T!Y?N+5i\u0014(E\u0003)i\u0015JT0T\u000b\u000e{e\nR\u0001\u0013[&tG)\u001e:bi&|gnU3d_:$7/\u0001\tekJ\fG/[8o)>l\u0015n\u0019:pgR\u0011AK\u0018\u0005\u0006?\"\u0001\r\u0001Y\u0001\tIV\u0014\u0018\r^5p]B\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\u0005i&lWMC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0014'\u0001\u0003#ve\u0006$\u0018n\u001c8\u0015\u0007QK'\u000eC\u0003`\u0013\u0001\u0007\u0001\rC\u0003l\u0013\u0001\u0007A.\u0001\u0005f]\u00124\u0015.\u001a7e!\tAU.\u0003\u0002o\u0013\n!!)\u001f;f\u00039\u0001XM]5pIR{Wj\u001c8uQN$\"!\u001d;\u0011\u0005!\u0013\u0018BA:J\u0005\rIe\u000e\u001e\u0005\u0006k*\u0001\rA^\u0001\u0007a\u0016\u0014\u0018n\u001c3\u0011\u0005\u0005<\u0018B\u0001=c\u0005\u0019\u0001VM]5pIR\u0019\u0011O_>\t\u000bU\\\u0001\u0019\u0001<\t\u000b-\\\u0001\u0019\u00017\u0002!5L7M]8t)>$UO]1uS>tGC\u00011\u007f\u0011\u0015yH\u00021\u0001U\u0003\u0019i\u0017n\u0019:pg\u0006qQn\u001c8uQN$v\u000eU3sS>$Gc\u0001<\u0002\u0006!1\u0011qA\u0007A\u0002E\fa!\\8oi\"\u001c\u0018\u0001E:ue&tw\rV8J]R,'O^1m)\u0011\ti!!\b\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005)A/\u001f9fg*\u0019\u0011qC \u0002\rUt7/\u00194f\u0013\u0011\tY\"!\u0005\u0003!\r\u000bG.\u001a8eCJLe\u000e^3sm\u0006d\u0007bBA\u0010\u001d\u0001\u0007\u0011\u0011E\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u001f\t\u0019#\u0003\u0003\u0002&\u0005E!AC+U\rb\u001aFO]5oO\u0006IBo\\-fCJluN\u001c;i\u0013:$XM\u001d<bYN#(/\u001b8h))\tY#!\u0011\u0002D\u00055\u0014\u0011\u000f\t\u0005\u0003[\tYD\u0004\u0003\u00020\u0005]\u0002cAA\u0019\u00136\u0011\u00111\u0007\u0006\u0004\u0003k)\u0015A\u0002\u001fs_>$h(C\u0002\u0002:%\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003\u007f\u0011aa\u0015;sS:<'bAA\u001d\u0013\"1\u0011qA\bA\u0002EDq!!\u0012\u0010\u0001\u0004\t9%A\u0003tifdW\r\u0005\u0003\u0002J\u0005\u001dd\u0002BA&\u0003GrA!!\u0014\u0002b9!\u0011qJA0\u001d\u0011\t\t&!\u0018\u000f\t\u0005M\u00131\f\b\u0005\u0003+\nIF\u0004\u0003\u00022\u0005]\u0013\"\u0001#\n\u0005\t\u001b\u0015B\u0001!B\u0013\tqt(\u0003\u0002={%\u0011!hO\u0005\u0004\u0003KJ\u0014\u0001F%oi\u0016\u0014h/\u00197TiJLgnZ*us2,7/\u0003\u0003\u0002j\u0005-$!D%oi\u0016\u0014h/\u00197TifdWMC\u0002\u0002feBa!a\u001c\u0010\u0001\u0004a\u0017AC:uCJ$h)[3mI\")1n\u0004a\u0001Y\u00069Bo\u001c#bsRKW.Z%oi\u0016\u0014h/\u00197TiJLgn\u001a\u000b\u000b\u0003W\t9(!\u001f\u0002|\u0005u\u0004\"B@\u0011\u0001\u0004!\u0006bBA#!\u0001\u0007\u0011q\t\u0005\u0007\u0003_\u0002\u0002\u0019\u00017\t\u000b-\u0004\u0002\u0019\u00017\u0002\u0015Ut\u0017\u000e\u001e+p+R4\u0007\b\u0006\u0003\u0002\"\u0005\r\u0005bBAC#\u0001\u0007\u00111F\u0001\u0005k:LG/A\u0006j]R,'O^1m'R\u0014XCAA\u0011\u0003\u001dIX-\u0019:TiJ\f\u0001\"\\8oi\"\u001cFO]\u0001\bo\u0016,7n\u0015;s\u0003\u0019!\u0017-_*ue\u00069\u0001n\\;s'R\u0014\u0018!C7j]V$Xm\u0015;s\u0003%\u0019XmY8oIN#(/A\u0005nS2d\u0017n]*ue\u0006IQ.[2s_N\u001cFO]\u0001\t]\u0006twn]*ue\u0006Q\u0001+\u0019:tKN#\u0018\r^3\u0011\u0007\u0005\rf$D\u0001\u0001\u0005)\u0001\u0016M]:f'R\fG/Z\n\u0004=\u0005%\u0006c\u0001%\u0002,&\u0019\u0011QV%\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u0005\u0006\u0003BA[\u0003ok\u0011AH\u0005\u0005\u0003s\u000bYKA\u0003WC2,X-\u0001\u0004Q%\u00163\u0015\nW\u000b\u0003\u0003g\u000bq\u0001\u0015*F\r&C\u0006%\u0001\tU%&kuLQ#G\u001fJ+ulU%H\u001d\u0006\tBKU%N?\n+ei\u0014*F?NKuI\u0014\u0011\u0002\tMKuIT\u0001\u0006'&;e\nI\u0001\u0012)JKUj\u0018\"F\r>\u0013Vi\u0018,B\u0019V+\u0015A\u0005+S\u00136{&)\u0012$P%\u0016{f+\u0011'V\u000b\u0002\nQAV!M+\u0016\u000baAV!M+\u0016\u0003\u0013!\u0006,B\u0019V+uL\u0012*B\u0007RKuJT!M?B\u000b%\u000bV\u0001\u0017-\u0006cU+R0G%\u0006\u001bE+S(O\u00032{\u0006+\u0011*UA\u0005\u0001BKU%N?\n+ei\u0014*F?Vs\u0015\nV\u0001\u0012)JKUj\u0018\"F\r>\u0013ViX+O\u0013R\u0003\u0013AC+O\u0013R{&)R$J\u001d\u0006YQKT%U?\n+u)\u0013(!\u0003-)f*\u0013+`'V3e)\u0013-\u0002\u0019Us\u0015\nV0T+\u001a3\u0015\n\u0017\u0011\u0002\u0011Us\u0015\nV0F\u001d\u0012\u000b\u0011\"\u0016(J)~+e\n\u0012\u0011\u0002%M\u0003\u0018M]6J]R,'O^1m+RLGn\u001d\t\u0004\u0003S4T\"A\u001d\u0014\tY:\u0015Q\u001e\t\u0004\u0003S\u0004ACAAt\u0001")
public interface SparkIntervalUtils {
    public SparkIntervalUtils$ParseState$ org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState();

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_DAY_$eq(long var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_HOUR_$eq(long var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_MINUTE_$eq(long var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_SECOND_$eq(long var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MIN_SECOND_$eq(long var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds_$eq(long var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$intervalStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$yearStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$monthStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$weekStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$dayStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$hourStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$minuteStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$secondStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$millisStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$microsStr_$eq(UTF8String var1);

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$nanosStr_$eq(UTF8String var1);

    public long MAX_DAY();

    public long MAX_HOUR();

    public long MAX_MINUTE();

    public long MAX_SECOND();

    public long MIN_SECOND();

    public long org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds();

    public static /* synthetic */ long durationToMicros$(SparkIntervalUtils $this, Duration duration) {
        return $this.durationToMicros(duration);
    }

    default public long durationToMicros(Duration duration) {
        return this.durationToMicros(duration, DayTimeIntervalType$.MODULE$.SECOND());
    }

    public static /* synthetic */ long durationToMicros$(SparkIntervalUtils $this, Duration duration, byte endField) {
        return $this.durationToMicros(duration, endField);
    }

    default public long durationToMicros(Duration duration, byte endField) {
        long l;
        long l2;
        long seconds = duration.getSeconds();
        if (seconds == this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds()) {
            long microsInSeconds = (this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds() + 1L) * 1000000L;
            int nanoAdjustment = duration.getNano();
            Predef$.MODULE$.assert(0 <= nanoAdjustment && (long)nanoAdjustment < 1000000000L, (Function0 & Serializable)() -> "Duration.getNano() must return the adjustment to the seconds field in the range from 0 to 999999999 nanoseconds, inclusive.");
            l2 = Math.addExact(microsInSeconds, ((long)nanoAdjustment - 1000000000L) / 1000L);
        } else {
            long microsInSeconds = Math.multiplyExact(seconds, 1000000L);
            l2 = Math.addExact(microsInSeconds, (long)duration.getNano() / 1000L);
        }
        long micros = l2;
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            l = micros - micros % 86400000000L;
        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            l = micros - micros % 3600000000L;
        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            l = micros - micros % 60000000L;
        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            l = micros;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return l;
    }

    public static /* synthetic */ int periodToMonths$(SparkIntervalUtils $this, Period period) {
        return $this.periodToMonths(period);
    }

    default public int periodToMonths(Period period) {
        return this.periodToMonths(period, YearMonthIntervalType$.MODULE$.MONTH());
    }

    public static /* synthetic */ int periodToMonths$(SparkIntervalUtils $this, Period period, byte endField) {
        return $this.periodToMonths(period, endField);
    }

    default public int periodToMonths(Period period, byte endField) {
        int monthsInYears = Math.multiplyExact(period.getYears(), 12);
        int months = Math.addExact(monthsInYears, period.getMonths());
        return endField == YearMonthIntervalType$.MODULE$.YEAR() ? months - months % 12 : months;
    }

    public static /* synthetic */ Duration microsToDuration$(SparkIntervalUtils $this, long micros) {
        return $this.microsToDuration(micros);
    }

    default public Duration microsToDuration(long micros) {
        return Duration.of(micros, ChronoUnit.MICROS);
    }

    public static /* synthetic */ Period monthsToPeriod$(SparkIntervalUtils $this, int months) {
        return $this.monthsToPeriod(months);
    }

    default public Period monthsToPeriod(int months) {
        return Period.ofMonths(months).normalized();
    }

    public static /* synthetic */ CalendarInterval stringToInterval$(SparkIntervalUtils $this, UTF8String input) {
        return $this.stringToInterval(input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public CalendarInterval stringToInterval(UTF8String input) {
        boolean bl;
        if (input == null) {
            throw SparkIntervalUtils.throwIAE$1("interval string cannot be null", SparkIntervalUtils.throwIAE$default$2$1(), input);
        }
        UTF8String s = input.trimAll().toLowerCase();
        byte[] bytes = s.getBytes();
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(bytes))) {
            throw SparkIntervalUtils.throwIAE$1("interval string cannot be empty", SparkIntervalUtils.throwIAE$default$2$1(), input);
        }
        ObjectRef state = ObjectRef.create((Object)this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().PREFIX());
        IntRef i = IntRef.create((int)0);
        long currentValue = 0L;
        boolean isNegative = false;
        int months = 0;
        int days = 0;
        long microseconds = 0L;
        int fractionScale = 0;
        int initialFractionScale = (int)100000000L;
        int fraction = 0;
        boolean pointPrefixed = false;
        while (i.elem < bytes.length) {
            BoxedUnit boxedUnit;
            byte b = bytes[i.elem];
            Enumeration.Value value = (Enumeration.Value)state.elem;
            Enumeration.Value value2 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().PREFIX();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                if (s.startsWith(this.intervalStr())) {
                    if (s.numBytes() == this.intervalStr().numBytes()) {
                        throw SparkIntervalUtils.throwIAE$1("interval string cannot be empty", SparkIntervalUtils.throwIAE$default$2$1(), input);
                    }
                    if (!Character.isWhitespace(bytes[i.elem + this.intervalStr().numBytes()])) {
                        throw SparkIntervalUtils.throwIAE$1(new StringBuilder(24).append("invalid interval prefix ").append(SparkIntervalUtils.currentWord$1(s, i)).toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                    }
                    i.elem += this.intervalStr().numBytes() + 1;
                }
                state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_SIGN();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value4 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_SIGN();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                SparkIntervalUtils.trimToNextState$1(b, this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().SIGN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value6 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().SIGN();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                BoxedUnit boxedUnit2;
                currentValue = 0L;
                fraction = 0;
                state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_VALUE();
                fractionScale = -1;
                pointPrefixed = false;
                byte by = b;
                if (45 == by) {
                    isNegative = true;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (43 == by) {
                    isNegative = false;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (48 <= b && b <= 57) {
                    isNegative = false;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(22).append("unrecognized number '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                    isNegative = false;
                    fractionScale = initialFractionScale;
                    pointPrefixed = true;
                    ++i.elem;
                    state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().VALUE_FRACTIONAL_PART();
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value8 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_VALUE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                SparkIntervalUtils.trimToNextState$1(b, this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().VALUE(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value10 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().VALUE();
            Enumeration.Value value11 = value;
            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                BoxedUnit boxedUnit3;
                byte by = b;
                if (48 <= b && b <= 57) {
                    BoxedUnit boxedUnit4;
                    try {
                        currentValue = Math.addExact(Math.multiplyExact(10L, currentValue), (long)(b - 48));
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    catch (ArithmeticException e) {
                        throw SparkIntervalUtils.throwIAE$1(e.getMessage(), e, input);
                    }
                    boxedUnit3 = boxedUnit4;
                } else if (Character.isWhitespace(b)) {
                    state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_UNIT();
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(16).append("invalid value '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                    fractionScale = initialFractionScale;
                    state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().VALUE_FRACTIONAL_PART();
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value12 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().VALUE_FRACTIONAL_PART();
            Enumeration.Value value13 = value;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                if (48 <= b && b <= 57 && fractionScale > 0) {
                    fraction += (b - 48) * fractionScale;
                    fractionScale /= 10;
                } else {
                    if (!Character.isWhitespace(b) || pointPrefixed && fractionScale >= initialFractionScale) throw 48 <= b && b <= 57 ? SparkIntervalUtils.throwIAE$1(new StringBuilder(0).append(new StringBuilder(57).append("interval can only support nanosecond precision, '").append(SparkIntervalUtils.currentWord$1(s, i)).append("' is out").toString()).append(" of range").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input) : SparkIntervalUtils.throwIAE$1(new StringBuilder(16).append("invalid value '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                    fraction /= (int)1000L;
                    state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_UNIT();
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value14 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_UNIT();
            Enumeration.Value value15 = value;
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                SparkIntervalUtils.trimToNextState$1(b, this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_BEGIN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value16 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_BEGIN();
            Enumeration.Value value17 = value;
            if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                if (b != 115 && fractionScale >= 0) {
                    throw SparkIntervalUtils.throwIAE$1(new StringBuilder(30).append("'").append(SparkIntervalUtils.currentWord$1(s, i)).append("' cannot have fractional part").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                }
                if (isNegative) {
                    currentValue = -currentValue;
                    fraction = -fraction;
                }
                try {
                    byte by = b;
                    switch (by) {
                        case 121: {
                            if (!s.matchAt(this.yearStr(), i.elem)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                            long monthsInYears = Math.multiplyExact(12L, currentValue);
                            months = Math.toIntExact(Math.addExact((long)months, monthsInYears));
                            i.elem += this.yearStr().numBytes();
                            break;
                        }
                        case 119: {
                            if (!s.matchAt(this.weekStr(), i.elem)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                            long daysInWeeks = Math.multiplyExact(7L, currentValue);
                            days = Math.toIntExact(Math.addExact((long)days, daysInWeeks));
                            i.elem += this.weekStr().numBytes();
                            break;
                        }
                        case 100: {
                            if (!s.matchAt(this.dayStr(), i.elem)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                            days = Math.addExact(days, Math.toIntExact(currentValue));
                            i.elem += this.dayStr().numBytes();
                            break;
                        }
                        case 104: {
                            if (!s.matchAt(this.hourStr(), i.elem)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                            long hoursUs = Math.multiplyExact(currentValue, 3600000000L);
                            microseconds = Math.addExact(microseconds, hoursUs);
                            i.elem += this.hourStr().numBytes();
                            break;
                        }
                        case 115: {
                            if (!s.matchAt(this.secondStr(), i.elem)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                            long secondsUs = Math.multiplyExact(currentValue, 1000000L);
                            microseconds = Math.addExact(Math.addExact(microseconds, secondsUs), (long)fraction);
                            i.elem += this.secondStr().numBytes();
                            break;
                        }
                        case 109: {
                            if (s.matchAt(this.monthStr(), i.elem)) {
                                months = Math.addExact(months, Math.toIntExact(currentValue));
                                i.elem += this.monthStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.minuteStr(), i.elem)) {
                                long minutesUs = Math.multiplyExact(currentValue, 60000000L);
                                microseconds = Math.addExact(microseconds, minutesUs);
                                i.elem += this.minuteStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.millisStr(), i.elem)) {
                                long millisUs = SparkDateTimeUtils$.MODULE$.millisToMicros(currentValue);
                                microseconds = Math.addExact(microseconds, millisUs);
                                i.elem += this.millisStr().numBytes();
                                break;
                            }
                            if (!s.matchAt(this.microsStr(), i.elem)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                            microseconds = Math.addExact(microseconds, currentValue);
                            i.elem += this.microsStr().numBytes();
                            break;
                        }
                        default: {
                            throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                        }
                    }
                }
                catch (ArithmeticException e) {
                    throw SparkIntervalUtils.throwIAE$1(e.getMessage(), e, input);
                }
                state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_SUFFIX();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value18 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_SUFFIX();
            Enumeration.Value value19 = value;
            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                byte by = b;
                switch (by) {
                    case 115: {
                        state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_END();
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(b)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
                        state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_SIGN();
                        break;
                    }
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value20 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_END();
            Enumeration.Value value21 = value;
            if (value20 == null) {
                if (value21 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value20.equals(value21)) throw new MatchError((Object)value);
            if (!Character.isWhitespace(b)) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
            ++i.elem;
            state.elem = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_SIGN();
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = (Enumeration.Value)state.elem;
        Enumeration.Value value22 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_SUFFIX();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            bl = true;
        } else {
            Enumeration.Value value24 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().UNIT_END();
            Enumeration.Value value25 = value;
            if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                bl = true;
            } else {
                Enumeration.Value value26 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_SIGN();
                Enumeration.Value value27 = value;
                bl = !(value26 != null ? !value26.equals(value27) : value27 != null);
            }
        }
        if (!bl) {
            boolean bl2;
            Enumeration.Value value28 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().TRIM_BEFORE_VALUE();
            Enumeration.Value value29 = value;
            if (value28 == null) {
                if (value29 == null) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(36).append("expect a number after '").append(SparkIntervalUtils.currentWord$1(s, i)).append("' but hit EOL").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
            } else if (value28.equals(value29)) {
                throw SparkIntervalUtils.throwIAE$1(new StringBuilder(36).append("expect a number after '").append(SparkIntervalUtils.currentWord$1(s, i)).append("' but hit EOL").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
            }
            Enumeration.Value value30 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().VALUE();
            Enumeration.Value value31 = value;
            if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
                bl2 = true;
            } else {
                Enumeration.Value value32 = this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState().VALUE_FRACTIONAL_PART();
                Enumeration.Value value33 = value;
                bl2 = !(value32 != null ? !value32.equals(value33) : value33 != null);
            }
            if (!bl2) throw SparkIntervalUtils.throwIAE$1(new StringBuilder(29).append("unknown error when parsing '").append(SparkIntervalUtils.currentWord$1(s, i)).append("'").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
            throw SparkIntervalUtils.throwIAE$1(new StringBuilder(39).append("expect a unit name after '").append(SparkIntervalUtils.currentWord$1(s, i)).append("' but hit EOL").toString(), SparkIntervalUtils.throwIAE$default$2$1(), input);
        }
        CalendarInterval calendarInterval = new CalendarInterval(months, days, microseconds);
        return calendarInterval;
    }

    public static /* synthetic */ String toYearMonthIntervalString$(SparkIntervalUtils $this, int months, Enumeration.Value style, byte startField, byte endField) {
        return $this.toYearMonthIntervalString(months, style, startField, endField);
    }

    default public String toYearMonthIntervalString(int months, Enumeration.Value style, byte startField, byte endField) {
        String string;
        String sign = "";
        long absMonths = months;
        if (months < 0) {
            sign = "-";
            absMonths = -absMonths;
        }
        String year = new StringBuilder(0).append(sign).append(absMonths / 12L).toString();
        String yearAndMonth = new StringBuilder(1).append(year).append("-").append(absMonths % 12L).toString();
        Enumeration.Value value = style;
        Enumeration.Value value2 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            scala.collection.mutable.StringBuilder stringBuilder;
            scala.collection.mutable.StringBuilder formatBuilder = new scala.collection.mutable.StringBuilder("INTERVAL '");
            if (startField == endField) {
                scala.collection.mutable.StringBuilder stringBuilder2;
                byte by = startField;
                if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
                    stringBuilder2 = formatBuilder.append(new StringBuilder(6).append(year).append("' YEAR").toString());
                } else if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
                    stringBuilder2 = formatBuilder.append(new StringBuilder(7).append(months).append("' MONTH").toString());
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
                stringBuilder = stringBuilder2;
            } else {
                stringBuilder = formatBuilder.append(new StringBuilder(15).append(yearAndMonth).append("' YEAR TO MONTH").toString());
            }
            string = formatBuilder.toString();
        } else {
            Enumeration.Value value4 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = String.valueOf(yearAndMonth);
            } else {
                throw new MatchError((Object)value);
            }
        }
        return string;
    }

    public static /* synthetic */ String toDayTimeIntervalString$(SparkIntervalUtils $this, long micros, Enumeration.Value style, byte startField, byte endField) {
        return $this.toDayTimeIntervalString(micros, style, startField, endField);
    }

    default public String toDayTimeIntervalString(long micros, Enumeration.Value style, byte startField, byte endField) {
        String string;
        String sign = "";
        long rest = micros;
        String from = DayTimeIntervalType$.MODULE$.fieldToString(startField).toUpperCase();
        String to = DayTimeIntervalType$.MODULE$.fieldToString(endField).toUpperCase();
        String prefix = "INTERVAL '";
        String postfix = new StringBuilder(2).append("' ").append((Object)(startField == endField ? from : new StringBuilder(4).append(from).append(" TO ").append(to).toString())).toString();
        if (micros < 0L) {
            if (micros == Long.MIN_VALUE) {
                String string2;
                String baseStr = "-106751991 04:00:54.775808000";
                Enumeration.Value value = style;
                Enumeration.Value value2 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    String string3;
                    String string4;
                    byte by = startField;
                    if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                        string4 = new StringBuilder(1).append("-").append(this.MAX_DAY()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                        string4 = new StringBuilder(1).append("-").append(this.MAX_HOUR()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                        string4 = new StringBuilder(1).append("-").append(this.MAX_MINUTE()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                        string4 = new StringBuilder(8).append("-").append(this.MAX_SECOND()).append(".775808").toString();
                    } else {
                        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                    }
                    String firstStr = string4;
                    if (startField == endField) {
                        string3 = "";
                    } else {
                        int n;
                        int n2;
                        byte by2 = startField;
                        if (DayTimeIntervalType$.MODULE$.DAY() == by2) {
                            n2 = 10;
                        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by2) {
                            n2 = 13;
                        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by2) {
                            n2 = 16;
                        } else {
                            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
                        }
                        int substrStart = n2;
                        byte by3 = endField;
                        if (DayTimeIntervalType$.MODULE$.HOUR() == by3) {
                            n = 13;
                        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by3) {
                            n = 16;
                        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by3) {
                            n = 26;
                        } else {
                            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by3));
                        }
                        int substrEnd = n;
                        string3 = baseStr.substring(substrStart, substrEnd);
                    }
                    String followingStr = string3;
                    string2 = new StringBuilder(0).append(prefix).append(firstStr).append(followingStr).append(postfix).toString();
                } else {
                    Enumeration.Value value4 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        string2 = baseStr;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
                String minIntervalString = string2;
                return minIntervalString;
            }
            sign = "-";
            rest = -rest;
        }
        Enumeration.Value value = style;
        Enumeration.Value value6 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            scala.collection.mutable.StringBuilder formatBuilder = new scala.collection.mutable.StringBuilder(sign);
            ArrayBuffer formatArgs = new ArrayBuffer();
            byte by = startField;
            if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                formatBuilder.append(rest / 86400000000L);
                rest %= 86400000000L;
                boxedUnit2 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                formatBuilder.append("%02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 3600000000L)));
                rest %= 3600000000L;
                boxedUnit2 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                formatBuilder.append("%02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 60000000L)));
                rest %= 60000000L;
                boxedUnit2 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                String leadZero = rest < 10000000L ? "0" : "";
                boxedUnit2 = formatBuilder.append(new StringBuilder(0).append(String.valueOf(leadZero)).append(String.valueOf(BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString())).toString());
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            if (startField < DayTimeIntervalType$.MODULE$.HOUR() && DayTimeIntervalType$.MODULE$.HOUR() <= endField) {
                formatBuilder.append(" %02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 3600000000L)));
                rest %= 3600000000L;
            }
            if (startField < DayTimeIntervalType$.MODULE$.MINUTE() && DayTimeIntervalType$.MODULE$.MINUTE() <= endField) {
                formatBuilder.append(":%02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 60000000L)));
                rest %= 60000000L;
            }
            if (startField < DayTimeIntervalType$.MODULE$.SECOND() && DayTimeIntervalType$.MODULE$.SECOND() <= endField) {
                String leadZero = rest < 10000000L ? "0" : "";
                boxedUnit = formatBuilder.append(new StringBuilder(1).append(":").append(leadZero).append(BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString()).toString());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = new StringBuilder(0).append(prefix).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(formatBuilder.toString()), formatArgs.toSeq())).append(postfix).toString();
        } else {
            Enumeration.Value value8 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                long secondsWithFraction = rest % 60000000L;
                long minutes = (rest /= 60000000L) % 60L;
                long hours = (rest /= 60L) % 24L;
                long days = rest / 24L;
                long seconds = secondsWithFraction / 1000000L;
                long nanos = secondsWithFraction % 1000000L * 1000L;
                String arg$macro$1 = sign;
                Long arg$macro$2 = BoxesRunTime.boxToLong((long)days);
                long arg$macro$3 = hours;
                long arg$macro$4 = minutes;
                long arg$macro$5 = seconds;
                long arg$macro$6 = nanos;
                string = StringOps$.MODULE$.format$extension("%s%s %02d:%02d:%02d.%09d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToLong((long)arg$macro$3), BoxesRunTime.boxToLong((long)arg$macro$4), BoxesRunTime.boxToLong((long)arg$macro$5), BoxesRunTime.boxToLong((long)arg$macro$6)}));
            } else {
                throw new MatchError((Object)value);
            }
        }
        String intervalString = string;
        return intervalString;
    }

    public static /* synthetic */ UTF8String unitToUtf8$(SparkIntervalUtils $this, String unit) {
        return $this.unitToUtf8(unit);
    }

    default public UTF8String unitToUtf8(String unit) {
        return UTF8String.fromString((String)unit);
    }

    public UTF8String intervalStr();

    public UTF8String yearStr();

    public UTF8String monthStr();

    public UTF8String weekStr();

    public UTF8String dayStr();

    public UTF8String hourStr();

    public UTF8String minuteStr();

    public UTF8String secondStr();

    public UTF8String millisStr();

    public UTF8String microsStr();

    public UTF8String nanosStr();

    private static Nothing$ throwIAE$1(String msg, Exception e, UTF8String input$1) {
        throw new IllegalArgumentException(new StringBuilder(30).append("Error parsing '").append(input$1).append("' to interval, ").append(msg).toString(), e);
    }

    private static Exception throwIAE$default$2$1() {
        return null;
    }

    private static void trimToNextState$1(byte b, Enumeration.Value next, IntRef i$1, ObjectRef state$1) {
        if (Character.isWhitespace(b)) {
            ++i$1.elem;
        } else {
            state$1.elem = next;
        }
    }

    private static String currentWord$1(UTF8String s$1, IntRef i$1) {
        String sep = "\\s+";
        String[] strings = s$1.toString().split(sep);
        int lenRight = s$1.substring(i$1.elem, s$1.numBytes()).toString().split(sep).length;
        return strings[strings.length - lenRight];
    }

    public static void $init$(SparkIntervalUtils $this) {
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_DAY_$eq(106751991L);
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_HOUR_$eq(2562047788L);
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_MINUTE_$eq(153722867280L);
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_SECOND_$eq(9223372036854L);
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MIN_SECOND_$eq(-9223372036854L);
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds_$eq(Math.floorDiv(Long.MIN_VALUE, 1000000L));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$intervalStr_$eq($this.unitToUtf8("interval"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$yearStr_$eq($this.unitToUtf8("year"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$monthStr_$eq($this.unitToUtf8("month"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$weekStr_$eq($this.unitToUtf8("week"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$dayStr_$eq($this.unitToUtf8("day"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$hourStr_$eq($this.unitToUtf8("hour"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$minuteStr_$eq($this.unitToUtf8("minute"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$secondStr_$eq($this.unitToUtf8("second"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$millisStr_$eq($this.unitToUtf8("millisecond"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$microsStr_$eq($this.unitToUtf8("microsecond"));
        $this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$nanosStr_$eq($this.unitToUtf8("nanosecond"));
    }
}

