/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetric$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.util.AccumulatorContext$;
import org.apache.spark.util.Utils$;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SQLMetrics$ {
    public static final SQLMetrics$ MODULE$ = new SQLMetrics$();
    private static final String SUM_METRIC = "sum";
    private static final String SIZE_METRIC = "size";
    private static final String TIMING_METRIC = "timing";
    private static final String NS_TIMING_METRIC = "nsTiming";
    private static final String AVERAGE_METRIC = "average";
    private static final int baseForAvgMetric = 10;
    private static final Some<String> cachedSQLAccumIdentifier = new Some((Object)AccumulatorContext$.MODULE$.SQL_ACCUM_IDENTIFIER());
    private static final LoadingCache<String, Option<String>> metricsCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Option<String>>(){

        public Option<String> load(String name) {
            return Option$.MODULE$.apply((Object)name);
        }
    });
    private static final String METRICS_NAME_SUFFIX = "(min, med, max (stageId: taskId))";

    private String SUM_METRIC() {
        return SUM_METRIC;
    }

    private String SIZE_METRIC() {
        return SIZE_METRIC;
    }

    private String TIMING_METRIC() {
        return TIMING_METRIC;
    }

    private String NS_TIMING_METRIC() {
        return NS_TIMING_METRIC;
    }

    private String AVERAGE_METRIC() {
        return AVERAGE_METRIC;
    }

    private int baseForAvgMetric() {
        return baseForAvgMetric;
    }

    public Some<String> cachedSQLAccumIdentifier() {
        return cachedSQLAccumIdentifier;
    }

    private LoadingCache<String, Option<String>> metricsCache() {
        return metricsCache;
    }

    public void setDoubleForAverageMetrics(SQLMetric metric, double v) {
        String string = metric.metricType();
        String string2 = this.AVERAGE_METRIC();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> new StringBuilder(48).append("Can't set a double to a metric of metrics type: ").append(metric.metricType()).toString());
        metric.set((long)(v * (double)this.baseForAvgMetric()));
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.SUM_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createV2CustomMetric(SparkContext sc, CustomMetric customMetric) {
        void var3_3;
        SQLMetric acc = new SQLMetric(CustomMetrics$.MODULE$.buildV2CustomMetricTypeName(customMetric), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)customMetric.description()), false);
        return var3_3;
    }

    public SQLMetric createSizeMetric(SparkContext sc, String name, long initValue) {
        SQLMetric acc = new SQLMetric(this.SIZE_METRIC(), initValue);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public long createSizeMetric$default$3() {
        return -1L;
    }

    public SQLMetric createTimingMetric(SparkContext sc, String name, long initValue) {
        SQLMetric acc = new SQLMetric(this.TIMING_METRIC(), initValue);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public long createTimingMetric$default$3() {
        return -1L;
    }

    public SQLMetric createNanoTimingMetric(SparkContext sc, String name, long initValue) {
        SQLMetric acc = new SQLMetric(this.NS_TIMING_METRIC(), initValue);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public long createNanoTimingMetric$default$3() {
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public SQLMetric createAverageMetric(SparkContext sc, String name) {
        void var3_3;
        SQLMetric acc = new SQLMetric(this.AVERAGE_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return var3_3;
    }

    private String toNumberFormat(long value) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        return numberFormat.format((double)value / (double)this.baseForAvgMetric());
    }

    public boolean metricNeedsMax(String metricsType) {
        String string = metricsType;
        String string2 = this.SUM_METRIC();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private String METRICS_NAME_SUFFIX() {
        return METRICS_NAME_SUFFIX;
    }

    public String stringValue(String metricsType, long[] values, long[] maxMetrics) {
        String string;
        String taskInfo = ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(maxMetrics)) ? "(driver)" : new StringBuilder(16).append("(stage ").append(maxMetrics[1]).append(".").append(maxMetrics[2]).append(": task ").append(maxMetrics[3]).append(")").toString();
        String string2 = metricsType;
        String string3 = this.SUM_METRIC();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
            string = numberFormat.format(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(values).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        } else {
            String string4 = metricsType;
            String string5 = this.AVERAGE_METRIC();
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                long[] validValues = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(values), (Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 > 0L);
                if (validValues.length <= 1) {
                    string = this.toNumberFormat(BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.longArrayOps(validValues)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
                } else {
                    SeqOps seqOps;
                    Arrays.sort(validValues);
                    Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.toNumberFormat(validValues[0]), this.toNumberFormat(validValues[validValues.length / 2]), this.toNumberFormat(validValues[validValues.length - 1])}));
                    if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) {
                        throw new MatchError((Object)seq);
                    }
                    String min = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    String med = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    String max = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                    Tuple3 tuple3 = new Tuple3((Object)min, (Object)med, (Object)max);
                    Tuple3 tuple32 = tuple3;
                    String min2 = (String)tuple32._1();
                    String med2 = (String)tuple32._2();
                    String max2 = (String)tuple32._3();
                    string = new StringBuilder(9).append(this.METRICS_NAME_SUFFIX()).append(":\n(").append(min2).append(", ").append(med2).append(", ").append(max2).append(" ").append(taskInfo).append(")").toString();
                }
            } else {
                Function1 & Serializable intersect;
                String string6 = metricsType;
                String string7 = this.SIZE_METRIC();
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    intersect = (Function1 & Serializable)size -> Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)size));
                } else {
                    String string8 = metricsType;
                    String string9 = this.TIMING_METRIC();
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        intersect = (Function1 & Serializable)ms -> Utils$.MODULE$.msDurationToString(BoxesRunTime.unboxToLong((Object)ms));
                    } else {
                        String string10 = metricsType;
                        String string11 = this.NS_TIMING_METRIC();
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            intersect = (Function1 & Serializable)duration -> Utils$.MODULE$.msDurationToString(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(BoxesRunTime.unboxToLong((Object)duration))).nanos().toMillis());
                        } else {
                            throw new IllegalStateException(new StringBuilder(25).append("unexpected metrics type: ").append(metricsType).toString());
                        }
                    }
                }
                Function1 & Serializable strFormat = intersect;
                long[] validValues = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(values), (Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 >= 0L);
                if (validValues.length <= 1) {
                    string = (String)strFormat.apply(ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.longArrayOps(validValues)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                } else {
                    SeqOps seqOps;
                    Arrays.sort(validValues);
                    Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)strFormat.apply(Predef$.MODULE$.wrapLongArray(validValues).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[0])), (String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[validValues.length / 2])), (String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[validValues.length - 1]))}));
                    if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) != 0) {
                        throw new MatchError((Object)seq);
                    }
                    String sum = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    String min = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    String med = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                    String max = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
                    Tuple4 tuple4 = new Tuple4((Object)sum, (Object)min, (Object)med, (Object)max);
                    Tuple4 tuple42 = tuple4;
                    String sum2 = (String)tuple42._1();
                    String min3 = (String)tuple42._2();
                    String med3 = (String)tuple42._3();
                    String max3 = (String)tuple42._4();
                    string = new StringBuilder(15).append("total ").append(this.METRICS_NAME_SUFFIX()).append("\n").append(sum2).append(" (").append(min3).append(", ").append(med3).append(", ").append(max3).append(" ").append(taskInfo).append(")").toString();
                }
            }
        }
        return string;
    }

    public void postDriverMetricsUpdatedByValue(SparkContext sc, String executionId, Seq<Tuple2<Object, Object>> accumUpdates) {
        block0: {
            if (executionId == null) break block0;
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executionId)), accumUpdates));
        }
    }

    public void postDriverMetricUpdates(SparkContext sc, String executionId, Seq<SQLMetric> metrics) {
        block0: {
            if (executionId == null) break block0;
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executionId)), (Seq<Tuple2<Object, Object>>)((Seq)metrics.map((Function1 & Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value()))))));
        }
    }

    private SQLMetrics$() {
    }
}

