/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.mesos.MesosCoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.mesos.MesosFineGrainedSchedulerBackend;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005y3Q\u0001C\u0005\u0001\u001fUAQ\u0001\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00040\u0001\u0001\u0006Ia\n\u0005\u0006a\u0001!\t%\r\u0005\u0006\u0005\u0002!\te\u0011\u0005\u0006\u001d\u0002!\te\u0014\u0005\u0006-\u0002!\te\u0016\u0002\u0014\u001b\u0016\u001cxn]\"mkN$XM]'b]\u0006<WM\u001d\u0006\u0003\u0015-\tQ!\\3t_NT!\u0001D\u0007\u0002\u000f\rdWo\u001d;fe*\u0011abD\u0001\ng\u000eDW\rZ;mKJT!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\tQ\"\u0003\u0002 \u001b\t1R\t\u001f;fe:\fGn\u00117vgR,'/T1oC\u001e,'/\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005I\u0011aC'F'>\u001bvLU#H\u000bb+\u0012a\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\n\u0001\"\\1uG\"Lgn\u001a\u0006\u0003Ya\tA!\u001e;jY&\u0011a&\u000b\u0002\u0006%\u0016<W\r_\u0001\r\u001b\u0016\u001bvjU0S\u000b\u001e+\u0005\fI\u0001\nG\u0006t7I]3bi\u0016$\"AM\u001b\u0011\u0005]\u0019\u0014B\u0001\u001b\u0019\u0005\u001d\u0011un\u001c7fC:DQA\u000e\u0003A\u0002]\n\u0011\"\\1ti\u0016\u0014XK\u0015'\u0011\u0005azdBA\u001d>!\tQ\u0004$D\u0001<\u0015\ta\u0014%\u0001\u0004=e>|GOP\u0005\u0003}a\ta\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011a\bG\u0001\u0014GJ,\u0017\r^3UCN\\7k\u00195fIVdWM\u001d\u000b\u0004\t\u001ek\u0005CA\u000fF\u0013\t1UBA\u0007UCN\\7k\u00195fIVdWM\u001d\u0005\u0006\u0011\u0016\u0001\r!S\u0001\u0003g\u000e\u0004\"AS&\u000e\u0003=I!\u0001T\b\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000bY*\u0001\u0019A\u001c\u0002-\r\u0014X-\u0019;f'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012$B\u0001U*U+B\u0011Q$U\u0005\u0003%6\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\t\u000b!3\u0001\u0019A%\t\u000bY2\u0001\u0019A\u001c\t\u000b91\u0001\u0019\u0001#\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002Y7r\u0003\"aF-\n\u0005iC\"\u0001B+oSRDQAD\u0004A\u0002\u0011CQ!X\u0004A\u0002A\u000bqAY1dW\u0016tG\r")
public class MesosClusterManager
implements ExternalClusterManager {
    private final Regex MESOS_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("mesos://(.*)"));

    private Regex MESOS_REGEX() {
        return this.MESOS_REGEX;
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("mesos");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        return new TaskSchedulerImpl(sc);
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        Predef$.MODULE$.require(!BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.IO_ENCRYPTION_ENABLED())), (Function0 & Serializable)() -> "I/O encryption is currently not supported in Mesos.");
        String mesosUrl = ((Regex.MatchData)this.MESOS_REGEX().findFirstMatchIn((CharSequence)masterURL).get()).group(1);
        boolean coarse = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(org.apache.spark.deploy.mesos.config.package$.MODULE$.COARSE_MODE()));
        return coarse ? new MesosCoarseGrainedSchedulerBackend((TaskSchedulerImpl)scheduler, sc, mesosUrl, sc.env().securityManager()) : new MesosFineGrainedSchedulerBackend((TaskSchedulerImpl)scheduler, sc, mesosUrl);
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }
}

